/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.AlertListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.DialogCloseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Window;

public class Alert
extends Dialog {
    private MessageType type = null;
    private String message = null;
    private Component body = null;
    private ArrayList<Object> options = null;
    private int selectedOption = -1;
    private AlertListenerList alertListeners = new AlertListenerList();
    private static Resources resources = null;

    public Alert(MessageType messageType, String string, Sequence<?> sequence) {
        this(messageType, string, sequence, null);
    }

    public Alert(MessageType messageType, String string, Sequence<?> sequence, Component component) {
        if (messageType == null) {
            throw new IllegalArgumentException("type is null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("options is null.");
        }
        this.type = messageType;
        this.message = string;
        this.options = new ArrayList(sequence);
        this.body = component;
        this.installThemeSkin(Alert.class);
    }

    public MessageType getMessageType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getOption(int n) {
        return this.options.get(n);
    }

    public int getOptionCount() {
        return this.options.getLength();
    }

    public Component getBody() {
        return this.body;
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(int n) {
        if (n < -1 || n > this.options.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedOption;
        if (n != n2) {
            this.selectedOption = n;
            this.alertListeners.selectedOptionChanged(this, n2);
        }
    }

    public ListenerList<AlertListener> getAlertListeners() {
        return this.alertListeners;
    }

    public static void alert(String string, Display display) {
        Alert.alert(MessageType.INFO, string, null, display, null);
    }

    public static void alert(MessageType messageType, String string, Display display) {
        Alert.alert(messageType, string, null, display, null);
    }

    public static void alert(MessageType messageType, String string, Component component, Display display) {
        Alert.alert(messageType, string, component, display, null);
    }

    public static void alert(MessageType messageType, String string, Component component, Display display, DialogCloseListener dialogCloseListener) {
        Alert alert = Alert.createAlert(messageType, string, component);
        alert.open(display, dialogCloseListener);
    }

    public static void alert(String string, Window window) {
        Alert.alert(MessageType.INFO, string, null, window, null);
    }

    public static void alert(MessageType messageType, String string, Window window) {
        Alert.alert(messageType, string, null, window, null);
    }

    public static void alert(MessageType messageType, String string, Component component, Window window) {
        Alert.alert(messageType, string, component, window, null);
    }

    public static void alert(MessageType messageType, String string, Component component, Window window, DialogCloseListener dialogCloseListener) {
        Alert alert = Alert.createAlert(messageType, string, component);
        alert.open(window.getDisplay(), window, true, dialogCloseListener);
    }

    private static Alert createAlert(MessageType messageType, String string, Component component) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(resources.get("defaultOption"));
        Alert alert = new Alert(messageType, string, (Sequence<?>)arrayList, component);
        alert.setTitle((String)resources.get("defaultTitle"));
        alert.setSelectedOption(0);
        return alert;
    }

    static {
        try {
            resources = new Resources(Alert.class.getName());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class AlertListenerList
    extends ListenerList<AlertListener>
    implements AlertListener {
        private AlertListenerList() {
        }

        @Override
        public void selectedOptionChanged(Alert alert, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AlertListener alertListener = (AlertListener)iterator.next();
                alertListener.selectedOptionChanged(alert, n);
            }
        }
    }
}

