/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BorderListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;

public class Border
extends Container {
    private String title = null;
    private Component content = null;
    private BorderListenerList borderListeners = new BorderListenerList();

    public Border() {
        this(null);
    }

    public Border(Component component) {
        this.installThemeSkin(Border.class);
        this.setContent(component);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        if (string2 != string) {
            this.title = string;
            this.borderListeners.titleChanged(this, string2);
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component component) {
        Component component2 = this.content;
        if (component != component2) {
            this.content = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.add(component);
            }
            this.content = component;
            this.borderListeners.contentChanged(this, component2);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<BorderListener> getBorderListeners() {
        return this.borderListeners;
    }

    private static class BorderListenerList
    extends ListenerList<BorderListener>
    implements BorderListener {
        private BorderListenerList() {
        }

        @Override
        public void titleChanged(Border border, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BorderListener borderListener = (BorderListener)iterator.next();
                borderListener.titleChanged(border, string);
            }
        }

        @Override
        public void contentChanged(Border border, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BorderListener borderListener = (BorderListener)iterator.next();
                borderListener.contentChanged(border, component);
            }
        }
    }
}

