/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.ActionListener;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonListener;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.ButtonStateListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Renderer;

public abstract class Button
extends Component {
    private Object buttonData = null;
    private DataRenderer dataRenderer = null;
    private Action action = null;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void enabledChanged(Action action) {
            Button.this.setEnabled(action.isEnabled());
        }
    };
    private State state = State.UNSELECTED;
    private boolean toggleButton = false;
    private boolean triState = false;
    private ButtonGroup buttonGroup = null;
    private String selectedKey = null;
    private String stateKey = null;
    private ButtonListenerList buttonListeners = new ButtonListenerList();
    private ButtonStateListenerList buttonStateListeners = new ButtonStateListenerList();
    private ButtonPressListenerList buttonPressListeners = new ButtonPressListenerList();

    public Button() {
        this(null);
    }

    public Button(Object object) {
        this.buttonData = object;
    }

    public Object getButtonData() {
        return this.buttonData;
    }

    public void setButtonData(Object object) {
        Object object2 = this.buttonData;
        if (object2 != object) {
            this.buttonData = object;
            this.buttonListeners.buttonDataChanged(this, object2);
        }
    }

    public DataRenderer getDataRenderer() {
        return this.dataRenderer;
    }

    public void setDataRenderer(DataRenderer dataRenderer) {
        if (dataRenderer == null) {
            throw new IllegalArgumentException("dataRenderer is null.");
        }
        DataRenderer dataRenderer2 = this.dataRenderer;
        if (dataRenderer2 != dataRenderer) {
            this.dataRenderer = dataRenderer;
            this.buttonListeners.dataRendererChanged(this, dataRenderer2);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        Action action2 = this.action;
        if (action2 != action) {
            if (action2 != null) {
                action2.getActionListeners().remove((Object)this.actionListener);
            }
            this.action = action;
            if (action != null) {
                action.getActionListeners().add((Object)this.actionListener);
                this.setEnabled(action.isEnabled());
            }
            this.buttonListeners.actionChanged(this, action2);
        }
    }

    public void setAction(String string) {
        if (string == null) {
            throw new IllegalArgumentException("actionID is null");
        }
        Action action = Action.getNamedActions().get(string);
        if (action == null) {
            throw new IllegalArgumentException("An action with ID " + string + " does not exist.");
        }
        this.setAction(action);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.action != null && bl != this.action.isEnabled()) {
            throw new IllegalArgumentException("Button and action enabled states are not consistent.");
        }
        super.setEnabled(bl);
    }

    public void press() {
        this.buttonPressListeners.buttonPressed(this);
        if (this.action != null) {
            this.action.perform();
        }
    }

    public boolean isSelected() {
        return this.getState() == State.SELECTED;
    }

    public void setSelected(boolean bl) {
        this.setState(bl ? State.SELECTED : State.UNSELECTED);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state is null.");
        }
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (state == State.MIXED && !this.triState) {
            throw new IllegalArgumentException("Button is not tri-state.");
        }
        State state2 = this.state;
        if (state2 != state) {
            this.state = state;
            if (this.buttonGroup != null) {
                if (state == State.SELECTED) {
                    this.buttonGroup.setSelection(this);
                } else if (this.buttonGroup.getSelection() == this) {
                    this.buttonGroup.setSelection(null);
                }
            }
            this.buttonStateListeners.stateChanged(this, state2);
        }
    }

    public void setState(String string) {
        if (string == null) {
            throw new IllegalArgumentException("state is null.");
        }
        this.setState(State.valueOf(string.toUpperCase()));
    }

    public boolean isToggleButton() {
        return this.toggleButton;
    }

    public void setToggleButton(boolean bl) {
        if (this.toggleButton != bl) {
            if (!bl) {
                this.setSelected(false);
                this.setButtonGroup(null);
                this.setTriState(false);
            }
            this.toggleButton = bl;
            this.buttonListeners.toggleButtonChanged(this);
        }
    }

    public boolean isTriState() {
        return this.triState;
    }

    public void setTriState(boolean bl) {
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (bl && this.buttonGroup != null) {
            throw new IllegalStateException("Toggle button is a member of a group.");
        }
        if (this.triState != bl) {
            this.triState = bl;
            this.buttonListeners.triStateChanged(this);
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (buttonGroup != null && this.triState) {
            throw new IllegalStateException("Toggle button is tri-state.");
        }
        ButtonGroup buttonGroup2 = this.buttonGroup;
        if (buttonGroup2 != buttonGroup) {
            this.buttonGroup = buttonGroup;
            if (buttonGroup2 != null) {
                buttonGroup2.remove(this);
            }
            if (buttonGroup != null) {
                buttonGroup.add(this);
            }
            this.buttonListeners.buttonGroupChanged(this, buttonGroup2);
        }
    }

    public String getSelectedKey() {
        return this.selectedKey;
    }

    public void setSelectedKey(String string) {
        String string2 = this.selectedKey;
        if (string2 != string) {
            this.selectedKey = string;
            this.buttonListeners.selectedKeyChanged(this, string2);
        }
    }

    public String getStateKey() {
        return this.stateKey;
    }

    public void setStateKey(String string) {
        String string2 = this.stateKey;
        if (string2 != string) {
            this.stateKey = string;
            this.buttonListeners.stateKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        Object object;
        if (this.selectedKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedKey)) {
            object = JSONSerializer.get(dictionary, (String)this.selectedKey);
            if (object instanceof Boolean) {
                this.setSelected((Boolean)object);
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + " can't bind to " + object + ".");
            }
        }
        if (this.stateKey != null && JSONSerializer.containsKey(dictionary, (String)this.stateKey)) {
            object = JSONSerializer.get(dictionary, (String)this.stateKey);
            if (object instanceof State) {
                this.setState((State)((Object)object));
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + " can't bind to " + object + ".");
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled()) {
            if (this.selectedKey != null) {
                JSONSerializer.put(dictionary, (String)this.selectedKey, (Object)this.isSelected());
            }
            if (this.stateKey != null) {
                JSONSerializer.put(dictionary, (String)this.stateKey, (Object)((Object)this.state));
            }
        }
    }

    @Override
    public void clear() {
        if (this.selectedKey != null || this.stateKey != null) {
            this.setSelected(false);
        }
    }

    public ListenerList<ButtonListener> getButtonListeners() {
        return this.buttonListeners;
    }

    public ListenerList<ButtonStateListener> getButtonStateListeners() {
        return this.buttonStateListeners;
    }

    public ListenerList<ButtonPressListener> getButtonPressListeners() {
        return this.buttonPressListeners;
    }

    private static class ButtonPressListenerList
    extends ListenerList<ButtonPressListener>
    implements ButtonPressListener {
        private ButtonPressListenerList() {
        }

        @Override
        public void buttonPressed(Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonPressListener buttonPressListener = (ButtonPressListener)iterator.next();
                buttonPressListener.buttonPressed(button);
            }
        }
    }

    private static class ButtonStateListenerList
    extends ListenerList<ButtonStateListener>
    implements ButtonStateListener {
        private ButtonStateListenerList() {
        }

        @Override
        public void stateChanged(Button button, State state) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonStateListener buttonStateListener = (ButtonStateListener)iterator.next();
                buttonStateListener.stateChanged(button, state);
            }
        }
    }

    private static class ButtonListenerList
    extends ListenerList<ButtonListener>
    implements ButtonListener {
        private ButtonListenerList() {
        }

        @Override
        public void buttonDataChanged(Button button, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.buttonDataChanged(button, object);
            }
        }

        @Override
        public void dataRendererChanged(Button button, DataRenderer dataRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.dataRendererChanged(button, dataRenderer);
            }
        }

        @Override
        public void actionChanged(Button button, Action action) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.actionChanged(button, action);
            }
        }

        @Override
        public void toggleButtonChanged(Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.toggleButtonChanged(button);
            }
        }

        @Override
        public void triStateChanged(Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.triStateChanged(button);
            }
        }

        @Override
        public void buttonGroupChanged(Button button, ButtonGroup buttonGroup) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.buttonGroupChanged(button, buttonGroup);
            }
        }

        @Override
        public void selectedKeyChanged(Button button, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.selectedKeyChanged(button, string);
            }
        }

        @Override
        public void stateKeyChanged(Button button, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonListener buttonListener = (ButtonListener)iterator.next();
                buttonListener.stateKeyChanged(button, string);
            }
        }
    }

    public static interface DataRenderer
    extends Renderer {
        public void render(Object var1, Button var2, boolean var3);
    }

    public static enum State {
        SELECTED,
        UNSELECTED,
        MIXED;

    }
}

