/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Group;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroupListener;

public class ButtonGroup
implements Group<Button>,
Iterable<Button> {
    private HashSet<Button> buttons = new HashSet();
    private Button selection = null;
    private ButtonGroupListenerList buttonGroupListeners = new ButtonGroupListenerList();

    public boolean add(Button button) {
        boolean bl = false;
        if (!this.contains(button)) {
            this.buttons.add((Object)button);
            bl = true;
            if (button.isSelected()) {
                if (this.selection == null) {
                    this.selection = button;
                } else {
                    button.setSelected(false);
                }
            }
            button.setButtonGroup(this);
            this.buttonGroupListeners.buttonAdded(this, button);
        }
        return bl;
    }

    public boolean remove(Button button) {
        boolean bl = false;
        if (this.contains(button)) {
            this.buttons.remove((Object)button);
            bl = true;
            if (button.isSelected()) {
                this.selection = null;
            }
            button.setButtonGroup(null);
            this.buttonGroupListeners.buttonRemoved(this, button);
        }
        return bl;
    }

    public boolean contains(Button button) {
        return this.buttons.contains((Object)button);
    }

    public Button getSelection() {
        return this.selection;
    }

    public void setSelection(Button button) {
        if (button != null && button.getButtonGroup() != this) {
            throw new IllegalArgumentException();
        }
        Button button2 = this.selection;
        if (button2 != button) {
            this.selection = button;
            if (button2 != null) {
                button2.setSelected(false);
            }
            if (button != null) {
                button.setSelected(true);
            }
            this.buttonGroupListeners.selectionChanged(this, button2);
        }
    }

    @Override
    public Iterator<Button> iterator() {
        return new ImmutableIterator(this.buttons.iterator());
    }

    public ListenerList<ButtonGroupListener> getButtonGroupListeners() {
        return this.buttonGroupListeners;
    }

    private static class ButtonGroupListenerList
    extends ListenerList<ButtonGroupListener>
    implements ButtonGroupListener {
        private ButtonGroupListenerList() {
        }

        @Override
        public void buttonAdded(ButtonGroup buttonGroup, Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonGroupListener buttonGroupListener = (ButtonGroupListener)iterator.next();
                buttonGroupListener.buttonAdded(buttonGroup, button);
            }
        }

        @Override
        public void buttonRemoved(ButtonGroup buttonGroup, Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonGroupListener buttonGroupListener = (ButtonGroupListener)iterator.next();
                buttonGroupListener.buttonRemoved(buttonGroup, button);
            }
        }

        @Override
        public void selectionChanged(ButtonGroup buttonGroup, Button button) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ButtonGroupListener buttonGroupListener = (ButtonGroupListener)iterator.next();
                buttonGroupListener.selectionChanged(buttonGroup, button);
            }
        }
    }
}

