/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.CalendarButtonListener;
import org.apache.pivot.wtk.CalendarButtonSelectionListener;
import org.apache.pivot.wtk.content.CalendarButtonDataRenderer;

public class CalendarButton
extends Button {
    private CalendarDate selectedDate = null;
    private Locale locale = Locale.getDefault();
    private Filter<CalendarDate> disabledDateFilter = null;
    private String selectedDateKey = null;
    private CalendarButtonListenerList calendarButtonListeners = new CalendarButtonListenerList();
    private CalendarButtonSelectionListenerList calendarButtonSelectionListeners = new CalendarButtonSelectionListenerList();
    public static final String LANGUAGE_KEY = "language";
    public static final String COUNTRY_KEY = "country";
    public static final String VARIANT_KEY = "variant";
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new CalendarButtonDataRenderer();

    public CalendarButton() {
        this(null);
    }

    public CalendarButton(Object object) {
        super(object);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installThemeSkin(CalendarButton.class);
        this.setSelectedDate(new CalendarDate());
    }

    @Override
    public void setToggleButton(boolean bl) {
        throw new UnsupportedOperationException("Calendar buttons cannot be toggle buttons.");
    }

    public CalendarDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(CalendarDate calendarDate) {
        CalendarDate calendarDate2 = this.selectedDate;
        if (calendarDate2 != calendarDate) {
            this.selectedDate = calendarDate;
            this.calendarButtonSelectionListeners.selectedDateChanged(this, calendarDate2);
        }
    }

    public final void setSelectedDate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedDate is null.");
        }
        this.setSelectedDate(CalendarDate.decode((String)string));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        Locale locale2 = this.locale;
        if (locale2 != locale) {
            this.locale = locale;
            this.calendarButtonListeners.localeChanged(this, locale2);
        }
    }

    public void setLocale(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        String string = (String)dictionary.get((Object)LANGUAGE_KEY);
        String string2 = (String)dictionary.get((Object)COUNTRY_KEY);
        String string3 = (String)dictionary.get((Object)VARIANT_KEY);
        if (string3 != null) {
            this.setLocale(new Locale(string, string2, string3));
        } else if (string2 != null) {
            this.setLocale(new Locale(string, string2));
        } else {
            this.setLocale(new Locale(string));
        }
    }

    public void setLocale(String string) {
        if (string == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        try {
            this.setLocale((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    public Filter<CalendarDate> getDisabledDateFilter() {
        return this.disabledDateFilter;
    }

    public void setDisabledDateFilter(Filter<CalendarDate> filter) {
        Filter<CalendarDate> filter2 = this.disabledDateFilter;
        if (filter2 != filter) {
            this.disabledDateFilter = filter;
            this.calendarButtonListeners.disabledDateFilterChanged(this, filter2);
        }
    }

    public String getSelectedDateKey() {
        return this.selectedDateKey;
    }

    public void setSelectedDateKey(String string) {
        String string2 = this.selectedDateKey;
        if (string2 != string) {
            this.selectedDateKey = string;
            this.calendarButtonListeners.selectedDateKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        String string = this.getSelectedDateKey();
        if (string != null && JSONSerializer.containsKey(dictionary, (String)string)) {
            Object object = JSONSerializer.get(dictionary, (String)string);
            if (object instanceof CalendarDate) {
                this.setSelectedDate((CalendarDate)object);
            } else if (object instanceof String) {
                this.setSelectedDate((String)object);
            } else {
                throw new IllegalArgumentException("Invalid date type: " + object.getClass().getName());
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedDateKey != null) {
            JSONSerializer.put(dictionary, (String)this.selectedDateKey, (Object)this.selectedDate);
        }
    }

    @Override
    public void clear() {
        if (this.selectedDateKey != null) {
            this.setSelectedDate((CalendarDate)null);
        }
    }

    public ListenerList<CalendarButtonListener> getCalendarButtonListeners() {
        return this.calendarButtonListeners;
    }

    public ListenerList<CalendarButtonSelectionListener> getCalendarButtonSelectionListeners() {
        return this.calendarButtonSelectionListeners;
    }

    private static class CalendarButtonSelectionListenerList
    extends ListenerList<CalendarButtonSelectionListener>
    implements CalendarButtonSelectionListener {
        private CalendarButtonSelectionListenerList() {
        }

        @Override
        public void selectedDateChanged(CalendarButton calendarButton, CalendarDate calendarDate) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarButtonSelectionListener calendarButtonSelectionListener = (CalendarButtonSelectionListener)iterator.next();
                calendarButtonSelectionListener.selectedDateChanged(calendarButton, calendarDate);
            }
        }
    }

    private static class CalendarButtonListenerList
    extends ListenerList<CalendarButtonListener>
    implements CalendarButtonListener {
        private CalendarButtonListenerList() {
        }

        @Override
        public void localeChanged(CalendarButton calendarButton, Locale locale) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarButtonListener calendarButtonListener = (CalendarButtonListener)iterator.next();
                calendarButtonListener.localeChanged(calendarButton, locale);
            }
        }

        @Override
        public void disabledDateFilterChanged(CalendarButton calendarButton, Filter<CalendarDate> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarButtonListener calendarButtonListener = (CalendarButtonListener)iterator.next();
                calendarButtonListener.disabledDateFilterChanged(calendarButton, filter);
            }
        }

        @Override
        public void selectedDateKeyChanged(CalendarButton calendarButton, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarButtonListener calendarButtonListener = (CalendarButtonListener)iterator.next();
                calendarButtonListener.selectedDateKeyChanged(calendarButton, string);
            }
        }
    }
}

