/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;

public class CardPane
extends Container {
    private int selectedIndex = -1;
    private CardPaneListenerList cardPaneListeners = new CardPaneListenerList();

    public CardPane() {
        this.installThemeSkin(CardPane.class);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedIndex;
        if (n2 != n) {
            Vote vote = this.cardPaneListeners.previewSelectedIndexChange(this, n);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = n;
                this.cardPaneListeners.selectedIndexChanged(this, n2);
            } else {
                this.cardPaneListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedCard() {
        return this.selectedIndex == -1 ? null : this.get(this.selectedIndex);
    }

    @Override
    public void insert(Component component, int n) {
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        super.insert(component, n);
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        if (this.selectedIndex >= n) {
            this.selectedIndex = this.selectedIndex < n + n2 ? -1 : (this.selectedIndex -= n2);
        }
        return super.remove(n, n2);
    }

    public ListenerList<CardPaneListener> getCardPaneListeners() {
        return this.cardPaneListeners;
    }

    private static class CardPaneListenerList
    extends ListenerList<CardPaneListener>
    implements CardPaneListener {
        private CardPaneListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(CardPane cardPane, int n) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CardPaneListener cardPaneListener = (CardPaneListener)iterator.next();
                vote = vote.tally(cardPaneListener.previewSelectedIndexChange(cardPane, n));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(CardPane cardPane, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CardPaneListener cardPaneListener = (CardPaneListener)iterator.next();
                cardPaneListener.selectedIndexChangeVetoed(cardPane, vote);
            }
        }

        @Override
        public void selectedIndexChanged(CardPane cardPane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CardPaneListener cardPaneListener = (CardPaneListener)iterator.next();
                cardPaneListener.selectedIndexChanged(cardPane, n);
            }
        }
    }
}

