/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ColorChooserButtonListener;
import org.apache.pivot.wtk.ColorChooserButtonSelectionListener;
import org.apache.pivot.wtk.content.ListButtonColorItemRenderer;

public class ColorChooserButton
extends Button {
    private Color selectedColor = null;
    private String selectedColorKey = null;
    private ColorChooserButtonListenerList colorChooserButtonListeners = new ColorChooserButtonListenerList();
    private ColorChooserButtonSelectionListenerList colorChooserButtonSelectionListeners = new ColorChooserButtonSelectionListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ListButtonColorItemRenderer();

    public ColorChooserButton() {
        this(null);
    }

    public ColorChooserButton(Object object) {
        super(object);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installThemeSkin(ColorChooserButton.class);
    }

    @Override
    public void setToggleButton(boolean bl) {
        throw new UnsupportedOperationException("Color chooser buttons cannot be toggle buttons.");
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        Color color2 = this.selectedColor;
        if (color2 != color) {
            this.selectedColor = color;
            this.colorChooserButtonSelectionListeners.selectedColorChanged(this, color2);
        }
    }

    public final void setSelectedColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedColor is null.");
        }
        this.setSelectedColor(Color.decode(string));
    }

    public String getSelectedColorKey() {
        return this.selectedColorKey;
    }

    public void setSelectedColorKey(String string) {
        String string2 = this.selectedColorKey;
        if (string2 != string) {
            this.selectedColorKey = string;
            this.colorChooserButtonListeners.selectedColorKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        String string = this.getSelectedColorKey();
        if (string != null && JSONSerializer.containsKey(dictionary, (String)string)) {
            Object object = JSONSerializer.get(dictionary, (String)string);
            if (object instanceof Color) {
                this.setSelectedColor((Color)object);
            } else if (object instanceof String) {
                this.setSelectedColor((String)object);
            } else {
                throw new IllegalArgumentException("Invalid color type: " + object.getClass().getName());
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedColorKey != null) {
            JSONSerializer.put(dictionary, (String)this.selectedColorKey, (Object)this.selectedColor);
        }
    }

    @Override
    public void clear() {
        if (this.selectedColorKey != null) {
            this.setSelectedColor((Color)null);
        }
    }

    public ListenerList<ColorChooserButtonListener> getColorChooserButtonListeners() {
        return this.colorChooserButtonListeners;
    }

    public ListenerList<ColorChooserButtonSelectionListener> getColorChooserButtonSelectionListeners() {
        return this.colorChooserButtonSelectionListeners;
    }

    private static class ColorChooserButtonSelectionListenerList
    extends ListenerList<ColorChooserButtonSelectionListener>
    implements ColorChooserButtonSelectionListener {
        private ColorChooserButtonSelectionListenerList() {
        }

        @Override
        public void selectedColorChanged(ColorChooserButton colorChooserButton, Color color) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ColorChooserButtonSelectionListener colorChooserButtonSelectionListener = (ColorChooserButtonSelectionListener)iterator.next();
                colorChooserButtonSelectionListener.selectedColorChanged(colorChooserButton, color);
            }
        }
    }

    private static class ColorChooserButtonListenerList
    extends ListenerList<ColorChooserButtonListener>
    implements ColorChooserButtonListener {
        private ColorChooserButtonListenerList() {
        }

        @Override
        public void selectedColorKeyChanged(ColorChooserButton colorChooserButton, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ColorChooserButtonListener colorChooserButtonListener = (ColorChooserButtonListener)iterator.next();
                colorChooserButtonListener.selectedColorKeyChanged(colorChooserButton, string);
            }
        }
    }
}

