/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.effects.Decorator;

public abstract class Container
extends Component
implements Sequence<Component>,
Iterable<Component> {
    private ArrayList<Component> components = new ArrayList();
    private FocusTraversalPolicy focusTraversalPolicy = null;
    private String contextKey = null;
    private Component mouseOverComponent = null;
    private boolean mouseDown = false;
    private Component mouseDownComponent = null;
    private long mouseDownTime = 0L;
    private int mouseClickCount = 0;
    private boolean mouseClickConsumed = false;
    private ContainerListenerList containerListeners = new ContainerListenerList();
    private ContainerMouseListenerList containerMouseListeners = new ContainerMouseListenerList();

    public final int add(Component component) {
        int n = this.getLength();
        this.insert(component, n);
        return n;
    }

    public void insert(Component component, int n) {
        if (component == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (component instanceof Container && ((Container)component).isAncestor(this)) {
            throw new IllegalArgumentException("Component already exists in ancestry.");
        }
        if (component.getParent() != null) {
            throw new IllegalArgumentException("Component already has a parent.");
        }
        component.setParent(this);
        this.components.insert((Object)component, n);
        this.repaint(component.getDecoratedBounds());
        this.invalidate();
        this.containerListeners.componentInserted(this, n);
    }

    public Component update(int n, Component component) {
        throw new UnsupportedOperationException();
    }

    public final int remove(Component component) {
        int n = this.indexOf(component);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    public Sequence<Component> remove(int n, int n2) {
        Sequence sequence = this.components.remove(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Component component = (Component)sequence.get(i);
            if (component == this.mouseOverComponent) {
                if (this.mouseOverComponent.isMouseOver()) {
                    this.mouseOverComponent.mouseOut();
                }
                this.mouseOverComponent = null;
                Mouse.setCursor(this);
            }
            this.repaint(component.getDecoratedBounds());
            component.setParent(null);
        }
        if (sequence.getLength() > 0) {
            this.invalidate();
            this.containerListeners.componentsRemoved(this, n, (Sequence<Component>)sequence);
        }
        return sequence;
    }

    public final Sequence<Component> removeAll() {
        return this.remove(0, this.getLength());
    }

    public void move(int n, int n2) {
        if (n != n2) {
            int n3 = this.components.getLength();
            if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3) {
                throw new IndexOutOfBoundsException();
            }
            Sequence sequence = this.components.remove(n, 1);
            Component component = (Component)sequence.get(0);
            this.components.insert((Object)component, n2);
            this.repaint(component.getDecoratedBounds());
            this.containerListeners.componentMoved(this, n, n2);
        }
    }

    public Component get(int n) {
        return (Component)this.components.get(n);
    }

    public int indexOf(Component component) {
        return this.components.indexOf((Object)component);
    }

    public int getLength() {
        return this.components.getLength();
    }

    @Override
    public Iterator<Component> iterator() {
        return new ImmutableIterator((Iterator)this.components.iterator());
    }

    @Override
    protected void setParent(Container container) {
        if (container == null && this.containsFocus()) {
            Container.clearFocus();
        }
        super.setParent(container);
    }

    public Component getComponentAt(int n, int n2) {
        Bounds bounds;
        int n3;
        Component component = null;
        for (n3 = this.components.getLength() - 1; !(n3 < 0 || (component = (Component)this.components.get(n3)).isVisible() && (bounds = component.getBounds()).contains(n, n2)); --n3) {
        }
        if (n3 < 0) {
            component = null;
        }
        return component;
    }

    public Component getDescendantAt(int n, int n2) {
        Component component = this.getComponentAt(n, n2);
        if (component instanceof Container) {
            Container container = (Container)component;
            component = container.getDescendantAt(n - container.getX(), n2 - container.getY());
        }
        if (component == null) {
            component = this;
        }
        return component;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl && this.containsFocus()) {
            Container.clearFocus();
        }
        super.setVisible(bl);
    }

    @Override
    protected void layout() {
        super.layout();
        int n = this.components.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = (Component)this.components.get(i);
            component.validate();
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Component component;
        int n;
        int n2 = this.getLength();
        Bounds bounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            bounds = bounds.intersect(new Bounds(rectangle));
        }
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            component = this.get(n);
            if (!component.isVisible() || !component.isOpaque() || !component.getBounds().contains(bounds)) continue;
            bl = false;
            break;
        }
        if (bl) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            super.paint(graphics2D2);
            graphics2D2.dispose();
        }
        for (n = 0; n < n2; ++n) {
            component = this.get(n);
            Bounds bounds2 = component.getDecoratedBounds();
            if (!component.isVisible() || !bounds2.intersects(bounds)) continue;
            Bounds bounds3 = component.getBounds();
            Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
            graphics2D3.translate(bounds3.x, bounds3.y);
            Component.DecoratorSequence decoratorSequence = component.getDecorators();
            int n3 = decoratorSequence.getLength();
            for (int i = n3 - 1; i >= 0; --i) {
                Decorator decorator = decoratorSequence.get(i);
                graphics2D3 = decorator.prepare(component, graphics2D3);
            }
            Graphics2D graphics2D4 = (Graphics2D)graphics2D3.create();
            graphics2D4.clipRect(0, 0, bounds3.width, bounds3.height);
            component.paint(graphics2D4);
            graphics2D4.dispose();
            for (int i = 0; i < n3; ++i) {
                Decorator decorator = decoratorSequence.get(i);
                decorator.update();
            }
        }
    }

    public boolean isAncestor(Component component) {
        boolean bl = false;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (component2 != this) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean requestFocus() {
        boolean bl = false;
        if (this.isFocusable()) {
            bl = super.requestFocus();
        } else if (this.focusTraversalPolicy != null) {
            Component component;
            Component component2 = component = this.focusTraversalPolicy.getNextComponent(this, null, Direction.FORWARD);
            while (component2 != null && !component2.requestFocus() && (component2 = this.focusTraversalPolicy.getNextComponent(this, component2, Direction.FORWARD)) != component) {
            }
            bl = component2 != null;
        }
        return bl;
    }

    public Component transferFocus(Component component, Direction direction) {
        if (this.focusTraversalPolicy == null) {
            component = this.transferFocus(direction);
        } else {
            do {
                if ((component = this.focusTraversalPolicy.getNextComponent(this, component, direction)) == null) continue;
                if (component.isFocusable()) {
                    component.requestFocus();
                    continue;
                }
                if (!(component instanceof Container)) continue;
                Container container = (Container)component;
                component = container.transferFocus(null, direction);
            } while (component != null && !component.isFocused());
            if (component == null) {
                component = this.transferFocus(direction);
            }
        }
        return component;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.focusTraversalPolicy;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2 = this.focusTraversalPolicy;
        if (focusTraversalPolicy2 != focusTraversalPolicy) {
            this.focusTraversalPolicy = focusTraversalPolicy;
            this.containerListeners.focusTraversalPolicyChanged(this, focusTraversalPolicy2);
        }
    }

    public boolean containsFocus() {
        Component component = Container.getFocusedComponent();
        return component != null && this.isAncestor(component);
    }

    protected void descendantAdded(Component component) {
        Container container = this.getParent();
        if (container != null) {
            container.descendantAdded(component);
        }
    }

    protected void descendantRemoved(Component component) {
        Container container = this.getParent();
        if (container != null) {
            container.descendantRemoved(component);
        }
    }

    protected void descendantGainedFocus(Component component, Component component2) {
        Container container = this.getParent();
        if (container != null) {
            container.descendantGainedFocus(component, component2);
        }
    }

    protected void descendantLostFocus(Component component) {
        Container container = this.getParent();
        if (container != null) {
            container.descendantLostFocus(component);
        }
    }

    public String getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(String string) {
        String string2 = this.contextKey;
        if (string2 != null && string != null && !string2.equals(string) || string2 != string) {
            this.contextKey = string;
            this.containerListeners.contextKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> object) {
        if (this.contextKey != null && object.containsKey((Object)this.contextKey)) {
            Object object2 = object.get((Object)this.contextKey);
            object = object2 instanceof Dictionary ? (Map)object2 : new BeanDictionary(object2);
        }
        for (Component component : this.components) {
            component.load((Dictionary<String, ?>)object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> object) {
        if (this.isEnabled()) {
            if (this.contextKey != null) {
                Object object2 = object.get((Object)this.contextKey);
                object = object2 instanceof Dictionary ? (Map)object2 : new BeanDictionary(object2);
            }
            for (Component component : this.components) {
                component.store((Dictionary<String, ?>)object);
            }
        }
    }

    @Override
    public void clear() {
        for (Component component : this.components) {
            component.clear();
        }
    }

    @Override
    protected boolean mouseMove(int n, int n2) {
        boolean bl = false;
        if (this.mouseOverComponent != null && !this.mouseOverComponent.isMouseOver()) {
            this.mouseOverComponent = null;
        }
        if (this.isEnabled()) {
            Component component = this.getComponentAt(n, n2);
            if (this.mouseOverComponent != component) {
                if (this.mouseOverComponent != null) {
                    this.mouseOverComponent.mouseOut();
                }
                this.mouseOverComponent = null;
                Mouse.setCursor(this);
            }
            if (!(bl = this.containerMouseListeners.mouseMove(this, n, n2))) {
                if (this.mouseOverComponent != component) {
                    this.mouseOverComponent = component;
                    if (this.mouseOverComponent != null) {
                        this.mouseOverComponent.mouseOver();
                        Mouse.setCursor(this.mouseOverComponent);
                    }
                }
                if (component != null) {
                    bl = component.mouseMove(n - component.getX(), n2 - component.getY());
                }
                if (!bl) {
                    bl = super.mouseMove(n, n2);
                }
            }
        }
        return bl;
    }

    @Override
    protected void mouseOut() {
        if (this.mouseOverComponent != null && this.mouseOverComponent.isMouseOver()) {
            this.mouseOverComponent.mouseOut();
        }
        this.mouseOverComponent = null;
        super.mouseOut();
    }

    @Override
    protected boolean mouseDown(Mouse.Button button, int n, int n2) {
        boolean bl = false;
        this.mouseDown = true;
        if (this.isEnabled() && !(bl = this.containerMouseListeners.mouseDown(this, button, n, n2))) {
            Component component = this.getComponentAt(n, n2);
            long l = System.currentTimeMillis();
            int n3 = Platform.getMultiClickInterval();
            if (this.mouseDownComponent == component && l - this.mouseDownTime < (long)n3) {
                ++this.mouseClickCount;
            } else {
                this.mouseDownTime = System.currentTimeMillis();
                this.mouseClickCount = 1;
            }
            this.mouseDownComponent = component;
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                bl = component.mouseDown(button, n - component.getX(), n2 - component.getY());
            }
            if (!bl) {
                bl = super.mouseDown(button, n, n2);
            }
        }
        return bl;
    }

    @Override
    protected boolean mouseUp(Mouse.Button button, int n, int n2) {
        boolean bl = false;
        if (this.isEnabled() && !(bl = this.containerMouseListeners.mouseUp(this, button, n, n2))) {
            Component component = this.getComponentAt(n, n2);
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                bl = component.mouseUp(button, n - component.getX(), n2 - component.getY());
            }
            if (!bl) {
                bl = super.mouseUp(button, n, n2);
            }
            if (this.mouseDown && component != null && component == this.mouseDownComponent && component.isEnabled() && component.isVisible()) {
                this.mouseClickConsumed = component.mouseClick(button, n - component.getX(), n2 - component.getY(), this.mouseClickCount);
            }
        }
        this.mouseDown = false;
        return bl;
    }

    @Override
    protected boolean mouseClick(Mouse.Button button, int n, int n2, int n3) {
        if (this.isEnabled() && !this.mouseClickConsumed) {
            this.mouseClickConsumed = super.mouseClick(button, n, n2, n3);
        }
        return this.mouseClickConsumed;
    }

    @Override
    protected boolean mouseWheel(Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.isEnabled() && !(bl = this.containerMouseListeners.mouseWheel(this, scrollType, n, n2, n3, n4))) {
            Component component = this.getComponentAt(n3, n4);
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                bl = component.mouseWheel(scrollType, n, n2, n3 - component.getX(), n4 - component.getY());
            }
            if (!bl) {
                bl = super.mouseWheel(scrollType, n, n2, n3, n4);
            }
        }
        return bl;
    }

    public ListenerList<ContainerListener> getContainerListeners() {
        return this.containerListeners;
    }

    public ListenerList<ContainerMouseListener> getContainerMouseListeners() {
        return this.containerMouseListeners;
    }

    private static class ContainerMouseListenerList
    extends ListenerList<ContainerMouseListener>
    implements ContainerMouseListener {
        private ContainerMouseListenerList() {
        }

        @Override
        public boolean mouseMove(Container container, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerMouseListener containerMouseListener = (ContainerMouseListener)iterator.next();
                bl |= containerMouseListener.mouseMove(container, n, n2);
            }
            return bl;
        }

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerMouseListener containerMouseListener = (ContainerMouseListener)iterator.next();
                bl |= containerMouseListener.mouseDown(container, button, n, n2);
            }
            return bl;
        }

        @Override
        public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerMouseListener containerMouseListener = (ContainerMouseListener)iterator.next();
                bl |= containerMouseListener.mouseUp(container, button, n, n2);
            }
            return bl;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerMouseListener containerMouseListener = (ContainerMouseListener)iterator.next();
                bl |= containerMouseListener.mouseWheel(container, scrollType, n, n2, n3, n4);
            }
            return bl;
        }
    }

    private static class ContainerListenerList
    extends ListenerList<ContainerListener>
    implements ContainerListener {
        private ContainerListenerList() {
        }

        @Override
        public void componentInserted(Container container, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerListener containerListener = (ContainerListener)iterator.next();
                containerListener.componentInserted(container, n);
            }
        }

        @Override
        public void componentsRemoved(Container container, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerListener containerListener = (ContainerListener)iterator.next();
                containerListener.componentsRemoved(container, n, sequence);
            }
        }

        @Override
        public void componentMoved(Container container, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerListener containerListener = (ContainerListener)iterator.next();
                containerListener.componentMoved(container, n, n2);
            }
        }

        @Override
        public void contextKeyChanged(Container container, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerListener containerListener = (ContainerListener)iterator.next();
                containerListener.contextKeyChanged(container, string);
            }
        }

        @Override
        public void focusTraversalPolicyChanged(Container container, FocusTraversalPolicy focusTraversalPolicy) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ContainerListener containerListener = (ContainerListener)iterator.next();
                containerListener.focusTraversalPolicyChanged(container, focusTraversalPolicy);
            }
        }
    }
}

