/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DialogCloseListener;
import org.apache.pivot.wtk.DialogStateListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.Window;

public class Dialog
extends Frame {
    private boolean modal = false;
    private DialogCloseListener dialogCloseListener = null;
    private boolean result = false;
    private boolean closing = false;
    private DialogStateListenerList dialogStateListeners = new DialogStateListenerList();

    public Dialog() {
        this(null, null);
    }

    public Dialog(String string) {
        this(string, null);
    }

    public Dialog(Component component) {
        this(null, component);
    }

    public Dialog(String string, Component component) {
        super(string, component);
        this.installThemeSkin(Dialog.class);
    }

    @Override
    public final void open(Display display, Window window) {
        this.open(display, window, window != null, null);
    }

    public final void open(Display display, DialogCloseListener dialogCloseListener) {
        this.open(display, null, false, dialogCloseListener);
    }

    public final void open(Window window, DialogCloseListener dialogCloseListener) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.open(window.getDisplay(), window, true, dialogCloseListener);
    }

    public void open(Display display, Window window, boolean bl, DialogCloseListener dialogCloseListener) {
        if (bl && window == null) {
            throw new IllegalArgumentException("Modal dialogs must have an owner.");
        }
        super.open(display, window);
        if (this.isOpen()) {
            this.modal = bl;
            this.dialogCloseListener = dialogCloseListener;
            this.result = false;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.dialogStateListeners.previewDialogClose(this, bl);
            if (vote == Vote.APPROVE) {
                Window window = this.getOwner();
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.result = bl;
                    boolean bl2 = this.modal;
                    this.modal = false;
                    if (window != null && window.isOpen()) {
                        window.moveToFront();
                    }
                    this.dialogStateListeners.dialogClosed(this, bl2);
                    if (this.dialogCloseListener != null) {
                        this.dialogCloseListener.dialogClosed(this, bl2);
                        this.dialogCloseListener = null;
                    }
                }
            } else {
                if (vote == Vote.DENY) {
                    this.closing = false;
                }
                this.dialogStateListeners.dialogCloseVetoed(this, vote);
            }
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public DialogCloseListener getDialogCloseListener() {
        return this.dialogCloseListener;
    }

    public boolean getResult() {
        return this.result;
    }

    public ListenerList<DialogStateListener> getDialogStateListeners() {
        return this.dialogStateListeners;
    }

    private static class DialogStateListenerList
    extends ListenerList<DialogStateListener>
    implements DialogStateListener {
        private DialogStateListenerList() {
        }

        @Override
        public Vote previewDialogClose(Dialog dialog, boolean bl) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DialogStateListener dialogStateListener = (DialogStateListener)iterator.next();
                vote = vote.tally(dialogStateListener.previewDialogClose(dialog, bl));
            }
            return vote;
        }

        @Override
        public void dialogCloseVetoed(Dialog dialog, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DialogStateListener dialogStateListener = (DialogStateListener)iterator.next();
                dialogStateListener.dialogCloseVetoed(dialog, vote);
            }
        }

        @Override
        public void dialogClosed(Dialog dialog, boolean bl) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DialogStateListener dialogStateListener = (DialogStateListener)iterator.next();
                dialogStateListener.dialogClosed(dialog, bl);
            }
        }
    }
}

