/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Dimensions
implements Serializable {
    private static final long serialVersionUID = -3644511824857807902L;
    public final int width;
    public final int height;
    public static final String WIDTH_KEY = "width";
    public static final String HEIGHT_KEY = "height";

    public Dimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Dimensions(Dimensions dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions is null.");
        }
        this.width = dimensions.width;
        this.height = dimensions.height;
    }

    public Dimensions(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dimensions is null.");
        }
        this.width = dictionary.containsKey((Object)WIDTH_KEY) ? (Integer)dictionary.get((Object)WIDTH_KEY) : 0;
        this.height = dictionary.containsKey((Object)HEIGHT_KEY) ? (Integer)dictionary.get((Object)HEIGHT_KEY) : 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Dimensions) {
            Dimensions dimensions = (Dimensions)object;
            bl = this.width == dimensions.width && this.height == dimensions.height;
        }
        return bl;
    }

    public int hashCode() {
        return this.width * this.height;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.width + "x" + this.height + "]";
    }

    public static Dimensions decode(String string) {
        Dimensions dimensions;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            dimensions = new Dimensions((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return dimensions;
    }
}

