/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.File;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FileBrowserListener;

public class FileBrowser
extends Container {
    private File rootDirectory;
    private FileList selectedFiles = new FileList();
    private boolean multiSelect = false;
    private Filter<File> disabledFileFilter = null;
    private FileBrowserListenerList fileBrowserListeners = new FileBrowserListenerList();

    public FileBrowser() {
        String string = System.getProperty("user.home");
        this.rootDirectory = new File(string);
        this.installThemeSkin(FileBrowser.class);
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            File file2 = this.rootDirectory;
            if (file2 != file) {
                this.rootDirectory = file;
                this.selectedFiles.clear();
                this.fileBrowserListeners.rootDirectoryChanged(this, file2);
            }
        } else {
            this.setRootDirectory(file.getParentFile());
        }
    }

    public boolean addSelectedFile(File file) {
        int n;
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (file.isAbsolute()) {
            if (!file.getParentFile().equals(this.rootDirectory)) {
                throw new IllegalArgumentException();
            }
        } else {
            file = new File(this.rootDirectory, file.getPath());
        }
        if ((n = this.selectedFiles.add(file)) != -1) {
            this.fileBrowserListeners.selectedFileAdded(this, file);
        }
        return n != -1;
    }

    public boolean removeSelectedFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        int n = this.selectedFiles.remove((Object)file);
        if (n != -1) {
            this.fileBrowserListeners.selectedFileRemoved(this, file);
        }
        return n != -1;
    }

    public File getSelectedFile() {
        if (this.multiSelect) {
            throw new IllegalStateException("File browser is not in single-select mode.");
        }
        return this.selectedFiles.getLength() == 0 ? null : (File)this.selectedFiles.get(0);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.clearSelection();
        } else {
            this.setSelectedFiles((Sequence<File>)new ArrayList((Object[])new File[]{file}));
        }
    }

    public Sequence<File> getSelectedFiles() {
        return new ImmutableList((List)this.selectedFiles);
    }

    public Sequence<File> setSelectedFiles(Sequence<File> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("selectedFiles is null.");
        }
        if (!this.multiSelect && sequence.getLength() > 1) {
            throw new IllegalArgumentException("Multi-select is not enabled.");
        }
        Sequence<File> sequence2 = this.getSelectedFiles();
        FileList fileList = new FileList();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            File file = (File)sequence.get(i);
            if (file == null) {
                throw new IllegalArgumentException("file is null.");
            }
            if (file.isAbsolute()) {
                if (!file.getParentFile().equals(this.rootDirectory)) {
                    throw new IllegalArgumentException("file is not a descendant of root directory.");
                }
            } else {
                file = new File(this.rootDirectory, file.getPath());
            }
            fileList.add(file);
        }
        this.selectedFiles = fileList;
        this.fileBrowserListeners.selectedFilesChanged(this, sequence2);
        return this.getSelectedFiles();
    }

    public void clearSelection() {
        this.setSelectedFiles((Sequence<File>)new ArrayList());
    }

    public boolean isFileSelected(File file) {
        return this.selectedFiles.indexOf((Object)file) != -1;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean bl) {
        if (this.multiSelect != bl) {
            this.selectedFiles.clear();
            this.multiSelect = bl;
            this.fileBrowserListeners.multiSelectChanged(this);
        }
    }

    public Filter<File> getDisabledFileFilter() {
        return this.disabledFileFilter;
    }

    public void setDisabledFileFilter(Filter<File> filter) {
        Filter<File> filter2 = this.disabledFileFilter;
        if (filter2 != filter) {
            this.disabledFileFilter = filter;
            this.fileBrowserListeners.disabledFileFilterChanged(this, filter2);
        }
    }

    public File getFileAt(int n, int n2) {
        Skin skin = (Skin)this.getSkin();
        return skin.getFileAt(n, n2);
    }

    public ListenerList<FileBrowserListener> getFileBrowserListeners() {
        return this.fileBrowserListeners;
    }

    private static class FileBrowserListenerList
    extends ListenerList<FileBrowserListener>
    implements FileBrowserListener {
        private FileBrowserListenerList() {
        }

        @Override
        public void rootDirectoryChanged(FileBrowser fileBrowser, File file) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.rootDirectoryChanged(fileBrowser, file);
            }
        }

        @Override
        public void selectedFileAdded(FileBrowser fileBrowser, File file) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.selectedFileAdded(fileBrowser, file);
            }
        }

        @Override
        public void selectedFileRemoved(FileBrowser fileBrowser, File file) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.selectedFileRemoved(fileBrowser, file);
            }
        }

        @Override
        public void selectedFilesChanged(FileBrowser fileBrowser, Sequence<File> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.selectedFilesChanged(fileBrowser, sequence);
            }
        }

        @Override
        public void multiSelectChanged(FileBrowser fileBrowser) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.multiSelectChanged(fileBrowser);
            }
        }

        @Override
        public void disabledFileFilterChanged(FileBrowser fileBrowser, Filter<File> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserListener fileBrowserListener = (FileBrowserListener)iterator.next();
                fileBrowserListener.disabledFileFilterChanged(fileBrowser, filter);
            }
        }
    }

    public static interface Skin
    extends org.apache.pivot.wtk.Skin {
        public File getFileAt(int var1, int var2);
    }
}

