/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.File;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.FileBrowserSheetListener;
import org.apache.pivot.wtk.Sheet;

public class FileBrowserSheet
extends Sheet {
    private Mode mode;
    private File rootDirectory;
    private FileList selectedFiles = new FileList();
    private Filter<File> disabledFileFilter = null;
    private FileBrowserSheetListenerList fileBrowserSheetListeners = new FileBrowserSheetListenerList();

    public FileBrowserSheet(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode is null.");
        }
        this.mode = mode;
        String string = System.getProperty("user.home");
        this.rootDirectory = new File(string);
        this.installThemeSkin(FileBrowserSheet.class);
    }

    public Mode getMode() {
        return this.mode;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File file) {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            File file2 = this.rootDirectory;
            if (file2 != file) {
                this.rootDirectory = file;
                this.selectedFiles.clear();
                this.fileBrowserSheetListeners.rootDirectoryChanged(this, file2);
            }
        } else {
            this.setRootDirectory(file.getParentFile());
        }
    }

    public File getSelectedFile() {
        if (this.mode == Mode.OPEN_MULTIPLE) {
            throw new IllegalStateException("File browser is not in single-select mode.");
        }
        return this.selectedFiles.getLength() == 0 ? null : (File)this.selectedFiles.get(0);
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.clearSelection();
        } else {
            this.setSelectedFiles((Sequence<File>)new ArrayList((Object[])new File[]{file}));
        }
    }

    public Sequence<File> getSelectedFiles() {
        return new ImmutableList((List)this.selectedFiles);
    }

    public Sequence<File> setSelectedFiles(Sequence<File> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("selectedFiles is null.");
        }
        if (this.mode != Mode.OPEN_MULTIPLE && sequence.getLength() > 1) {
            throw new IllegalArgumentException("Multi-select is not enabled.");
        }
        Sequence<File> sequence2 = this.getSelectedFiles();
        FileList fileList = new FileList();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            File file = (File)sequence.get(i);
            if (file == null) {
                throw new IllegalArgumentException("file is null.");
            }
            fileList.add(file);
        }
        this.selectedFiles = fileList;
        this.fileBrowserSheetListeners.selectedFilesChanged(this, sequence2);
        return this.getSelectedFiles();
    }

    public void clearSelection() {
        this.setSelectedFiles((Sequence<File>)new ArrayList());
    }

    public Filter<File> getDisabledFileFilter() {
        return this.disabledFileFilter;
    }

    public void setDisabledFileFilter(Filter<File> filter) {
        Filter<File> filter2 = this.disabledFileFilter;
        if (filter2 != filter) {
            this.disabledFileFilter = filter;
            this.fileBrowserSheetListeners.disabledFileFilterChanged(this, filter2);
        }
    }

    public ListenerList<FileBrowserSheetListener> getFileBrowserSheetListeners() {
        return this.fileBrowserSheetListeners;
    }

    private static class FileBrowserSheetListenerList
    extends ListenerList<FileBrowserSheetListener>
    implements FileBrowserSheetListener {
        private FileBrowserSheetListenerList() {
        }

        @Override
        public void rootDirectoryChanged(FileBrowserSheet fileBrowserSheet, File file) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserSheetListener fileBrowserSheetListener = (FileBrowserSheetListener)iterator.next();
                fileBrowserSheetListener.rootDirectoryChanged(fileBrowserSheet, file);
            }
        }

        @Override
        public void selectedFilesChanged(FileBrowserSheet fileBrowserSheet, Sequence<File> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserSheetListener fileBrowserSheetListener = (FileBrowserSheetListener)iterator.next();
                fileBrowserSheetListener.selectedFilesChanged(fileBrowserSheet, sequence);
            }
        }

        @Override
        public void disabledFileFilterChanged(FileBrowserSheet fileBrowserSheet, Filter<File> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FileBrowserSheetListener fileBrowserSheetListener = (FileBrowserSheetListener)iterator.next();
                fileBrowserSheetListener.disabledFileFilterChanged(fileBrowserSheet, filter);
            }
        }
    }

    public static enum Mode {
        OPEN,
        OPEN_MULTIPLE,
        SAVE_AS,
        SAVE_TO;

    }
}

