/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FormAttributeListener;
import org.apache.pivot.wtk.FormListener;
import org.apache.pivot.wtk.MessageType;

public class Form
extends Container {
    private ArrayList<Section> sections = new ArrayList();
    private SectionSequence sectionSequence = new SectionSequence();
    private FormListenerList formListeners = new FormListenerList();
    private FormAttributeListenerList formAttributeListeners = new FormAttributeListenerList();

    public Form() {
        this.installThemeSkin(Form.class);
    }

    public SectionSequence getSections() {
        return this.sectionSequence;
    }

    public int getFlaggedFieldCount(MessageType messageType) {
        int n = 0;
        for (Section section : this.sections) {
            for (Component component : section) {
                Flag flag = Form.getFlag(component);
                if (flag == null || messageType != null && flag.getMessageType() != messageType) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            for (Section section : this.sections) {
                if (section.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(n, n2);
    }

    public ListenerList<FormListener> getFormListeners() {
        return this.formListeners;
    }

    public ListenerList<FormAttributeListener> getFormAttributeListeners() {
        return this.formAttributeListeners;
    }

    public static Section getSection(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.section;
    }

    public static String getLabel(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.label;
    }

    public static void setLabel(Component component, String string) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        String string2 = attributes.label;
        if (string2 != string) {
            attributes.label = string;
            Form form = (Form)component.getParent();
            if (form != null) {
                form.formAttributeListeners.labelChanged(form, component, string2);
            }
        }
    }

    public static Flag getFlag(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.flag;
    }

    public static void setFlag(Component component, Flag flag) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        Flag flag2 = attributes.flag;
        if (flag2 != flag) {
            attributes.flag = flag;
            Form form = (Form)component.getParent();
            if (form != null) {
                form.formAttributeListeners.flagChanged(form, component, flag2);
            }
        }
    }

    public static final void setFlag(Component component, String string) {
        if (string == null) {
            throw new IllegalArgumentException("flag is null.");
        }
        Form.setFlag(component, Flag.decode(string));
    }

    private static class FormAttributeListenerList
    extends ListenerList<FormAttributeListener>
    implements FormAttributeListener {
        private FormAttributeListenerList() {
        }

        @Override
        public void labelChanged(Form form, Component component, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormAttributeListener formAttributeListener = (FormAttributeListener)iterator.next();
                formAttributeListener.labelChanged(form, component, string);
            }
        }

        @Override
        public void flagChanged(Form form, Component component, Flag flag) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormAttributeListener formAttributeListener = (FormAttributeListener)iterator.next();
                formAttributeListener.flagChanged(form, component, flag);
            }
        }
    }

    private static class FormListenerList
    extends ListenerList<FormListener>
    implements FormListener {
        private FormListenerList() {
        }

        @Override
        public void sectionInserted(Form form, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormListener formListener = (FormListener)iterator.next();
                formListener.sectionInserted(form, n);
            }
        }

        @Override
        public void sectionsRemoved(Form form, int n, Sequence<Section> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormListener formListener = (FormListener)iterator.next();
                formListener.sectionsRemoved(form, n, sequence);
            }
        }

        @Override
        public void sectionHeadingChanged(Section section) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormListener formListener = (FormListener)iterator.next();
                formListener.sectionHeadingChanged(section);
            }
        }

        @Override
        public void fieldInserted(Section section, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormListener formListener = (FormListener)iterator.next();
                formListener.fieldInserted(section, n);
            }
        }

        @Override
        public void fieldsRemoved(Section section, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FormListener formListener = (FormListener)iterator.next();
                formListener.fieldsRemoved(section, n, sequence);
            }
        }
    }

    private static class Attributes {
        public final Section section;
        public String label = null;
        public Flag flag = null;

        public Attributes(Section section) {
            this.section = section;
        }
    }

    public static class Flag {
        private MessageType messageType = null;
        private String message = null;
        public static final String MESSAGE_TYPE_KEY = "messageType";
        public static final String MESSAGE_KEY = "message";

        public Flag(MessageType messageType) {
            this(messageType, null);
        }

        public Flag(MessageType messageType, String string) {
            if (messageType == null) {
                throw new IllegalArgumentException("messageType is null.");
            }
            this.messageType = messageType;
            this.message = string;
        }

        public MessageType getMessageType() {
            return this.messageType;
        }

        public String getMessage() {
            return this.message;
        }

        public static Flag decode(String string) {
            Map map;
            try {
                map = JSONSerializer.parseMap((String)string);
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
            String string2 = (String)map.get((Object)MESSAGE_TYPE_KEY);
            if (string2 == null) {
                throw new IllegalArgumentException("messageType is required.");
            }
            Flag flag = new Flag(MessageType.valueOf(string2.toUpperCase()), (String)map.get((Object)MESSAGE_KEY));
            return flag;
        }
    }

    public final class SectionSequence
    implements Sequence<Section>,
    Iterable<Section> {
        private SectionSequence() {
        }

        public int add(Section section) {
            int n = this.getLength();
            this.insert(section, n);
            return n;
        }

        public void insert(Section section, int n) {
            if (section.getForm() != null) {
                throw new IllegalArgumentException("section already has a form.");
            }
            Form.this.sections.insert((Object)section, n);
            section.setForm(Form.this);
            int n2 = section.getLength();
            for (int i = 0; i < n2; ++i) {
                Form.this.add(section.get(i));
            }
            Form.this.formListeners.sectionInserted(Form.this, n);
        }

        public Section update(int n, Section section) {
            throw new UnsupportedOperationException();
        }

        public int remove(Section section) {
            int n = Form.this.sections.indexOf((Object)section);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Section> remove(int n, int n2) {
            Sequence sequence = Form.this.sections.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Section section = (Section)sequence.get(i);
                section.setForm(null);
                for (Component component : section) {
                    Form.this.remove(component);
                }
            }
            Form.this.formListeners.sectionsRemoved(Form.this, n, (Sequence<Section>)sequence);
            return sequence;
        }

        public Section get(int n) {
            return (Section)Form.this.sections.get(n);
        }

        public int indexOf(Section section) {
            return Form.this.sections.indexOf((Object)section);
        }

        public int getLength() {
            return Form.this.sections.getLength();
        }

        @Override
        public Iterator<Section> iterator() {
            return new ImmutableIterator((Iterator)Form.this.sections.iterator());
        }
    }

    public static class Section
    implements Sequence<Component>,
    Iterable<Component> {
        private Form form = null;
        private String heading = null;
        private ArrayList<Component> fields = new ArrayList();

        public Form getForm() {
            return this.form;
        }

        private void setForm(Form form) {
            this.form = form;
        }

        public String getHeading() {
            return this.heading;
        }

        public void setHeading(String string) {
            String string2 = this.heading;
            if (string2 != string) {
                this.heading = string;
                if (this.form != null) {
                    this.form.formListeners.sectionHeadingChanged(this);
                }
            }
        }

        public int add(Component component) {
            int n = this.getLength();
            this.insert(component, n);
            return n;
        }

        public void insert(Component component, int n) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (component.getParent() != null) {
                throw new IllegalArgumentException("Field already has a parent.");
            }
            this.fields.insert((Object)component, n);
            component.setAttributes(new Attributes(this));
            if (this.form != null) {
                this.form.add(component);
                this.form.formListeners.fieldInserted(this, n);
            }
        }

        public Component update(int n, Component component) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component component) {
            int n = this.fields.indexOf((Object)component);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Component> remove(int n, int n2) {
            Sequence sequence = this.fields.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Component component = (Component)sequence.get(i);
                component.setAttributes(null);
                if (this.form == null) continue;
                this.form.remove(component);
            }
            if (this.form != null) {
                this.form.formListeners.fieldsRemoved(this, n, (Sequence<Component>)sequence);
            }
            return sequence;
        }

        public Component get(int n) {
            return (Component)this.fields.get(n);
        }

        public int indexOf(Component component) {
            return this.fields.indexOf((Object)component);
        }

        public int getLength() {
            return this.fields.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.fields.iterator());
        }
    }
}

