/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Orientation;

public final class GraphicsUtilities {
    public static final String PAINT_TYPE_KEY = "paintType";
    public static final String COLOR_KEY = "color";
    public static final String START_X_KEY = "startX";
    public static final String START_Y_KEY = "startY";
    public static final String END_X_KEY = "endX";
    public static final String END_Y_KEY = "endY";
    public static final String START_COLOR_KEY = "startColor";
    public static final String END_COLOR_KEY = "endColor";
    public static final String CENTER_X_KEY = "centerX";
    public static final String CENTER_Y_KEY = "centerY";
    public static final String RADIUS_KEY = "radius";
    public static final String STOPS_KEY = "stops";
    public static final String OFFSET_KEY = "offset";

    private GraphicsUtilities() {
    }

    public static final void drawLine(Graphics2D graphics2D, int n, int n2, int n3, Orientation orientation) {
        GraphicsUtilities.drawLine(graphics2D, n, n2, n3, orientation, 1);
    }

    public static final void drawLine(Graphics2D graphics2D, int n, int n2, int n3, Orientation orientation, int n4) {
        if (n3 > 0 && n4 > 0) {
            switch (orientation) {
                case HORIZONTAL: {
                    graphics2D.fillRect(n, n2, n3, n4);
                    break;
                }
                case VERTICAL: {
                    graphics2D.fillRect(n, n2, n4, n3);
                }
            }
        }
    }

    public static final void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        GraphicsUtilities.drawRect(graphics2D, n, n2, n3, n4, 1);
    }

    public static final void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D2 = graphics2D;
        if ((graphics2D.getTransform().getType() & 6) != 0) {
            graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (n3 > 0 && n4 > 0 && n5 > 0) {
            GraphicsUtilities.drawLine(graphics2D2, n, n2, n3, Orientation.HORIZONTAL, n5);
            GraphicsUtilities.drawLine(graphics2D2, n + n3 - n5, n2, n4, Orientation.VERTICAL, n5);
            GraphicsUtilities.drawLine(graphics2D2, n, n2 + n4 - n5, n3, Orientation.HORIZONTAL, n5);
            GraphicsUtilities.drawLine(graphics2D2, n, n2, n4, Orientation.VERTICAL, n5);
        }
        if (graphics2D2 != graphics2D) {
            graphics2D2.dispose();
        }
    }

    public static Color decodeColor(String string) throws NumberFormatException {
        float f;
        int n;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if ((string = string.toLowerCase()).startsWith("0x")) {
            if ((string = string.substring(2)).length() != 8) {
                throw new IllegalArgumentException();
            }
            n = Integer.parseInt(string.substring(0, 6), 16);
            f = (float)Integer.parseInt(string.substring(6, 8), 16) / 255.0f;
        } else if (string.startsWith("#")) {
            if ((string = string.substring(1)).length() != 6) {
                throw new IllegalArgumentException();
            }
            n = Integer.parseInt(string, 16);
            f = 1.0f;
        } else {
            throw new IllegalArgumentException();
        }
        float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n >> 0 & 0xFF) / 255.0f;
        Color color = new Color(f2, f3, f4, f);
        return color;
    }

    public static Paint decodePaint(String string) {
        Paint paint;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith("#") || string.startsWith("0x") || string.startsWith("0X")) {
            paint = GraphicsUtilities.decodeColor(string);
        } else {
            try {
                paint = GraphicsUtilities.decodePaint(JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
        }
        return paint;
    }

    public static Paint decodePaint(Dictionary<String, ?> dictionary) {
        Paint paint;
        String string = JSONSerializer.getString(dictionary, (String)PAINT_TYPE_KEY);
        if (string == null) {
            throw new IllegalArgumentException("paintType is required.");
        }
        switch (PaintType.valueOf(string.toUpperCase())) {
            case SOLID_COLOR: {
                String string2 = JSONSerializer.getString(dictionary, (String)COLOR_KEY);
                paint = GraphicsUtilities.decodeColor(string2);
                break;
            }
            case GRADIENT: {
                float f = JSONSerializer.getFloat(dictionary, (String)START_X_KEY).floatValue();
                float f2 = JSONSerializer.getFloat(dictionary, (String)START_Y_KEY).floatValue();
                float f3 = JSONSerializer.getFloat(dictionary, (String)END_X_KEY).floatValue();
                float f4 = JSONSerializer.getFloat(dictionary, (String)END_Y_KEY).floatValue();
                Color color = GraphicsUtilities.decodeColor(JSONSerializer.getString(dictionary, (String)START_COLOR_KEY));
                Color color2 = GraphicsUtilities.decodeColor(JSONSerializer.getString(dictionary, (String)END_COLOR_KEY));
                paint = new GradientPaint(f, f2, color, f3, f4, color2);
                break;
            }
            case LINEAR_GRADIENT: {
                float f = JSONSerializer.getFloat(dictionary, (String)START_X_KEY).floatValue();
                float f5 = JSONSerializer.getFloat(dictionary, (String)START_Y_KEY).floatValue();
                float f6 = JSONSerializer.getFloat(dictionary, (String)END_X_KEY).floatValue();
                float f7 = JSONSerializer.getFloat(dictionary, (String)END_Y_KEY).floatValue();
                List list = JSONSerializer.getList(dictionary, (String)STOPS_KEY);
                int n = list.getLength();
                float[] fArray = new float[n];
                Color[] colorArray = new Color[n];
                for (int i = 0; i < n; ++i) {
                    Color color;
                    float f8;
                    Dictionary dictionary2 = (Dictionary)list.get(i);
                    fArray[i] = f8 = JSONSerializer.getFloat((Object)dictionary2, (String)OFFSET_KEY).floatValue();
                    colorArray[i] = color = GraphicsUtilities.decodeColor(JSONSerializer.getString((Object)dictionary2, (String)COLOR_KEY));
                }
                paint = new LinearGradientPaint(f, f5, f6, f7, fArray, colorArray);
                break;
            }
            case RADIAL_GRADIENT: {
                float f = JSONSerializer.getFloat(dictionary, (String)CENTER_X_KEY).floatValue();
                float f9 = JSONSerializer.getFloat(dictionary, (String)CENTER_Y_KEY).floatValue();
                float f10 = JSONSerializer.getFloat(dictionary, (String)RADIUS_KEY).floatValue();
                List list = JSONSerializer.getList(dictionary, (String)STOPS_KEY);
                int n = list.getLength();
                float[] fArray = new float[n];
                Color[] colorArray = new Color[n];
                for (int i = 0; i < n; ++i) {
                    Color color;
                    float f11;
                    Dictionary dictionary3 = (Dictionary)list.get(i);
                    fArray[i] = f11 = JSONSerializer.getFloat((Object)dictionary3, (String)OFFSET_KEY).floatValue();
                    colorArray[i] = color = GraphicsUtilities.decodeColor(JSONSerializer.getString((Object)dictionary3, (String)COLOR_KEY));
                }
                paint = new RadialGradientPaint(f, f9, f10, fArray, colorArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return paint;
    }

    public static enum PaintType {
        SOLID_COLOR,
        GRADIENT,
        LINEAR_GRADIENT,
        RADIAL_GRADIENT;

    }
}

