/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.LabelListener;

public class Label
extends Component {
    private String text = null;
    private String textKey = null;
    private LabelListenerList labelListeners = new LabelListenerList();

    public Label() {
        this(null);
    }

    public Label(String string) {
        this.text = string;
        this.installThemeSkin(Label.class);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        if (string2 != string) {
            this.text = string;
            this.labelListeners.textChanged(this, string2);
        }
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String string) {
        String string2 = this.textKey;
        if (string2 != string) {
            this.textKey = string;
            this.labelListeners.textKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.textKey != null && JSONSerializer.containsKey(dictionary, (String)this.textKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.textKey);
            if (object != null) {
                object = object.toString();
            }
            this.setText((String)object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.textKey != null) {
            JSONSerializer.put(dictionary, (String)this.textKey, (Object)this.getText());
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText(null);
        }
    }

    public ListenerList<LabelListener> getLabelListeners() {
        return this.labelListeners;
    }

    private static class LabelListenerList
    extends ListenerList<LabelListener>
    implements LabelListener {
        private LabelListenerList() {
        }

        @Override
        public void textChanged(Label label, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                LabelListener labelListener = (LabelListener)iterator.next();
                labelListener.textChanged(label, string);
            }
        }

        @Override
        public void textKeyChanged(Label label, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                LabelListener labelListener = (LabelListener)iterator.next();
                labelListener.textKeyChanged(label, string);
            }
        }
    }
}

