/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ListButtonListener;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.content.ListButtonDataRenderer;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

public class ListButton
extends Button {
    private List<?> listData;
    private ListView.ItemRenderer itemRenderer = null;
    private int selectedIndex = -1;
    private Filter<?> disabledItemFilter = null;
    private String selectedItemKey = null;
    private ListButtonListenerList listButtonListeners = new ListButtonListenerList();
    private ListButtonSelectionListenerList listButtonSelectionListeners = new ListButtonSelectionListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ListButtonDataRenderer();
    private static final ListView.ItemRenderer DEFAULT_ITEM_RENDERER = new ListViewItemRenderer();

    public ListButton() {
        this((List<?>)new ArrayList());
    }

    public ListButton(Object object) {
        this(object, (List<?>)new ArrayList());
    }

    public ListButton(List<?> list) {
        this(null, list);
    }

    public ListButton(Object object, List<?> list) {
        super(object);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.setItemRenderer(DEFAULT_ITEM_RENDERER);
        this.setListData(list);
        this.installThemeSkin(ListButton.class);
    }

    @Override
    public void setToggleButton(boolean bl) {
        throw new UnsupportedOperationException("List buttons cannot be toggle buttons.");
    }

    public List<?> getListData() {
        return this.listData;
    }

    public void setListData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        List<?> list2 = this.listData;
        if (list2 != list) {
            if (list2 != null) {
                this.selectedIndex = -1;
            }
            this.listData = list;
            this.listButtonListeners.listDataChanged(this, list2);
        }
    }

    public final void setListData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        try {
            this.setListData(JSONSerializer.parseList((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    public ListView.ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ListView.ItemRenderer itemRenderer) {
        ListView.ItemRenderer itemRenderer2 = this.itemRenderer;
        if (itemRenderer2 != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.listButtonListeners.itemRendererChanged(this, itemRenderer2);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedIndex;
        if (n2 != n) {
            this.selectedIndex = n;
            this.listButtonSelectionListeners.selectedIndexChanged(this, n2);
        }
    }

    public Object getSelectedItem() {
        int n = this.getSelectedIndex();
        Object object = null;
        if (n >= 0) {
            object = this.listData.get(n);
        }
        return object;
    }

    public void setSelectedItem(Object object) {
        this.setSelectedIndex(object == null ? -1 : this.listData.indexOf(object));
    }

    public boolean isItemDisabled(int n) {
        boolean bl = false;
        if (this.disabledItemFilter != null) {
            Object object = this.listData.get(n);
            bl = this.disabledItemFilter.include(object);
        }
        return bl;
    }

    public Filter<?> getDisabledItemFilter() {
        return this.disabledItemFilter;
    }

    public void setDisabledItemFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledItemFilter;
        if (filter2 != filter) {
            this.disabledItemFilter = filter;
            this.listButtonListeners.disabledItemFilterChanged(this, filter2);
        }
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String string) {
        String string2 = this.selectedItemKey;
        if (string2 != string) {
            this.selectedItemKey = string;
            this.listButtonListeners.selectedItemKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.selectedItemKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedItemKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.selectedItemKey);
            this.setSelectedItem(object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedItemKey != null) {
            Object object = this.getSelectedItem();
            JSONSerializer.put(dictionary, (String)this.selectedItemKey, (Object)object);
        }
    }

    @Override
    public void clear() {
        if (this.selectedItemKey != null) {
            this.setSelectedItem(null);
        }
    }

    public ListenerList<ListButtonListener> getListButtonListeners() {
        return this.listButtonListeners;
    }

    public ListenerList<ListButtonSelectionListener> getListButtonSelectionListeners() {
        return this.listButtonSelectionListeners;
    }

    private static class ListButtonSelectionListenerList
    extends ListenerList<ListButtonSelectionListener>
    implements ListButtonSelectionListener {
        private ListButtonSelectionListenerList() {
        }

        @Override
        public void selectedIndexChanged(ListButton listButton, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListButtonSelectionListener listButtonSelectionListener = (ListButtonSelectionListener)iterator.next();
                listButtonSelectionListener.selectedIndexChanged(listButton, n);
            }
        }
    }

    private static class ListButtonListenerList
    extends ListenerList<ListButtonListener>
    implements ListButtonListener {
        private ListButtonListenerList() {
        }

        @Override
        public void listDataChanged(ListButton listButton, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListButtonListener listButtonListener = (ListButtonListener)iterator.next();
                listButtonListener.listDataChanged(listButton, list);
            }
        }

        @Override
        public void itemRendererChanged(ListButton listButton, ListView.ItemRenderer itemRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListButtonListener listButtonListener = (ListButtonListener)iterator.next();
                listButtonListener.itemRendererChanged(listButton, itemRenderer);
            }
        }

        @Override
        public void disabledItemFilterChanged(ListButton listButton, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListButtonListener listButtonListener = (ListButtonListener)iterator.next();
                listButtonListener.disabledItemFilterChanged(listButton, filter);
            }
        }

        @Override
        public void selectedItemKeyChanged(ListButton listButton, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListButtonListener listButtonListener = (ListButtonListener)iterator.next();
                listButtonListener.selectedItemKeyChanged(listButton, string);
            }
        }
    }
}

