/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Span;

class ListSelection {
    private ArrayList<Span> selectedRanges = new ArrayList();
    public static final Comparator<Span> START_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span span, Span span2) {
            return span.end - span2.start;
        }
    };
    public static final Comparator<Span> END_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span span, Span span2) {
            return span.start - span2.end;
        }
    };
    public static final Comparator<Span> INTERSECTION_COMPARATOR = new Comparator<Span>(){

        @Override
        public int compare(Span span, Span span2) {
            return span.start > span2.end ? 1 : (span2.start > span.end ? -1 : 0);
        }
    };

    ListSelection() {
    }

    public Sequence<Span> addRange(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        Span span = ListSelection.normalize(n, n2);
        assert (span.start >= 0);
        int n3 = this.selectedRanges.getLength();
        if (n3 == 0) {
            this.selectedRanges.add((Object)span);
            arrayList.add((Object)span);
        } else {
            int n4 = ArrayList.binarySearch(this.selectedRanges, (Object)span, START_COMPARATOR);
            if (n4 < 0) {
                n4 = -(n4 + 1);
            }
            if (n4 > 0) {
                Span span2 = (Span)this.selectedRanges.get(n4 - 1);
                if (span.start == span2.end + 1) {
                    --n4;
                }
            }
            if (n4 == n3) {
                this.selectedRanges.add((Object)span);
                arrayList.add((Object)span);
            } else {
                Span span3;
                int n5 = ArrayList.binarySearch(this.selectedRanges, (Object)span, END_COMPARATOR);
                n5 = n5 < 0 ? -(n5 + 1) : ++n5;
                if (n5 < n3) {
                    span3 = (Span)this.selectedRanges.get(n5);
                    if (span.end == span3.start - 1) {
                        ++n5;
                    }
                }
                if (n4 == n5) {
                    this.selectedRanges.insert((Object)span, n4);
                    arrayList.add((Object)span);
                } else {
                    span3 = (Span)this.selectedRanges.get(n4);
                    Span span4 = (Span)this.selectedRanges.get(n5 - 1);
                    span = new Span(Math.min(span.start, span3.start), Math.max(span.end, span4.end));
                    if (span.start < span3.start) {
                        arrayList.add((Object)new Span(span.start, span3.start - 1));
                    }
                    for (int i = n4; i < n5 - 1; ++i) {
                        Span span5 = (Span)this.selectedRanges.get(i);
                        Span span6 = (Span)this.selectedRanges.get(i + 1);
                        arrayList.add((Object)new Span(span5.end + 1, span6.start - 1));
                    }
                    if (span.end > span4.end) {
                        arrayList.add((Object)new Span(span4.end + 1, span.end));
                    }
                    this.selectedRanges.update(n4, (Object)span);
                    if (n4 < n5) {
                        this.selectedRanges.remove(n4 + 1, n5 - n4 - 1);
                    }
                }
            }
        }
        return arrayList;
    }

    public Sequence<Span> removeRange(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        Span span = ListSelection.normalize(n, n2);
        assert (span.start >= 0);
        int n3 = this.selectedRanges.getLength();
        if (n3 > 0) {
            int n4 = ArrayList.binarySearch(this.selectedRanges, (Object)span, START_COMPARATOR);
            if (n4 < 0) {
                n4 = -(n4 + 1);
            }
            if (n4 < n3) {
                Span span2 = (Span)this.selectedRanges.get(n4);
                if (span2.start < span.start && span2.end > span.end) {
                    this.selectedRanges.update(n4, (Object)new Span(span2.start, span.start - 1));
                    this.selectedRanges.insert((Object)new Span(span.end + 1, span2.end), n4 + 1);
                    arrayList.add((Object)span);
                } else {
                    int n5;
                    Span span3 = null;
                    if (span.start > span2.start) {
                        this.selectedRanges.update(n4, (Object)new Span(span2.start, span.start - 1));
                        span3 = new Span(span.start, span2.end);
                        ++n4;
                    }
                    n5 = (n5 = ArrayList.binarySearch(this.selectedRanges, (Object)span, END_COMPARATOR)) < 0 ? -(n5 + 1) : ++n5;
                    if (n5 > 0) {
                        Span span4 = (Span)this.selectedRanges.get(n5 - 1);
                        Span span5 = null;
                        if (span.end < span4.end) {
                            this.selectedRanges.update(n5 - 1, (Object)new Span(span.end + 1, span4.end));
                            span5 = new Span(span4.start, span.end);
                            --n5;
                        }
                        Sequence sequence = this.selectedRanges.remove(n4, n5 - n4);
                        if (span3 != null) {
                            arrayList.add((Object)span3);
                        }
                        int n6 = sequence.getLength();
                        for (int i = 0; i < n6; ++i) {
                            arrayList.add(sequence.get(i));
                        }
                        if (span5 != null) {
                            arrayList.add(span5);
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public void clear() {
        this.selectedRanges.clear();
    }

    public Span get(int n) {
        return (Span)this.selectedRanges.get(n);
    }

    public int getLength() {
        return this.selectedRanges.getLength();
    }

    public int indexOf(Span span) {
        assert (span != null);
        int n = -1;
        int n2 = ArrayList.binarySearch(this.selectedRanges, (Object)span, INTERSECTION_COMPARATOR);
        if (n2 >= 0) {
            n = span.equals(this.selectedRanges.get(n2)) ? n2 : -1;
        }
        return n;
    }

    public boolean containsIndex(int n) {
        Span span = new Span(n);
        int n2 = ArrayList.binarySearch(this.selectedRanges, (Object)span, INTERSECTION_COMPARATOR);
        return n2 >= 0;
    }

    public void insertIndex(int n) {
        Span span = new Span(n);
        int n2 = ArrayList.binarySearch(this.selectedRanges, (Object)span, INTERSECTION_COMPARATOR);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        } else {
            Span span2 = (Span)this.selectedRanges.get(n2);
            if (span2.start < n) {
                this.selectedRanges.update(n2, (Object)new Span(span2.start, span2.end + 1));
                ++n2;
            }
        }
        int n3 = this.selectedRanges.getLength();
        while (n2 < n3) {
            Span span3 = (Span)this.selectedRanges.get(n2);
            this.selectedRanges.update(n2, (Object)new Span(span3.start + 1, span3.end + 1));
            ++n2;
        }
    }

    public void removeIndexes(int n, int n2) {
        this.removeRange(n, n + n2 - 1);
        Span span = new Span(n);
        int n3 = ArrayList.binarySearch(this.selectedRanges, (Object)span, INTERSECTION_COMPARATOR);
        assert (n3 < 0) : "i should be negative, since index should no longer be selected";
        int n4 = this.selectedRanges.getLength();
        for (n3 = -(n3 + 1); n3 < n4; ++n3) {
            Span span2 = (Span)this.selectedRanges.get(n3);
            this.selectedRanges.update(n3, (Object)new Span(span2.start - n2, span2.end - n2));
        }
    }

    public static Span normalize(int n, int n2) {
        return new Span(Math.min(n, n2), Math.max(n, n2));
    }
}

