/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.media.Picture;

class LocalManifestAdapter
implements Transferable {
    private LocalManifest localManifest;
    private ArrayList<DataFlavor> transferDataFlavors = new ArrayList();
    private static final String URI_LIST_MIME_TYPE = "text/uri-list; class=java.lang.String";

    public LocalManifestAdapter(LocalManifest localManifest) {
        this.localManifest = localManifest;
        if (localManifest.containsText()) {
            this.transferDataFlavors.add((Object)DataFlavor.stringFlavor);
        }
        if (localManifest.containsImage()) {
            this.transferDataFlavors.add((Object)DataFlavor.imageFlavor);
        }
        if (localManifest.containsFileList()) {
            this.transferDataFlavors.add((Object)DataFlavor.javaFileListFlavor);
            try {
                this.transferDataFlavors.add((Object)new DataFlavor(URI_LIST_MIME_TYPE));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Object object = null;
        int n = this.transferDataFlavors.indexOf((Object)dataFlavor);
        if (n == -1) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            object = this.localManifest.getText();
        } else if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            Picture picture = (Picture)this.localManifest.getImage();
            object = picture.getBufferedImage();
        } else if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            FileList fileList = this.localManifest.getFileList();
            object = fileList.getList();
        } else if (dataFlavor.getMimeType().equals(URI_LIST_MIME_TYPE)) {
            FileList fileList = this.localManifest.getFileList();
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : fileList) {
                stringBuilder.append(file.toURI().toString()).append("\r\n");
            }
            object = stringBuilder.toString();
        }
        return object;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.transferDataFlavors.toArray(DataFlavor[].class);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferDataFlavors.indexOf((Object)dataFlavor) != -1;
    }
}

