/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.MenuItemSelectionListener;
import org.apache.pivot.wtk.MenuListener;
import org.apache.pivot.wtk.content.MenuItemDataRenderer;

public class Menu
extends Container {
    private Item item = null;
    private ArrayList<Section> sections = new ArrayList();
    private SectionSequence sectionSequence = new SectionSequence();
    private HashMap<String, Section> sectionMap = new HashMap();
    private HashMap<String, Item> itemMap = new HashMap();
    private Item activeItem = null;
    private MenuListenerList menuListeners = new MenuListenerList();
    private MenuItemSelectionListenerList menuItemSelectionListeners = new MenuItemSelectionListenerList();

    public Menu() {
        this.installThemeSkin(Menu.class);
    }

    public Item getItem() {
        return this.item;
    }

    public SectionSequence getSections() {
        return this.sectionSequence;
    }

    public Section getSection(String string) {
        return (Section)this.sectionMap.get((Object)string);
    }

    public Item getItem(String string) {
        return (Item)this.itemMap.get((Object)string);
    }

    public Item getActiveItem() {
        return this.activeItem;
    }

    private void setActiveItem(Item item) {
        Item item2 = this.activeItem;
        if (item2 != item) {
            this.activeItem = item;
            this.menuListeners.activeItemChanged(this, item2);
        }
    }

    public void activateNextItem() {
        int n;
        int n2;
        int n3 = this.sections.getLength();
        if (this.activeItem == null) {
            n2 = 0;
            n = 0;
        } else {
            n2 = this.sections.indexOf((Object)this.activeItem.section);
            n = this.activeItem.section.indexOf(this.activeItem) + 1;
        }
        while (n2 < n3) {
            Section section = (Section)this.sections.get(n2);
            int n4 = section.getLength();
            while (n < n4) {
                Item item = section.get(n);
                if (item.isEnabled()) {
                    item.setActive(true);
                    break;
                }
                ++n;
            }
            if (n < n4) break;
            ++n2;
            n = 0;
        }
    }

    public void activatePreviousItem() {
        int n;
        int n2;
        int n3 = this.sections.getLength();
        if (this.activeItem == null) {
            n2 = n3 - 1;
            n = -1;
        } else {
            n2 = this.sections.indexOf((Object)this.activeItem.section);
            n = this.activeItem.section.indexOf(this.activeItem) - 1;
            if (n == -1) {
                --n2;
            }
        }
        while (n2 >= 0) {
            Section section = (Section)this.sections.get(n2);
            if (n == -1) {
                int n4 = section.getLength();
                n = n4 - 1;
            }
            while (n >= 0) {
                Item item = section.get(n);
                if (item.isEnabled()) {
                    item.setActive(true);
                    break;
                }
                --n;
            }
            if (n >= 0) break;
            --n2;
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            for (Section section : this.sections) {
                if (section.indexOf((Item)component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(n, n2);
    }

    public ListenerList<MenuListener> getMenuListeners() {
        return this.menuListeners;
    }

    public ListenerList<MenuItemSelectionListener> getMenuItemSelectionListeners() {
        return this.menuItemSelectionListeners;
    }

    private static class MenuItemSelectionListenerList
    extends ListenerList<MenuItemSelectionListener>
    implements MenuItemSelectionListener {
        private MenuItemSelectionListenerList() {
        }

        @Override
        public void itemSelected(Item item) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuItemSelectionListener menuItemSelectionListener = (MenuItemSelectionListener)iterator.next();
                menuItemSelectionListener.itemSelected(item);
            }
        }
    }

    private static class MenuListenerList
    extends ListenerList<MenuListener>
    implements MenuListener {
        private MenuListenerList() {
        }

        @Override
        public void sectionInserted(Menu menu, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuListener menuListener = (MenuListener)iterator.next();
                menuListener.sectionInserted(menu, n);
            }
        }

        @Override
        public void sectionsRemoved(Menu menu, int n, Sequence<Section> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuListener menuListener = (MenuListener)iterator.next();
                menuListener.sectionsRemoved(menu, n, sequence);
            }
        }

        @Override
        public void activeItemChanged(Menu menu, Item item) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuListener menuListener = (MenuListener)iterator.next();
                menuListener.activeItemChanged(menu, item);
            }
        }
    }

    public final class SectionSequence
    implements Sequence<Section>,
    Iterable<Section> {
        private SectionSequence() {
        }

        public int add(Section section) {
            int n = this.getLength();
            this.insert(section, n);
            return n;
        }

        public void insert(Section section, int n) {
            if (section.menu != null) {
                throw new IllegalArgumentException("section already has a menu.");
            }
            Menu.this.sections.insert((Object)section, n);
            if (section.name != null) {
                if (Menu.this.sectionMap.containsKey((Object)section.name)) {
                    throw new IllegalArgumentException("A menu section named \"" + section.name + "\" already exists.");
                }
                Menu.this.sectionMap.put((Object)section.name, (Object)section);
            }
            for (Item item : section) {
                if (item.name == null) continue;
                if (Menu.this.itemMap.containsKey((Object)item.name)) {
                    throw new IllegalArgumentException("A menu item named \"" + item.name + "\" already exists.");
                }
                Menu.this.itemMap.put((Object)item.name, (Object)item);
            }
            section.menu = Menu.this;
            int n2 = section.getLength();
            for (int i = 0; i < n2; ++i) {
                Menu.this.add(section.get(i));
            }
            Menu.this.menuListeners.sectionInserted(Menu.this, n);
        }

        public Section update(int n, Section section) {
            throw new UnsupportedOperationException();
        }

        public int remove(Section section) {
            int n = Menu.this.sections.indexOf((Object)section);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Section> remove(int n, int n2) {
            Sequence sequence = Menu.this.sections.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Section section = (Section)sequence.get(i);
                if (section.name != null) {
                    Menu.this.sectionMap.remove((Object)section.name);
                }
                for (Item item : section) {
                    if (item.name == null) continue;
                    Menu.this.itemMap.remove((Object)item.name);
                }
                section.menu = null;
                for (Item item : section) {
                    Menu.this.remove(item);
                }
            }
            Menu.this.menuListeners.sectionsRemoved(Menu.this, n, (Sequence<Section>)sequence);
            return sequence;
        }

        public void clear() {
            this.remove(0, Menu.this.sections.getLength());
        }

        public Section get(int n) {
            return (Section)Menu.this.sections.get(n);
        }

        public int indexOf(Section section) {
            return Menu.this.sections.indexOf((Object)section);
        }

        public int getLength() {
            return Menu.this.sections.getLength();
        }

        @Override
        public Iterator<Section> iterator() {
            return new ImmutableIterator((Iterator)Menu.this.sections.iterator());
        }
    }

    public static interface SectionListener {
        public void itemInserted(Section var1, int var2);

        public void itemsRemoved(Section var1, int var2, Sequence<Item> var3);

        public void nameChanged(Section var1, String var2);
    }

    public static class Section
    implements Sequence<Item>,
    Iterable<Item> {
        private Menu menu = null;
        private String name = null;
        private ArrayList<Item> items = new ArrayList();
        private SectionListenerList sectionListeners = new SectionListenerList();

        public Menu getMenu() {
            return this.menu;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            String string2 = this.name;
            if (string != string2) {
                if (this.menu != null) {
                    if (this.menu.sectionMap.containsKey((Object)string)) {
                        throw new IllegalArgumentException("A menu section named \"" + string + "\" already exists.");
                    }
                    if (string2 != null) {
                        this.menu.sectionMap.remove((Object)string2);
                    }
                    this.menu.sectionMap.put((Object)string, (Object)this);
                }
                this.name = string;
                this.sectionListeners.nameChanged(this, string2);
            }
        }

        public int add(Item item) {
            int n = this.getLength();
            this.insert(item, n);
            return n;
        }

        public void insert(Item item, int n) {
            if (item.getSection() != null) {
                throw new IllegalArgumentException("item already has a section.");
            }
            this.items.insert((Object)item, n);
            item.section = this;
            if (this.menu != null) {
                this.menu.add(item);
                this.sectionListeners.itemInserted(this, n);
            }
        }

        public Item update(int n, Item item) {
            throw new UnsupportedOperationException();
        }

        public int remove(Item item) {
            int n = this.items.indexOf((Object)item);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Item> remove(int n, int n2) {
            Sequence sequence = this.items.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Item item = (Item)sequence.get(i);
                item.section = null;
                if (this.menu == null) continue;
                this.menu.remove(item);
            }
            this.sectionListeners.itemsRemoved(this, n, (Sequence<Item>)sequence);
            return sequence;
        }

        public Item get(int n) {
            return (Item)this.items.get(n);
        }

        public int indexOf(Item item) {
            return this.items.indexOf((Object)item);
        }

        public int getLength() {
            return this.items.getLength();
        }

        @Override
        public Iterator<Item> iterator() {
            return new ImmutableIterator((Iterator)this.items.iterator());
        }

        public ListenerList<SectionListener> getSectionListeners() {
            return this.sectionListeners;
        }

        private static class SectionListenerList
        extends ListenerList<SectionListener>
        implements SectionListener {
            private SectionListenerList() {
            }

            @Override
            public void itemInserted(Section section, int n) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    SectionListener sectionListener = (SectionListener)iterator.next();
                    sectionListener.itemInserted(section, n);
                }
            }

            @Override
            public void itemsRemoved(Section section, int n, Sequence<Item> sequence) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    SectionListener sectionListener = (SectionListener)iterator.next();
                    sectionListener.itemsRemoved(section, n, sequence);
                }
            }

            @Override
            public void nameChanged(Section section, String string) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    SectionListener sectionListener = (SectionListener)iterator.next();
                    sectionListener.nameChanged(section, string);
                }
            }
        }
    }

    public static interface ItemListener {
        public void nameChanged(Item var1, String var2);

        public void menuChanged(Item var1, Menu var2);

        public void activeChanged(Item var1);
    }

    public static class Item
    extends Button {
        private Section section = null;
        private String name = null;
        private Menu menu = null;
        private boolean active = false;
        private ItemListenerList itemListeners = new ItemListenerList();
        private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new MenuItemDataRenderer();

        public Item() {
            this(null);
        }

        public Item(Object object) {
            super(object);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.installThemeSkin(Item.class);
        }

        @Override
        protected void setParent(Container container) {
            if (container != null && !(container instanceof Menu)) {
                throw new IllegalArgumentException("Parent must be an instance of " + Menu.class.getName());
            }
            this.setActive(false);
            super.setParent(container);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (!bl) {
                this.setActive(false);
            }
        }

        public Section getSection() {
            return this.section;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            String string2 = this.name;
            if (string != string2) {
                if (this.section != null && this.section.menu != null) {
                    if (this.section.menu.itemMap.containsKey((Object)string)) {
                        throw new IllegalArgumentException("A menu item named \"" + string + "\" already exists.");
                    }
                    if (string2 != null) {
                        this.section.menu.itemMap.remove((Object)string2);
                    }
                    this.section.menu.itemMap.put((Object)string, (Object)this);
                }
                this.name = string;
                this.itemListeners.nameChanged(this, string2);
            }
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            if (menu != null && menu.getItem() != null) {
                throw new IllegalArgumentException("menu already belongs to an item.");
            }
            Menu menu2 = this.menu;
            if (menu2 != menu) {
                if (menu2 != null) {
                    menu2.item = null;
                }
                if (menu != null) {
                    menu.item = this;
                }
                this.menu = menu;
                this.itemListeners.menuChanged(this, menu2);
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            if (bl && (this.getParent() == null || !this.isEnabled())) {
                throw new IllegalStateException();
            }
            if (this.active != bl) {
                this.active = bl;
                Menu menu = (Menu)this.getParent();
                Item item = menu.getActiveItem();
                if (bl) {
                    menu.setActiveItem(this);
                    if (item != null) {
                        item.setActive(false);
                    }
                } else if (item == this) {
                    menu.setActiveItem(null);
                }
                this.itemListeners.activeChanged(this);
            }
        }

        @Override
        public void setTriState(boolean bl) {
            throw new UnsupportedOperationException("Menu items can't be tri-state.");
        }

        @Override
        public void press() {
            if (this.isToggleButton()) {
                this.setSelected(this.getButtonGroup() == null ? !this.isSelected() : true);
            }
            super.press();
            if (this.menu == null) {
                Item item = this;
                while (item != null) {
                    Menu menu = (Menu)item.getParent();
                    if (menu == null) {
                        item = null;
                        continue;
                    }
                    menu.menuItemSelectionListeners.itemSelected(this);
                    item = menu.item;
                }
            }
        }

        public ListenerList<ItemListener> getItemListeners() {
            return this.itemListeners;
        }

        private static class ItemListenerList
        extends ListenerList<ItemListener>
        implements ItemListener {
            private ItemListenerList() {
            }

            @Override
            public void nameChanged(Item item, String string) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemListener itemListener = (ItemListener)iterator.next();
                    itemListener.nameChanged(item, string);
                }
            }

            @Override
            public void menuChanged(Item item, Menu menu) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemListener itemListener = (ItemListener)iterator.next();
                    itemListener.menuChanged(item, menu);
                }
            }

            @Override
            public void activeChanged(Item item) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemListener itemListener = (ItemListener)iterator.next();
                    itemListener.activeChanged(item);
                }
            }
        }
    }
}

