/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.MouseInfo;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Point;

public final class Mouse {
    private static int buttons = 0;
    private static Component capturer = null;

    public static int getButtons() {
        return buttons;
    }

    protected static void setButtons(int n) {
        buttons = n;
    }

    public static boolean isPressed(Button button) {
        return button.isSelected(Mouse.getButtons());
    }

    public static int getButtonCount() {
        return MouseInfo.getNumberOfButtons();
    }

    public static void capture(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("capturer is null.");
        }
        if (!component.isMouseOver()) {
            throw new IllegalArgumentException("Mouse pointer is not currently over capturer.");
        }
        if (capturer != null) {
            throw new IllegalStateException("Mouse is already captured.");
        }
        capturer = component;
    }

    public static void release() {
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Display display = capturer.getDisplay();
        Point point = display.getMouseLocation();
        Component component = null;
        if (point != null) {
            component = display.getDescendantAt(point.x, point.y);
        }
        while (component != null && component != capturer) {
            component = component.getParent();
        }
        if (component == null) {
            capturer.mouseOut();
            Mouse.setCursor(display);
            if (point != null) {
                display.mouseMove(point.x, point.y);
            }
        }
        capturer = null;
    }

    public static Component getCapturer() {
        return capturer;
    }

    public static Cursor getCursor() {
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Cursor cursor = null;
        Display display = capturer.getDisplay();
        ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
        int n = displayHost.getCursor().getType();
        switch (n) {
            case 0: {
                cursor = Cursor.DEFAULT;
                break;
            }
            case 12: {
                cursor = Cursor.HAND;
                break;
            }
            case 2: {
                cursor = Cursor.TEXT;
                break;
            }
            case 3: {
                cursor = Cursor.WAIT;
                break;
            }
            case 1: {
                cursor = Cursor.CROSSHAIR;
                break;
            }
            case 13: {
                cursor = Cursor.MOVE;
                break;
            }
            case 8: {
                cursor = Cursor.RESIZE_NORTH;
                break;
            }
            case 9: {
                cursor = Cursor.RESIZE_SOUTH;
                break;
            }
            case 11: {
                cursor = Cursor.RESIZE_EAST;
                break;
            }
            case 10: {
                cursor = Cursor.RESIZE_WEST;
                break;
            }
            case 7: {
                cursor = Cursor.RESIZE_NORTH_EAST;
                break;
            }
            case 4: {
                cursor = Cursor.RESIZE_SOUTH_WEST;
                break;
            }
            case 6: {
                cursor = Cursor.RESIZE_NORTH_WEST;
                break;
            }
            case 5: {
                cursor = Cursor.RESIZE_SOUTH_EAST;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return cursor;
    }

    public static void setCursor(Cursor cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor is null.");
        }
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Display display = capturer.getDisplay();
        ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
        displayHost.setCursor(Mouse.getCursor(cursor));
    }

    public static void setCursor(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (!component.isVisible()) {
            throw new IllegalArgumentException("component is not visible.");
        }
        Cursor cursor = null;
        if (component.isEnabled()) {
            cursor = component.getCursor();
            while (cursor == null && component != null && !(component instanceof Display)) {
                if ((component = component.getParent()) == null) continue;
                cursor = component.getCursor();
            }
        }
        if (component != null) {
            Display display = component.getDisplay();
            ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
            displayHost.setCursor(cursor == null ? java.awt.Cursor.getDefaultCursor() : Mouse.getCursor(cursor));
        }
    }

    private static java.awt.Cursor getCursor(Cursor cursor) {
        int n = -1;
        switch (cursor) {
            case DEFAULT: {
                n = 0;
                break;
            }
            case HAND: {
                n = 12;
                break;
            }
            case TEXT: {
                n = 2;
                break;
            }
            case WAIT: {
                n = 3;
                break;
            }
            case CROSSHAIR: {
                n = 1;
                break;
            }
            case MOVE: {
                n = 13;
                break;
            }
            case RESIZE_NORTH: {
                n = 8;
                break;
            }
            case RESIZE_SOUTH: {
                n = 9;
                break;
            }
            case RESIZE_EAST: {
                n = 11;
                break;
            }
            case RESIZE_WEST: {
                n = 10;
                break;
            }
            case RESIZE_NORTH_EAST: {
                n = 7;
                break;
            }
            case RESIZE_SOUTH_WEST: {
                n = 4;
                break;
            }
            case RESIZE_NORTH_WEST: {
                n = 6;
                break;
            }
            case RESIZE_SOUTH_EAST: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new java.awt.Cursor(n);
    }

    public static enum ScrollType {
        UNIT,
        BLOCK;

    }

    public static enum Button {
        LEFT,
        RIGHT,
        MIDDLE;


        public int getMask() {
            return 1 << this.ordinal();
        }

        public boolean isSelected(int n) {
            return (n & this.getMask()) > 0;
        }
    }
}

