/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MovieViewListener;
import org.apache.pivot.wtk.media.Movie;

public class MovieView
extends Component {
    private Movie movie = null;
    private MovieViewListenerList movieViewListeners = new MovieViewListenerList();

    public MovieView() {
        this(null);
    }

    public MovieView(Movie movie) {
        this.setMovie(movie);
        this.installThemeSkin(MovieView.class);
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        Movie movie2 = this.movie;
        if (movie2 != movie) {
            this.movie = movie;
            this.movieViewListeners.movieChanged(this, movie2);
        }
    }

    public ListenerList<MovieViewListener> getMovieViewListeners() {
        return this.movieViewListeners;
    }

    private static class MovieViewListenerList
    extends ListenerList<MovieViewListener>
    implements MovieViewListener {
        private MovieViewListenerList() {
        }

        @Override
        public void movieChanged(MovieView movieView, Movie movie) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MovieViewListener movieViewListener = (MovieViewListener)iterator.next();
                movieViewListener.movieChanged(movieView, movie);
            }
        }
    }
}

