/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.PromptListener;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.SheetCloseListener;
import org.apache.pivot.wtk.Window;

public class Prompt
extends Sheet {
    private MessageType type = null;
    private String message = null;
    private Component body = null;
    private ArrayList<Object> options = null;
    private int selectedOption = -1;
    private PromptListenerList promptListeners = new PromptListenerList();
    private static Resources resources = null;

    public Prompt(MessageType messageType, String string, Sequence<?> sequence) {
        this(messageType, string, sequence, null);
    }

    public Prompt(MessageType messageType, String string, Sequence<?> sequence, Component component) {
        if (messageType == null) {
            throw new IllegalArgumentException("type is null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("options is null.");
        }
        this.type = messageType;
        this.message = string;
        this.options = new ArrayList(sequence);
        this.body = component;
        this.installThemeSkin(Prompt.class);
    }

    public MessageType getMessageType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getOption(int n) {
        return this.options.get(n);
    }

    public int getOptionCount() {
        return this.options.getLength();
    }

    public Component getBody() {
        return this.body;
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(int n) {
        if (n < -1 || n >= this.options.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedOption;
        if (n != n2) {
            this.selectedOption = n;
            this.promptListeners.selectedOptionChanged(this, n2);
        }
    }

    public ListenerList<PromptListener> getPromptListeners() {
        return this.promptListeners;
    }

    public static void prompt(String string, Window window) {
        Prompt.prompt(MessageType.INFO, string, null, window, null);
    }

    public static void prompt(MessageType messageType, String string, Window window) {
        Prompt.prompt(messageType, string, null, window, null);
    }

    public static void prompt(MessageType messageType, String string, Component component, Window window) {
        Prompt.prompt(messageType, string, component, window, null);
    }

    public static void prompt(MessageType messageType, String string, Component component, Window window, SheetCloseListener sheetCloseListener) {
        Prompt prompt = Prompt.createPrompt(messageType, string, component);
        prompt.open(window, sheetCloseListener);
    }

    private static Prompt createPrompt(MessageType messageType, String string, Component component) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(resources.get("defaultOption"));
        Prompt prompt = new Prompt(messageType, string, (Sequence<?>)arrayList, component);
        prompt.setTitle((String)resources.get("defaultTitle"));
        prompt.setSelectedOption(0);
        return prompt;
    }

    static {
        try {
            resources = new Resources(Prompt.class.getName());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class PromptListenerList
    extends ListenerList<PromptListener>
    implements PromptListener {
        private PromptListenerList() {
        }

        @Override
        public void selectedOptionChanged(Prompt prompt, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PromptListener promptListener = (PromptListener)iterator.next();
                promptListener.selectedOptionChanged(prompt, n);
            }
        }
    }
}

