/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.pivot.io.FileList;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.Picture;

public class RemoteManifest
implements Manifest {
    private Transferable transferable;
    private DataFlavor textDataFlavor = null;
    private DataFlavor imageDataFlavor = null;
    private DataFlavor fileListDataFlavor = null;
    private DataFlavor uriListDataFlavor = null;
    private static final String URI_LIST_MIME_TYPE = "text/uri-list";
    private static final String FILE_URI_SCHEME = "file";

    RemoteManifest(Transferable transferable) {
        assert (transferable != null);
        this.transferable = transferable;
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray != null) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    this.textDataFlavor = dataFlavor;
                    continue;
                }
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    this.imageDataFlavor = dataFlavor;
                    continue;
                }
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    this.fileListDataFlavor = dataFlavor;
                    continue;
                }
                if (!dataFlavor.getMimeType().startsWith(URI_LIST_MIME_TYPE) || dataFlavor.getRepresentationClass() != String.class) continue;
                this.uriListDataFlavor = dataFlavor;
            }
        }
    }

    @Override
    public String getText() throws IOException {
        String string = null;
        try {
            string = (String)this.transferable.getTransferData(this.textDataFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public boolean containsText() {
        return this.textDataFlavor != null;
    }

    @Override
    public Image getImage() throws IOException {
        Picture picture = null;
        try {
            picture = new Picture((BufferedImage)this.transferable.getTransferData(this.imageDataFlavor));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return picture;
    }

    @Override
    public boolean containsImage() {
        return this.imageDataFlavor != null;
    }

    @Override
    public FileList getFileList() throws IOException {
        FileList fileList;
        block7: {
            fileList = null;
            try {
                if (this.fileListDataFlavor != null) {
                    fileList = new FileList((List)this.transferable.getTransferData(this.fileListDataFlavor));
                    break block7;
                }
                if (this.uriListDataFlavor == null) break block7;
                fileList = new FileList();
                String string = (String)this.transferable.getTransferData(this.uriListDataFlavor);
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
                try {
                    String string2 = lineNumberReader.readLine();
                    while (string2 != null) {
                        URI uRI = new URI(string2);
                        String string3 = uRI.getScheme();
                        if (string3 != null && string3.equalsIgnoreCase(FILE_URI_SCHEME)) {
                            File file = new File(uRI);
                            fileList.add(file);
                        }
                        string2 = lineNumberReader.readLine();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return fileList;
    }

    @Override
    public boolean containsFileList() {
        return this.fileListDataFlavor != null || this.uriListDataFlavor != null;
    }

    @Override
    public Object getValue(String string) {
        return null;
    }

    @Override
    public boolean containsValue(String string) {
        return false;
    }
}

