/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.RollupListener;
import org.apache.pivot.wtk.RollupStateListener;

public class Rollup
extends Container {
    private Component heading = null;
    private Component content = null;
    private boolean expanded = true;
    private boolean collapsible = true;
    private RollupListenerList rollupListeners = new RollupListenerList();
    private RollupStateListenerList rollupStateListeners = new RollupStateListenerList();

    public Rollup() {
        this(false, null);
    }

    public Rollup(boolean bl) {
        this(bl, null);
    }

    public Rollup(Component component) {
        this(false, component);
    }

    public Rollup(boolean bl, Component component) {
        this.expanded = bl;
        this.installThemeSkin(Rollup.class);
        if (component != null) {
            this.setContent(component);
        }
    }

    public Component getHeading() {
        return this.heading;
    }

    public void setHeading(Component component) {
        Component component2 = this.heading;
        if (component != component2) {
            this.heading = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.add(component);
            }
            this.heading = component;
            this.rollupListeners.headingChanged(this, component2);
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component component) {
        Component component2 = this.content;
        if (component != component2) {
            this.content = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.add(component);
            }
            this.content = component;
            this.rollupListeners.contentChanged(this, component2);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.expanded) {
            Vote vote = this.rollupStateListeners.previewExpandedChange(this);
            if (vote == Vote.APPROVE) {
                this.expanded = bl;
                this.rollupStateListeners.expandedChanged(this);
            } else {
                this.rollupStateListeners.expandedChangeVetoed(this, vote);
            }
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean bl) {
        if (this.collapsible != bl) {
            this.collapsible = bl;
            this.rollupListeners.collapsibleChanged(this);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.heading && component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<RollupListener> getRollupListeners() {
        return this.rollupListeners;
    }

    public ListenerList<RollupStateListener> getRollupStateListeners() {
        return this.rollupStateListeners;
    }

    private static class RollupStateListenerList
    extends ListenerList<RollupStateListener>
    implements RollupStateListener {
        private RollupStateListenerList() {
        }

        @Override
        public Vote previewExpandedChange(Rollup rollup) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupStateListener rollupStateListener = (RollupStateListener)iterator.next();
                vote = vote.tally(rollupStateListener.previewExpandedChange(rollup));
            }
            return vote;
        }

        @Override
        public void expandedChangeVetoed(Rollup rollup, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupStateListener rollupStateListener = (RollupStateListener)iterator.next();
                rollupStateListener.expandedChangeVetoed(rollup, vote);
            }
        }

        @Override
        public void expandedChanged(Rollup rollup) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupStateListener rollupStateListener = (RollupStateListener)iterator.next();
                rollupStateListener.expandedChanged(rollup);
            }
        }
    }

    private static class RollupListenerList
    extends ListenerList<RollupListener>
    implements RollupListener {
        private RollupListenerList() {
        }

        @Override
        public void headingChanged(Rollup rollup, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupListener rollupListener = (RollupListener)iterator.next();
                rollupListener.headingChanged(rollup, component);
            }
        }

        @Override
        public void contentChanged(Rollup rollup, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupListener rollupListener = (RollupListener)iterator.next();
                rollupListener.contentChanged(rollup, component);
            }
        }

        @Override
        public void collapsibleChanged(Rollup rollup) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RollupListener rollupListener = (RollupListener)iterator.next();
                rollupListener.collapsibleChanged(rollup);
            }
        }
    }
}

