/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBarListener;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.Span;

public class ScrollBar
extends Container {
    private Orientation orientation;
    private int start = 0;
    private int end = 100;
    private int extent = 1;
    private int value = 0;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private ScrollBarListenerList scrollBarListeners = new ScrollBarListenerList();
    private ScrollBarValueListenerList scrollBarValueListeners = new ScrollBarValueListenerList();

    public ScrollBar() {
        this(Orientation.HORIZONTAL);
    }

    public ScrollBar(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        this.orientation = orientation;
        this.installThemeSkin(ScrollBar.class);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        Orientation orientation2 = this.orientation;
        if (orientation != orientation2) {
            this.orientation = orientation;
            this.scrollBarListeners.orientationChanged(this, orientation2);
        }
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.setScope(n, this.end, this.extent);
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.setScope(this.start, n, this.extent);
    }

    public Span getRange() {
        return new Span(this.start, this.end);
    }

    public void setRange(int n, int n2) {
        this.setScope(n, n2, this.extent);
    }

    public final void setRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(span.start, span.end);
    }

    public final void setRange(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(new Span(dictionary));
    }

    public final void setRange(String string) {
        if (string == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(Span.decode(string));
    }

    public int getExtent() {
        return this.extent;
    }

    public void setExtent(int n) {
        this.setScope(this.start, this.end, n);
    }

    public Scope getScope() {
        return new Scope(this.start, this.end, this.extent);
    }

    public void setScope(int n, int n2, int n3) {
        int n4 = this.start;
        int n5 = this.end;
        int n6 = this.extent;
        if (n != n4 || n2 != n5 || n3 != n6) {
            if (n > this.value) {
                throw new IllegalArgumentException(String.format("start (%d) is greater than value (%d)", n, this.value));
            }
            if (n3 < 0) {
                throw new IllegalArgumentException(String.format("extent (%d) is negative", n3));
            }
            if (n2 < this.value + n3) {
                throw new IllegalArgumentException(String.format("end (%d) is less than value (%d) + extent (%d)", n2, this.value, n3));
            }
            this.start = n;
            this.end = n2;
            this.extent = n3;
            this.scrollBarListeners.scopeChanged(this, n4, n5, n6);
        }
    }

    public final void setScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(scope.start, scope.end, scope.extent);
    }

    public final void setScope(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(new Scope(dictionary));
    }

    public final void setScope(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(Scope.decode(string));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        int n2 = this.value;
        if (n != n2) {
            if (n < this.start) {
                throw new IllegalArgumentException(String.format("value (%d) is less than start (%d)", n, this.start));
            }
            if (n + this.extent > this.end) {
                throw new IllegalArgumentException(String.format("value (%d) + extent (%d) is greater than end (%d)", n, this.extent, this.end));
            }
            this.value = n;
            this.scrollBarValueListeners.valueChanged(this, n2);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("unitIncrement is negative");
        }
        int n2 = this.unitIncrement;
        if (n != n2) {
            this.unitIncrement = n;
            this.scrollBarListeners.unitIncrementChanged(this, n2);
        }
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("blockIncrement is negative");
        }
        int n2 = this.blockIncrement;
        if (n != n2) {
            this.blockIncrement = n;
            this.scrollBarListeners.blockIncrementChanged(this, n2);
        }
    }

    public ListenerList<ScrollBarListener> getScrollBarListeners() {
        return this.scrollBarListeners;
    }

    public ListenerList<ScrollBarValueListener> getScrollBarValueListeners() {
        return this.scrollBarValueListeners;
    }

    private static class ScrollBarValueListenerList
    extends ListenerList<ScrollBarValueListener>
    implements ScrollBarValueListener {
        private ScrollBarValueListenerList() {
        }

        @Override
        public void valueChanged(ScrollBar scrollBar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollBarValueListener scrollBarValueListener = (ScrollBarValueListener)iterator.next();
                scrollBarValueListener.valueChanged(scrollBar, n);
            }
        }
    }

    private static class ScrollBarListenerList
    extends ListenerList<ScrollBarListener>
    implements ScrollBarListener {
        private ScrollBarListenerList() {
        }

        @Override
        public void orientationChanged(ScrollBar scrollBar, Orientation orientation) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollBarListener scrollBarListener = (ScrollBarListener)iterator.next();
                scrollBarListener.orientationChanged(scrollBar, orientation);
            }
        }

        @Override
        public void scopeChanged(ScrollBar scrollBar, int n, int n2, int n3) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollBarListener scrollBarListener = (ScrollBarListener)iterator.next();
                scrollBarListener.scopeChanged(scrollBar, n, n2, n3);
            }
        }

        @Override
        public void unitIncrementChanged(ScrollBar scrollBar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollBarListener scrollBarListener = (ScrollBarListener)iterator.next();
                scrollBarListener.unitIncrementChanged(scrollBar, n);
            }
        }

        @Override
        public void blockIncrementChanged(ScrollBar scrollBar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollBarListener scrollBarListener = (ScrollBarListener)iterator.next();
                scrollBarListener.blockIncrementChanged(scrollBar, n);
            }
        }
    }

    public static final class Scope {
        public final int start;
        public final int end;
        public final int extent;
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public static final String EXTENT_KEY = "extent";

        public Scope(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.extent = n3;
        }

        public Scope(Dictionary<String, ?> dictionary) {
            if (dictionary == null) {
                throw new IllegalArgumentException("scope is null.");
            }
            if (!dictionary.containsKey((Object)START_KEY)) {
                throw new IllegalArgumentException("start is required.");
            }
            if (!dictionary.containsKey((Object)END_KEY)) {
                throw new IllegalArgumentException("end is required.");
            }
            if (!dictionary.containsKey((Object)EXTENT_KEY)) {
                throw new IllegalArgumentException("extent is required.");
            }
            this.start = (Integer)dictionary.get((Object)START_KEY);
            this.end = (Integer)dictionary.get((Object)END_KEY);
            this.extent = (Integer)dictionary.get((Object)EXTENT_KEY);
        }

        public String toString() {
            return "{start: " + this.start + ", end: " + this.end + ", extent: " + this.extent + "}";
        }

        public static Scope decode(String string) {
            Scope scope;
            if (string == null) {
                throw new IllegalArgumentException();
            }
            try {
                scope = new Scope((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
            return scope;
        }
    }
}

