/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.SliderListener;
import org.apache.pivot.wtk.SliderValueListener;
import org.apache.pivot.wtk.Span;

public class Slider
extends Container {
    private int start = 0;
    private int end = 100;
    private int value = 0;
    private Orientation orientation = null;
    private SliderListenerList sliderListeners = new SliderListenerList();
    private SliderValueListenerList sliderValueListeners = new SliderValueListenerList();
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_END = 100;
    public static final int DEFAULT_VALUE = 0;

    public Slider() {
        this(Orientation.HORIZONTAL);
    }

    public Slider(Orientation orientation) {
        this.orientation = orientation;
        this.installThemeSkin(Slider.class);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.setRange(n, this.end);
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.setRange(this.start, n);
    }

    public void setRange(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("start is greater than maximum.");
        }
        int n3 = this.start;
        int n4 = this.end;
        int n5 = this.value;
        if (n != n3 || n2 != n4) {
            this.start = n;
            if (this.value < n) {
                this.value = n;
            }
            this.end = n2;
            if (this.value > n2) {
                this.value = n2;
            }
            this.sliderListeners.rangeChanged(this, n3, n4);
            if (n5 < n || n5 > n2) {
                this.sliderValueListeners.valueChanged(this, n5);
            }
        }
    }

    public final void setRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(span.start, span.end);
    }

    public final void setRange(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(new Span(dictionary));
    }

    public final void setRange(String string) {
        if (string == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(Span.decode(string));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (n < this.start) {
            throw new IllegalArgumentException("value is less than minimum.");
        }
        if (n > this.end) {
            throw new IllegalArgumentException("value is greater than maximum.");
        }
        int n2 = this.value;
        if (n != n2) {
            this.value = n;
            this.sliderValueListeners.valueChanged(this, n2);
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.sliderListeners.orientationChanged(this);
        }
    }

    public void setOrientation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        this.setOrientation(Orientation.valueOf(string.toUpperCase()));
    }

    public ListenerList<SliderListener> getSliderListeners() {
        return this.sliderListeners;
    }

    public ListenerList<SliderValueListener> getSliderValueListeners() {
        return this.sliderValueListeners;
    }

    private static class SliderValueListenerList
    extends ListenerList<SliderValueListener>
    implements SliderValueListener {
        private SliderValueListenerList() {
        }

        @Override
        public void valueChanged(Slider slider, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SliderValueListener sliderValueListener = (SliderValueListener)iterator.next();
                sliderValueListener.valueChanged(slider, n);
            }
        }
    }

    private static class SliderListenerList
    extends ListenerList<SliderListener>
    implements SliderListener {
        private SliderListenerList() {
        }

        @Override
        public void orientationChanged(Slider slider) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SliderListener sliderListener = (SliderListener)iterator.next();
                sliderListener.orientationChanged(slider);
            }
        }

        @Override
        public void rangeChanged(Slider slider, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SliderListener sliderListener = (SliderListener)iterator.next();
                sliderListener.rangeChanged(slider, n, n2);
            }
        }
    }
}

