/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Editor;
import org.apache.pivot.wtk.Limits;
import org.apache.pivot.wtk.ListSelection;
import org.apache.pivot.wtk.ListSelectionSequence;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.content.TableViewCellRenderer;

public class TableView
extends Component {
    private ArrayList<Column> columns = new ArrayList();
    private ColumnSequence columnSequence = new ColumnSequence();
    private List<?> tableData = null;
    private ListListener<Object> tableDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int n) {
            TableView.this.selectedRanges.insertIndex(n);
            TableView.this.tableViewRowListeners.rowInserted(TableView.this, n);
        }

        public void itemsRemoved(List<Object> list, int n, Sequence<Object> sequence) {
            int n2 = sequence.getLength();
            TableView.this.selectedRanges.removeIndexes(n, n2);
            TableView.this.tableViewRowListeners.rowsRemoved(TableView.this, n, n2);
        }

        public void itemUpdated(List<Object> list, int n, Object object) {
            TableView.this.tableViewRowListeners.rowUpdated(TableView.this, n);
        }

        public void listCleared(List<Object> list) {
            TableView.this.selectedRanges.clear();
            TableView.this.tableViewRowListeners.rowsCleared(TableView.this);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> comparator) {
            if (list.getComparator() != null) {
                TableView.this.selectedRanges.clear();
                TableView.this.tableViewRowListeners.rowsSorted(TableView.this);
            }
        }
    };
    private TableView columnSource = null;
    private ListSelection selectedRanges = new ListSelection();
    private SelectMode selectMode = SelectMode.SINGLE;
    private HashMap<String, SortDirection> sortMap = new HashMap();
    private ArrayList<String> sortList = new ArrayList();
    private SortDictionary sortDictionary = new SortDictionary();
    private Filter<?> disabledRowFilter = null;
    private RowEditor rowEditor = null;
    private TableViewListenerList tableViewListeners = new TableViewListenerList();
    private TableViewColumnListenerList tableViewColumnListeners = new TableViewColumnListenerList();
    private TableViewRowListenerList tableViewRowListeners = new TableViewRowListenerList();
    private TableViewSelectionListenerList tableViewSelectionListeners = new TableViewSelectionListenerList();
    private TableViewSortListenerList tableViewSortListeners = new TableViewSortListenerList();
    public static final String COLUMN_NAME_KEY = "columnName";
    public static final String SORT_DIRECTION_KEY = "sortDirection";

    public TableView() {
        this((List<?>)new ArrayList());
    }

    public TableView(List<?> list) {
        this.setTableData(list);
        this.installThemeSkin(TableView.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ColumnSequence getColumns() {
        ColumnSequence columnSequence = this.columnSequence;
        if (this.columnSource != null) {
            columnSequence = this.columnSource.getColumns();
        }
        return columnSequence;
    }

    public List<?> getTableData() {
        return this.tableData;
    }

    public void setTableData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        List<?> list2 = this.tableData;
        if (list2 != list) {
            if (list2 != null) {
                this.selectedRanges.clear();
                list2.getListListeners().remove(this.tableDataListener);
            }
            list.getListListeners().add(this.tableDataListener);
            this.tableData = list;
            this.tableViewListeners.tableDataChanged(this, list2);
        }
    }

    public final void setTableData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        try {
            this.setTableData(JSONSerializer.parseList((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    public void setTableData(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        JSONSerializer jSONSerializer = new JSONSerializer();
        try {
            this.setTableData((List)jSONSerializer.readObject(uRL.openStream()));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public TableView getColumnSource() {
        return this.columnSource;
    }

    public void setColumnSource(TableView tableView) {
        TableView tableView2 = this.columnSource;
        if (tableView2 != tableView) {
            this.columnSource = tableView;
            this.tableViewListeners.columnSourceChanged(this, tableView2);
        }
    }

    public RowEditor getRowEditor() {
        return this.rowEditor;
    }

    public void setRowEditor(RowEditor rowEditor) {
        RowEditor rowEditor2 = this.rowEditor;
        if (rowEditor2 != rowEditor) {
            this.rowEditor = rowEditor;
            this.tableViewListeners.rowEditorChanged(this, rowEditor2);
        }
    }

    public int getSelectedIndex() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("Table view is not in single-select mode.");
        }
        return this.selectedRanges.getLength() == 0 ? -1 : this.selectedRanges.get((int)0).start;
    }

    public void setSelectedIndex(int n) {
        if (n == -1) {
            this.clearSelection();
        } else {
            this.setSelectedRange(n, n);
        }
    }

    public void setSelectedRange(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)new Span(n, n2));
        this.setSelectedRanges((Sequence<Span>)arrayList);
    }

    public Sequence<Span> getSelectedRanges() {
        return new ListSelectionSequence(this.selectedRanges);
    }

    public Sequence<Span> setSelectedRanges(Sequence<Span> sequence) {
        Object object;
        if (sequence == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        if (this.selectMode == SelectMode.NONE) {
            throw new IllegalArgumentException("Selection is not enabled.");
        }
        if (this.selectMode == SelectMode.SINGLE) {
            int n = sequence.getLength();
            if (n > 1) {
                throw new IllegalArgumentException("Selection length is greater than 1.");
            }
            if (n > 0 && ((Span)(object = (Span)sequence.get(0))).getLength() > 1L) {
                throw new IllegalArgumentException("Selected range length is greater than 1.");
            }
        }
        ListSelectionSequence listSelectionSequence = new ListSelectionSequence(this.selectedRanges);
        object = new ListSelection();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            Span span = (Span)sequence.get(i);
            if (span == null) {
                throw new IllegalArgumentException("range is null.");
            }
            if (span.start < 0 || span.end >= this.tableData.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            ((ListSelection)object).addRange(span.start, span.end);
        }
        this.selectedRanges = object;
        this.tableViewSelectionListeners.selectedRangesChanged(this, listSelectionSequence);
        return this.getSelectedRanges();
    }

    public final Sequence<Span> setSelectedRanges(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        try {
            this.setSelectedRanges(this.parseSelectedRanges(string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return this.getSelectedRanges();
    }

    private Sequence<Span> parseSelectedRanges(String string) throws SerializationException {
        ArrayList arrayList = new ArrayList();
        List list = JSONSerializer.parseList((String)string);
        for (Object e : list) {
            Map map = (Map)e;
            arrayList.add((Object)new Span((Dictionary<String, ?>)map));
        }
        return arrayList;
    }

    public int getFirstSelectedIndex() {
        return this.selectedRanges.getLength() > 0 ? this.selectedRanges.get((int)0).start : -1;
    }

    public int getLastSelectedIndex() {
        return this.selectedRanges.getLength() > 0 ? this.selectedRanges.get((int)(this.selectedRanges.getLength() - 1)).end : -1;
    }

    public boolean addSelectedIndex(int n) {
        Sequence<Span> sequence = this.addSelectedRange(n, n);
        return sequence.getLength() > 0;
    }

    public Sequence<Span> addSelectedRange(int n, int n2) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Table view is not in multi-select mode.");
        }
        if (n < 0 || n2 >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> sequence = this.selectedRanges.addRange(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Span span = (Span)sequence.get(i);
            this.tableViewSelectionListeners.selectedRangeAdded(this, span.start, span.end);
        }
        return sequence;
    }

    public Sequence<Span> addSelectedRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.addSelectedRange(span.start, span.end);
    }

    public boolean removeSelectedIndex(int n) {
        Sequence<Span> sequence = this.removeSelectedRange(n, n);
        return sequence.getLength() > 0;
    }

    public Sequence<Span> removeSelectedRange(int n, int n2) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Table view is not in multi-select mode.");
        }
        if (n < 0 || n2 >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> sequence = this.selectedRanges.removeRange(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Span span = (Span)sequence.get(i);
            this.tableViewSelectionListeners.selectedRangeRemoved(this, span.start, span.end);
        }
        return sequence;
    }

    public Sequence<Span> removeSelectedRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.removeSelectedRange(span.start, span.end);
    }

    public void selectAll() {
        this.setSelectedRange(0, this.tableData.getLength() - 1);
    }

    public void clearSelection() {
        if (this.selectedRanges.getLength() > 0) {
            ListSelectionSequence listSelectionSequence = new ListSelectionSequence(this.selectedRanges);
            this.selectedRanges = new ListSelection();
            this.tableViewSelectionListeners.selectedRangesChanged(this, listSelectionSequence);
        }
    }

    public boolean isRowSelected(int n) {
        if (n < 0 || n >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.selectedRanges.containsIndex(n);
    }

    public Object getSelectedRow() {
        int n = this.getSelectedIndex();
        Object object = null;
        if (n >= 0) {
            object = this.tableData.get(n);
        }
        return object;
    }

    public Sequence<?> getSelectedRows() {
        ArrayList arrayList = new ArrayList();
        int n = this.selectedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span span = this.selectedRanges.get(i);
            for (int j = span.start; j <= span.end; ++j) {
                Object object = this.tableData.get(j);
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        SelectMode selectMode2 = this.selectMode;
        if (selectMode2 != selectMode) {
            this.clearSelection();
            this.selectMode = selectMode;
            this.tableViewListeners.selectModeChanged(this, selectMode2);
        }
    }

    public void setSelectMode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        this.setSelectMode(SelectMode.valueOf(string.toUpperCase()));
    }

    public SortDictionary getSort() {
        return this.sortDictionary;
    }

    public Dictionary<String, SortDirection> setSort(String string, SortDirection sortDirection) {
        Dictionary.Pair pair = new Dictionary.Pair((Object)string, (Object)sortDirection);
        this.setSort((Sequence<Dictionary.Pair<String, SortDirection>>)new ArrayList((Object[])new Dictionary.Pair[]{pair}));
        return this.getSort();
    }

    public Dictionary<String, SortDirection> setSort(Sequence<Dictionary.Pair<String, SortDirection>> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        this.sortMap.clear();
        this.sortList.clear();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            Dictionary.Pair pair = (Dictionary.Pair)sequence.get(i);
            if (this.sortMap.containsKey(pair.key)) continue;
            this.sortMap.put(pair.key, pair.value);
            this.sortList.add(pair.key);
        }
        this.tableViewSortListeners.sortChanged(this);
        return this.getSort();
    }

    public final Dictionary<String, SortDirection> setSort(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.setSort(this.parseSort(string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return this.getSort();
    }

    private Sequence<Dictionary.Pair<String, SortDirection>> parseSort(String string) throws SerializationException {
        ArrayList arrayList = new ArrayList();
        List list = JSONSerializer.parseList((String)string);
        for (Object e : list) {
            Map map = (Map)e;
            Dictionary.Pair pair = new Dictionary.Pair((Object)((String)map.get((Object)COLUMN_NAME_KEY)), (Object)SortDirection.valueOf(((String)map.get((Object)SORT_DIRECTION_KEY)).toLowerCase()));
            arrayList.add((Object)pair);
        }
        return arrayList;
    }

    public void clearSort() {
        if (!this.sortMap.isEmpty()) {
            this.sortMap.clear();
            this.sortList.clear();
            this.tableViewSortListeners.sortChanged(this);
        }
    }

    public boolean isRowDisabled(int n) {
        boolean bl = false;
        if (this.disabledRowFilter != null) {
            Object object = this.tableData.get(n);
            bl = this.disabledRowFilter.include(object);
        }
        return bl;
    }

    public Filter<?> getDisabledRowFilter() {
        return this.disabledRowFilter;
    }

    public void setDisabledRowFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledRowFilter;
        if (filter2 != filter) {
            this.disabledRowFilter = filter;
            this.tableViewListeners.disabledRowFilterChanged(this, filter2);
        }
    }

    public int getRowAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowAt(n);
    }

    public int getColumnAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnAt(n);
    }

    public Bounds getRowBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowBounds(n);
    }

    public Bounds getColumnBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnBounds(n);
    }

    public Bounds getCellBounds(int n, int n2) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getCellBounds(n, n2);
    }

    public ListenerList<TableViewListener> getTableViewListeners() {
        return this.tableViewListeners;
    }

    public ListenerList<TableViewColumnListener> getTableViewColumnListeners() {
        return this.tableViewColumnListeners;
    }

    public ListenerList<TableViewRowListener> getTableViewRowListeners() {
        return this.tableViewRowListeners;
    }

    public ListenerList<TableViewSelectionListener> getTableViewSelectionListeners() {
        return this.tableViewSelectionListeners;
    }

    public ListenerList<TableViewSortListener> getTableViewSortListeners() {
        return this.tableViewSortListeners;
    }

    private static class TableViewSortListenerList
    extends ListenerList<TableViewSortListener>
    implements TableViewSortListener {
        private TableViewSortListenerList() {
        }

        @Override
        public void sortAdded(TableView tableView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSortListener tableViewSortListener = (TableViewSortListener)iterator.next();
                tableViewSortListener.sortAdded(tableView, string);
            }
        }

        @Override
        public void sortUpdated(TableView tableView, String string, SortDirection sortDirection) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSortListener tableViewSortListener = (TableViewSortListener)iterator.next();
                tableViewSortListener.sortUpdated(tableView, string, sortDirection);
            }
        }

        @Override
        public void sortRemoved(TableView tableView, String string, SortDirection sortDirection) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSortListener tableViewSortListener = (TableViewSortListener)iterator.next();
                tableViewSortListener.sortRemoved(tableView, string, sortDirection);
            }
        }

        @Override
        public void sortChanged(TableView tableView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSortListener tableViewSortListener = (TableViewSortListener)iterator.next();
                tableViewSortListener.sortChanged(tableView);
            }
        }
    }

    private static class TableViewSelectionListenerList
    extends ListenerList<TableViewSelectionListener>
    implements TableViewSelectionListener {
        private TableViewSelectionListenerList() {
        }

        @Override
        public void selectedRangeAdded(TableView tableView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSelectionListener tableViewSelectionListener = (TableViewSelectionListener)iterator.next();
                tableViewSelectionListener.selectedRangeAdded(tableView, n, n2);
            }
        }

        @Override
        public void selectedRangeRemoved(TableView tableView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSelectionListener tableViewSelectionListener = (TableViewSelectionListener)iterator.next();
                tableViewSelectionListener.selectedRangeRemoved(tableView, n, n2);
            }
        }

        @Override
        public void selectedRangesChanged(TableView tableView, Sequence<Span> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewSelectionListener tableViewSelectionListener = (TableViewSelectionListener)iterator.next();
                tableViewSelectionListener.selectedRangesChanged(tableView, sequence);
            }
        }
    }

    private static class TableViewRowListenerList
    extends ListenerList<TableViewRowListener>
    implements TableViewRowListener {
        private TableViewRowListenerList() {
        }

        @Override
        public void rowInserted(TableView tableView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewRowListener tableViewRowListener = (TableViewRowListener)iterator.next();
                tableViewRowListener.rowInserted(tableView, n);
            }
        }

        @Override
        public void rowsRemoved(TableView tableView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewRowListener tableViewRowListener = (TableViewRowListener)iterator.next();
                tableViewRowListener.rowsRemoved(tableView, n, n2);
            }
        }

        @Override
        public void rowUpdated(TableView tableView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewRowListener tableViewRowListener = (TableViewRowListener)iterator.next();
                tableViewRowListener.rowUpdated(tableView, n);
            }
        }

        @Override
        public void rowsCleared(TableView tableView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewRowListener tableViewRowListener = (TableViewRowListener)iterator.next();
                tableViewRowListener.rowsCleared(tableView);
            }
        }

        @Override
        public void rowsSorted(TableView tableView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewRowListener tableViewRowListener = (TableViewRowListener)iterator.next();
                tableViewRowListener.rowsSorted(tableView);
            }
        }
    }

    private static class TableViewColumnListenerList
    extends ListenerList<TableViewColumnListener>
    implements TableViewColumnListener {
        private TableViewColumnListenerList() {
        }

        @Override
        public void columnInserted(TableView tableView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnInserted(tableView, n);
            }
        }

        @Override
        public void columnsRemoved(TableView tableView, int n, Sequence<Column> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnsRemoved(tableView, n, sequence);
            }
        }

        @Override
        public void columnNameChanged(Column column, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnNameChanged(column, string);
            }
        }

        @Override
        public void columnHeaderDataChanged(Column column, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnHeaderDataChanged(column, object);
            }
        }

        @Override
        public void columnWidthChanged(Column column, int n, boolean bl) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnWidthChanged(column, n, bl);
            }
        }

        @Override
        public void columnWidthLimitsChanged(Column column, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnWidthLimitsChanged(column, n, n2);
            }
        }

        @Override
        public void columnFilterChanged(Column column, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnFilterChanged(column, object);
            }
        }

        @Override
        public void columnCellRendererChanged(Column column, CellRenderer cellRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewColumnListener tableViewColumnListener = (TableViewColumnListener)iterator.next();
                tableViewColumnListener.columnCellRendererChanged(column, cellRenderer);
            }
        }
    }

    public final class SortDictionary
    implements Dictionary<String, SortDirection>,
    Iterable<String> {
        public SortDirection get(String string) {
            return (SortDirection)((Object)TableView.this.sortMap.get((Object)string));
        }

        public SortDirection put(String string, SortDirection sortDirection) {
            SortDirection sortDirection2;
            if (sortDirection == null) {
                sortDirection2 = this.remove(string);
            } else {
                boolean bl = this.containsKey(string);
                sortDirection2 = (SortDirection)((Object)TableView.this.sortMap.put((Object)string, (Object)sortDirection));
                if (bl) {
                    TableView.this.tableViewSortListeners.sortUpdated(TableView.this, string, sortDirection2);
                } else {
                    TableView.this.sortList.add((Object)string);
                    TableView.this.tableViewSortListeners.sortAdded(TableView.this, string);
                }
            }
            return sortDirection2;
        }

        public SortDirection remove(String string) {
            SortDirection sortDirection = null;
            if (this.containsKey(string)) {
                sortDirection = (SortDirection)((Object)TableView.this.sortMap.remove((Object)string));
                TableView.this.sortList.remove((Object)string);
                TableView.this.tableViewSortListeners.sortRemoved(TableView.this, string, sortDirection);
            }
            return sortDirection;
        }

        public boolean containsKey(String string) {
            return TableView.this.sortMap.containsKey((Object)string);
        }

        public boolean isEmpty() {
            return TableView.this.sortMap.isEmpty();
        }

        public Dictionary.Pair<String, SortDirection> get(int n) {
            String string = (String)TableView.this.sortList.get(n);
            SortDirection sortDirection = (SortDirection)((Object)TableView.this.sortMap.get((Object)string));
            return new Dictionary.Pair((Object)string, (Object)sortDirection);
        }

        public int getLength() {
            return TableView.this.sortList.getLength();
        }

        @Override
        public Iterator<String> iterator() {
            return TableView.this.sortList.iterator();
        }
    }

    private static class TableViewListenerList
    extends ListenerList<TableViewListener>
    implements TableViewListener {
        private TableViewListenerList() {
        }

        @Override
        public void tableDataChanged(TableView tableView, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewListener tableViewListener = (TableViewListener)iterator.next();
                tableViewListener.tableDataChanged(tableView, list);
            }
        }

        @Override
        public void columnSourceChanged(TableView tableView, TableView tableView2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewListener tableViewListener = (TableViewListener)iterator.next();
                tableViewListener.columnSourceChanged(tableView, tableView2);
            }
        }

        @Override
        public void rowEditorChanged(TableView tableView, RowEditor rowEditor) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewListener tableViewListener = (TableViewListener)iterator.next();
                tableViewListener.rowEditorChanged(tableView, rowEditor);
            }
        }

        @Override
        public void selectModeChanged(TableView tableView, SelectMode selectMode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewListener tableViewListener = (TableViewListener)iterator.next();
                tableViewListener.selectModeChanged(tableView, selectMode);
            }
        }

        @Override
        public void disabledRowFilterChanged(TableView tableView, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewListener tableViewListener = (TableViewListener)iterator.next();
                tableViewListener.disabledRowFilterChanged(tableView, filter);
            }
        }
    }

    public final class ColumnSequence
    implements Sequence<Column>,
    Iterable<Column> {
        public int add(Column column) {
            int n = this.getLength();
            this.insert(column, n);
            return n;
        }

        public void insert(Column column, int n) {
            if (column == null) {
                throw new IllegalArgumentException("column is null.");
            }
            if (column.getTableView() != null) {
                throw new IllegalArgumentException("column is already in use by another table view.");
            }
            TableView.this.columns.insert((Object)column, n);
            column.setTableView(TableView.this);
            TableView.this.tableViewColumnListeners.columnInserted(TableView.this, n);
        }

        public Column update(int n, Column column) {
            throw new UnsupportedOperationException();
        }

        public int remove(Column column) {
            int n = this.indexOf(column);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Column> remove(int n, int n2) {
            Sequence sequence = TableView.this.columns.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    ((Column)sequence.get(i)).setTableView(null);
                }
                TableView.this.tableViewColumnListeners.columnsRemoved(TableView.this, n, (Sequence<Column>)sequence);
            }
            return sequence;
        }

        public Column get(int n) {
            return (Column)TableView.this.columns.get(n);
        }

        public int indexOf(Column column) {
            return TableView.this.columns.indexOf((Object)column);
        }

        public int getLength() {
            return TableView.this.columns.getLength();
        }

        @Override
        public Iterator<Column> iterator() {
            return new ImmutableIterator((Iterator)TableView.this.columns.iterator());
        }
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public int getColumnAt(int var1);

        public Bounds getRowBounds(int var1);

        public Bounds getColumnBounds(int var1);

        public Bounds getCellBounds(int var1, int var2);
    }

    public static interface RowEditorListener {
        public Vote previewEditRow(RowEditor var1, TableView var2, int var3, int var4);

        public void editRowVetoed(RowEditor var1, Vote var2);

        public void rowEditing(RowEditor var1, TableView var2, int var3, int var4);

        public Vote previewSaveChanges(RowEditor var1, TableView var2, int var3, int var4, Dictionary<String, Object> var5);

        public void saveChangesVetoed(RowEditor var1, Vote var2);

        public void changesSaved(RowEditor var1, TableView var2, int var3, int var4);

        public void editCancelled(RowEditor var1, TableView var2, int var3, int var4);

        public static class Adapter
        implements RowEditorListener {
            @Override
            public Vote previewEditRow(RowEditor rowEditor, TableView tableView, int n, int n2) {
                return Vote.APPROVE;
            }

            @Override
            public void editRowVetoed(RowEditor rowEditor, Vote vote) {
            }

            @Override
            public void rowEditing(RowEditor rowEditor, TableView tableView, int n, int n2) {
            }

            @Override
            public Vote previewSaveChanges(RowEditor rowEditor, TableView tableView, int n, int n2, Dictionary<String, Object> dictionary) {
                return Vote.APPROVE;
            }

            @Override
            public void saveChangesVetoed(RowEditor rowEditor, Vote vote) {
            }

            @Override
            public void changesSaved(RowEditor rowEditor, TableView tableView, int n, int n2) {
            }

            @Override
            public void editCancelled(RowEditor rowEditor, TableView tableView, int n, int n2) {
            }
        }
    }

    public static interface RowEditor
    extends Editor {
        public void editRow(TableView var1, int var2, int var3);

        public ListenerList<RowEditorListener> getRowEditorListeners();

        public static class RowEditorListenerList
        extends ListenerList<RowEditorListener>
        implements RowEditorListener {
            @Override
            public Vote previewEditRow(RowEditor rowEditor, TableView tableView, int n, int n2) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    vote = vote.tally(rowEditorListener.previewEditRow(rowEditor, tableView, n, n2));
                }
                return vote;
            }

            @Override
            public void editRowVetoed(RowEditor rowEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    rowEditorListener.editRowVetoed(rowEditor, vote);
                }
            }

            @Override
            public void rowEditing(RowEditor rowEditor, TableView tableView, int n, int n2) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    rowEditorListener.rowEditing(rowEditor, tableView, n, n2);
                }
            }

            @Override
            public Vote previewSaveChanges(RowEditor rowEditor, TableView tableView, int n, int n2, Dictionary<String, Object> dictionary) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    vote = vote.tally(rowEditorListener.previewSaveChanges(rowEditor, tableView, n, n2, dictionary));
                }
                return vote;
            }

            @Override
            public void saveChangesVetoed(RowEditor rowEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    rowEditorListener.saveChangesVetoed(rowEditor, vote);
                }
            }

            @Override
            public void changesSaved(RowEditor rowEditor, TableView tableView, int n, int n2) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    rowEditorListener.changesSaved(rowEditor, tableView, n, n2);
                }
            }

            @Override
            public void editCancelled(RowEditor rowEditor, TableView tableView, int n, int n2) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    RowEditorListener rowEditorListener = (RowEditorListener)iterator.next();
                    rowEditorListener.editCancelled(rowEditor, tableView, n, n2);
                }
            }
        }
    }

    public static interface CellRenderer
    extends Renderer {
        public void render(Object var1, int var2, int var3, TableView var4, String var5, boolean var6, boolean var7, boolean var8);
    }

    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }

    public static final class Column {
        private TableView tableView = null;
        private String name = null;
        private Object headerData = null;
        private int width = 0;
        private int minimumWidth = 0;
        private int maximumWidth = Integer.MAX_VALUE;
        private boolean relative = false;
        private Object filter = null;
        private CellRenderer cellRenderer = DEFAULT_CELL_RENDERER;
        private static final CellRenderer DEFAULT_CELL_RENDERER = new TableViewCellRenderer();
        public static final int DEFAULT_WIDTH = 100;

        public Column() {
            this(null, null, 100, false);
        }

        public Column(String string) {
            this(string, null, 100, false);
        }

        public Column(String string, Object object) {
            this(string, object, 100, false);
        }

        public Column(String string, Object object, int n) {
            this(string, object, n, false);
        }

        public Column(String string, Object object, int n, boolean bl) {
            this.setName(string);
            this.setHeaderData(object);
            this.setWidth(n, bl);
        }

        public TableView getTableView() {
            return this.tableView;
        }

        private void setTableView(TableView tableView) {
            this.tableView = tableView;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            String string2 = this.name;
            if (string2 != string) {
                this.name = string;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnNameChanged(this, string2);
                }
            }
        }

        public Object getHeaderData() {
            return this.headerData;
        }

        public void setHeaderData(Object object) {
            Object object2 = this.headerData;
            if (object2 != object) {
                this.headerData = object;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnHeaderDataChanged(this, object2);
                }
            }
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setWidth(int n) {
            this.setWidth(n, false);
        }

        public void setWidth(String string) {
            boolean bl = false;
            if (string.endsWith("*")) {
                bl = true;
                string = string.substring(0, string.length() - 1);
            }
            this.setWidth(Integer.parseInt(string), bl);
        }

        public void setWidth(int n, boolean bl) {
            if (n < (bl ? 0 : -1)) {
                throw new IllegalArgumentException();
            }
            int n2 = this.width;
            boolean bl2 = this.relative;
            if (n2 != n || bl2 != bl) {
                this.width = n;
                this.relative = bl;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnWidthChanged(this, n2, bl2);
                }
            }
        }

        public Limits getWidthLimits() {
            return new Limits(this.minimumWidth, this.maximumWidth);
        }

        public void setWidthLimits(int n, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("Minimum width is negative.");
            }
            if (n2 < n) {
                throw new IllegalArgumentException("Maximum width is smaller than minimum width.");
            }
            int n3 = this.minimumWidth;
            int n4 = this.maximumWidth;
            if (n != n3 || n2 != n4) {
                this.minimumWidth = n;
                this.maximumWidth = n2;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnWidthLimitsChanged(this, n3, n4);
                }
            }
        }

        public void setWidthLimits(Limits limits) {
            this.setWidthLimits(limits.min, limits.max);
        }

        public int getMinimumWidth() {
            return this.minimumWidth;
        }

        public void setMinimumWidth(int n) {
            this.setWidthLimits(n, this.maximumWidth);
        }

        public int getMaximumWidth() {
            return this.maximumWidth;
        }

        public void setMaximumWidth(int n) {
            this.setWidthLimits(this.minimumWidth, n);
        }

        public Object getFilter() {
            return this.filter;
        }

        public void setFilter(Object object) {
            Object object2 = this.filter;
            if (object2 != object) {
                this.filter = object;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnFilterChanged(this, object2);
                }
            }
        }

        public CellRenderer getCellRenderer() {
            return this.cellRenderer;
        }

        public void setCellRenderer(CellRenderer cellRenderer) {
            if (cellRenderer == null) {
                throw new IllegalArgumentException("cellRenderer is null.");
            }
            CellRenderer cellRenderer2 = this.cellRenderer;
            if (cellRenderer2 != cellRenderer) {
                this.cellRenderer = cellRenderer;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnCellRendererChanged(this, cellRenderer2);
                }
            }
        }
    }
}

