/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewHeaderListener;
import org.apache.pivot.wtk.TableViewHeaderPressListener;
import org.apache.pivot.wtk.content.TableViewHeaderDataRenderer;

public class TableViewHeader
extends Component {
    private TableView tableView;
    private DataRenderer dataRenderer;
    private SortMode sortMode = SortMode.NONE;
    private TableViewHeaderListenerList tableViewHeaderListeners = new TableViewHeaderListenerList();
    private TableViewHeaderPressListenerList tableViewHeaderPressListeners = new TableViewHeaderPressListenerList();

    public TableViewHeader() {
        this(null);
    }

    public TableViewHeader(TableView tableView) {
        this.setDataRenderer(new TableViewHeaderDataRenderer());
        this.installThemeSkin(TableViewHeader.class);
        this.setTableView(tableView);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public void setTableView(TableView tableView) {
        TableView tableView2 = this.tableView;
        if (tableView2 != tableView) {
            this.tableView = tableView;
            this.tableViewHeaderListeners.tableViewChanged(this, tableView2);
        }
    }

    public DataRenderer getDataRenderer() {
        return this.dataRenderer;
    }

    public void setDataRenderer(DataRenderer dataRenderer) {
        if (dataRenderer == null) {
            throw new IllegalArgumentException("dataRenderer is null.");
        }
        DataRenderer dataRenderer2 = this.dataRenderer;
        if (dataRenderer2 != dataRenderer) {
            this.dataRenderer = dataRenderer;
            this.tableViewHeaderListeners.dataRendererChanged(this, dataRenderer2);
        }
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        if (sortMode == null) {
            throw new IllegalArgumentException();
        }
        SortMode sortMode2 = this.sortMode;
        if (sortMode2 != sortMode) {
            this.sortMode = sortMode;
            this.tableViewHeaderListeners.sortModeChanged(this, sortMode2);
        }
    }

    public void setSortMode(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.setSortMode(SortMode.valueOf(string.toUpperCase()));
    }

    public void pressHeader(int n) {
        this.tableViewHeaderPressListeners.headerPressed(this, n);
    }

    public int getHeaderAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getHeaderAt(n);
    }

    public Bounds getHeaderBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getHeaderBounds(n);
    }

    public ListenerList<TableViewHeaderListener> getTableViewHeaderListeners() {
        return this.tableViewHeaderListeners;
    }

    public ListenerList<TableViewHeaderPressListener> getTableViewHeaderPressListeners() {
        return this.tableViewHeaderPressListeners;
    }

    private static class TableViewHeaderPressListenerList
    extends ListenerList<TableViewHeaderPressListener>
    implements TableViewHeaderPressListener {
        private TableViewHeaderPressListenerList() {
        }

        @Override
        public void headerPressed(TableViewHeader tableViewHeader, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewHeaderPressListener tableViewHeaderPressListener = (TableViewHeaderPressListener)iterator.next();
                tableViewHeaderPressListener.headerPressed(tableViewHeader, n);
            }
        }
    }

    private static class TableViewHeaderListenerList
    extends ListenerList<TableViewHeaderListener>
    implements TableViewHeaderListener {
        private TableViewHeaderListenerList() {
        }

        @Override
        public void tableViewChanged(TableViewHeader tableViewHeader, TableView tableView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewHeaderListener tableViewHeaderListener = (TableViewHeaderListener)iterator.next();
                tableViewHeaderListener.tableViewChanged(tableViewHeader, tableView);
            }
        }

        @Override
        public void dataRendererChanged(TableViewHeader tableViewHeader, DataRenderer dataRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewHeaderListener tableViewHeaderListener = (TableViewHeaderListener)iterator.next();
                tableViewHeaderListener.dataRendererChanged(tableViewHeader, dataRenderer);
            }
        }

        @Override
        public void sortModeChanged(TableViewHeader tableViewHeader, SortMode sortMode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TableViewHeaderListener tableViewHeaderListener = (TableViewHeaderListener)iterator.next();
                tableViewHeaderListener.sortModeChanged(tableViewHeader, sortMode);
            }
        }
    }

    public static interface Skin {
        public int getHeaderAt(int var1);

        public Bounds getHeaderBounds(int var1);
    }

    public static interface DataRenderer
    extends Renderer {
        public void render(Object var1, TableViewHeader var2, boolean var3);
    }

    public static enum SortMode {
        NONE,
        SINGLE_COLUMN,
        MULTI_COLUMN;

    }
}

