/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextAreaCharacterListener;
import org.apache.pivot.wtk.TextAreaListener;
import org.apache.pivot.wtk.TextAreaSelectionListener;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.text.Document;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;
import org.apache.pivot.wtk.text.Paragraph;
import org.apache.pivot.wtk.text.PlainTextSerializer;
import org.apache.pivot.wtk.text.TextNode;

public class TextArea
extends Component {
    private Document document;
    private int selectionStart = 0;
    private int selectionLength = 0;
    private boolean editable = true;
    private String textKey = null;
    private NodeListener documentListener = new NodeListener(){

        @Override
        public void parentChanged(Node node, Element element) {
        }

        @Override
        public void offsetChanged(Node node, int n) {
        }

        @Override
        public void rangeInserted(Node node, int n, int n2) {
            if (TextArea.this.selectionStart + TextArea.this.selectionLength > n) {
                if (TextArea.this.selectionStart > n) {
                    TextArea.this.selectionStart += n2;
                } else {
                    TextArea.this.selectionLength += n2;
                }
            }
            TextArea.this.textAreaCharacterListeners.charactersInserted(TextArea.this, n, n2);
        }

        @Override
        public void rangeRemoved(Node node, int n, int n2) {
            if (TextArea.this.selectionStart + TextArea.this.selectionLength > n) {
                if (TextArea.this.selectionStart > n) {
                    TextArea.this.selectionStart -= n2;
                } else {
                    TextArea.this.selectionLength -= n2;
                }
            }
            TextArea.this.textAreaCharacterListeners.charactersRemoved(TextArea.this, n, n2);
        }
    };
    private TextAreaListenerList textAreaListeners = new TextAreaListenerList();
    private TextAreaCharacterListenerList textAreaCharacterListeners = new TextAreaCharacterListenerList();
    private TextAreaSelectionListenerList textAreaSelectionListeners = new TextAreaSelectionListenerList();

    public TextArea() {
        this.installThemeSkin(TextArea.class);
        this.setText("");
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        Document document2 = this.document;
        if (document2 != document) {
            if (document2 != null) {
                document2.getNodeListeners().remove((Object)this.documentListener);
            }
            if (document != null) {
                document.getNodeListeners().add((Object)this.documentListener);
            }
            this.document = document;
            this.selectionStart = 0;
            this.selectionLength = 0;
            this.textAreaListeners.documentChanged(this, document2);
        }
    }

    public String getText() {
        String string = null;
        Document document = this.getDocument();
        if (document != null) {
            try {
                PlainTextSerializer plainTextSerializer = new PlainTextSerializer();
                StringWriter stringWriter = new StringWriter();
                plainTextSerializer.writeObject(document, stringWriter);
                string = stringWriter.toString();
            }
            catch (SerializationException serializationException) {
                throw new RuntimeException(serializationException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return string;
    }

    public void setText(String string) {
        Document document = null;
        if (string != null && string.length() > 0) {
            try {
                PlainTextSerializer plainTextSerializer = new PlainTextSerializer();
                StringReader stringReader = new StringReader(string);
                document = plainTextSerializer.readObject(stringReader);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            document = new Document();
            document.add(new Paragraph(""));
        }
        this.setDocument(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(URL uRL) {
        PlainTextSerializer plainTextSerializer = new PlainTextSerializer("UTF-8");
        Document document = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = uRL.openStream();
                document = plainTextSerializer.readObject(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        this.setDocument(document);
    }

    public void insertText(char c) {
        this.insertText(Character.toString(c));
    }

    public void insertText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.delete(Direction.FORWARD);
        }
        Node node = this.document.getDescendantAt(this.selectionStart);
        int n = this.selectionStart - node.getDocumentOffset();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            textNode.insertText(string, n);
        } else if (node instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)node;
            int n2 = paragraph.getLength();
            if (n2 > 0) {
                Node node2 = paragraph.get(n2 - 1);
                if (node2 instanceof TextNode) {
                    TextNode textNode = (TextNode)node2;
                    textNode.insertText(string, n - textNode.getOffset());
                } else {
                    paragraph.add(new TextNode(string));
                }
            } else {
                paragraph.add(new TextNode(string));
            }
        } else {
            Element element = node.getParent();
            int n3 = element.indexOf(node);
            element.insert(new TextNode(string), n3);
        }
        this.setSelection(this.selectionStart + string.length(), 0);
    }

    public void insertImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image is null.");
        }
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.document.removeRange(this.selectionStart, this.selectionLength);
        }
        this.setSelection(this.selectionStart + 1, this.selectionLength);
    }

    public void insertParagraph() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            this.document.removeRange(this.selectionStart, this.selectionLength);
        }
        Node node = this.document.getDescendantAt(this.selectionStart);
        while (!(node instanceof Paragraph)) {
            node = node.getParent();
        }
        Paragraph paragraph = (Paragraph)node;
        int n = this.selectionStart - paragraph.getDocumentOffset();
        int n2 = paragraph.getCharacterCount() - n;
        Paragraph paragraph2 = (Paragraph)paragraph.removeRange(n, n2);
        Element element = paragraph.getParent();
        int n3 = element.indexOf(paragraph);
        element.insert(paragraph2, n3 + 1);
        this.setSelection(this.selectionStart + 1, this.selectionLength);
    }

    public void delete(Direction direction) {
        int n;
        if (direction == null) {
            throw new IllegalArgumentException("direction is null.");
        }
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        int n2 = this.selectionStart;
        if (this.selectionLength > 0) {
            n = this.selectionLength;
        } else {
            if (direction == Direction.BACKWARD) {
                --n2;
            }
            n = 1;
        }
        if (n2 >= 0 && n2 < this.document.getCharacterCount()) {
            Node node = this.document.getDescendantAt(n2);
            if (this.selectionLength == 0 && node instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)node;
                Element element = paragraph.getParent();
                int n3 = element.indexOf(paragraph);
                if (n3 < element.getLength() - 1) {
                    Sequence<Node> sequence = element.remove(n3 + 1, 1);
                    Paragraph paragraph2 = (Paragraph)sequence.get(0);
                    paragraph.insertRange(paragraph2, paragraph.getCharacterCount() - 1);
                }
            } else {
                this.document.removeRange(n2, n);
            }
        }
        if (this.document.getCharacterCount() == 0) {
            this.document.add(new Paragraph(""));
        }
        if (n2 >= 0) {
            this.setSelection(n2, 0);
        }
    }

    public void cut() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            Object object;
            Document document = (Document)this.document.removeRange(this.selectionStart, this.selectionLength);
            String string = null;
            try {
                object = new PlainTextSerializer();
                StringWriter stringWriter = new StringWriter();
                ((PlainTextSerializer)object).writeObject(document, stringWriter);
                string = stringWriter.toString();
            }
            catch (SerializationException serializationException) {
                throw new RuntimeException(serializationException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (string != null) {
                object = new LocalManifest();
                ((LocalManifest)object).putText(string);
                Clipboard.setContent((LocalManifest)object);
            }
        }
        this.setSelection(this.selectionStart, 0);
    }

    public void copy() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        String string = this.getSelectedText();
        if (string != null) {
            LocalManifest localManifest = new LocalManifest();
            localManifest.putText(string);
            Clipboard.setContent(localManifest);
        }
    }

    public void paste() {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        Manifest manifest = Clipboard.getContent();
        if (manifest != null && manifest.containsText()) {
            String string = null;
            try {
                string = manifest.getText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                int n;
                if (this.selectionLength > 0) {
                    this.delete(Direction.BACKWARD);
                }
                try {
                    PlainTextSerializer plainTextSerializer = new PlainTextSerializer();
                    StringReader stringReader = new StringReader(string);
                    Document document = plainTextSerializer.readObject(stringReader);
                    n = document.getCharacterCount();
                    this.document.insertRange(document, this.selectionStart);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                this.setSelection(this.selectionStart + n, 0);
            }
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public Span getSelection() {
        return this.selectionLength == 0 ? null : new Span(this.selectionStart, this.selectionStart + this.selectionLength - 1);
    }

    public void setSelection(int n, int n2) {
        if (this.document == null || this.document.getCharacterCount() == 0) {
            throw new IllegalStateException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("selectionLength is negative.");
        }
        if (n < 0 || n + n2 > this.document.getCharacterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.selectionStart;
        int n4 = this.selectionLength;
        if (n3 != n || n4 != n2) {
            this.selectionStart = n;
            this.selectionLength = n2;
            this.textAreaSelectionListeners.selectionChanged(this, n3, n4);
        }
    }

    public final void setSelection(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("selection is null.");
        }
        this.setSelection(Math.min(span.start, span.end), (int)span.getLength());
    }

    public void selectAll() {
        if (this.document == null) {
            throw new IllegalStateException();
        }
        this.setSelection(0, this.document.getCharacterCount());
    }

    public void clearSelection() {
        this.setSelection(0, 0);
    }

    public String getSelectedText() {
        String string = null;
        if (this.selectionLength > 0) {
            Document document = (Document)this.document.getRange(this.selectionStart, this.selectionLength);
            try {
                PlainTextSerializer plainTextSerializer = new PlainTextSerializer();
                StringWriter stringWriter = new StringWriter();
                plainTextSerializer.writeObject(document, stringWriter);
                string = stringWriter.toString();
            }
            catch (SerializationException serializationException) {
                throw new RuntimeException(serializationException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable != bl) {
            if (!bl && this.isFocused()) {
                TextArea.clearFocus();
            }
            this.editable = bl;
            this.textAreaListeners.editableChanged(this);
        }
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String string) {
        String string2 = this.textKey;
        if (string2 != string) {
            this.textKey = string;
            this.textAreaListeners.textKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.textKey != null && JSONSerializer.containsKey(dictionary, (String)this.textKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.textKey);
            if (object != null) {
                object = object.toString();
            }
            this.setText((String)object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.textKey != null) {
            JSONSerializer.put(dictionary, (String)this.textKey, (Object)this.getText());
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText((String)null);
        }
    }

    public int getInsertionPoint(int n, int n2) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getInsertionPoint(n, n2);
    }

    public int getNextInsertionPoint(int n, int n2, Direction direction) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getNextInsertionPoint(n, n2, direction);
    }

    public int getRowIndex(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowIndex(n);
    }

    public int getRowCount() {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowCount();
    }

    public Bounds getCharacterBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getCharacterBounds(n);
    }

    public ListenerList<TextAreaListener> getTextAreaListeners() {
        return this.textAreaListeners;
    }

    public ListenerList<TextAreaCharacterListener> getTextAreaCharacterListeners() {
        return this.textAreaCharacterListeners;
    }

    public ListenerList<TextAreaSelectionListener> getTextAreaSelectionListeners() {
        return this.textAreaSelectionListeners;
    }

    private static class TextAreaSelectionListenerList
    extends ListenerList<TextAreaSelectionListener>
    implements TextAreaSelectionListener {
        private TextAreaSelectionListenerList() {
        }

        @Override
        public void selectionChanged(TextArea textArea, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaSelectionListener textAreaSelectionListener = (TextAreaSelectionListener)iterator.next();
                textAreaSelectionListener.selectionChanged(textArea, n, n2);
            }
        }
    }

    private static class TextAreaCharacterListenerList
    extends ListenerList<TextAreaCharacterListener>
    implements TextAreaCharacterListener {
        private TextAreaCharacterListenerList() {
        }

        @Override
        public void charactersInserted(TextArea textArea, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaCharacterListener textAreaCharacterListener = (TextAreaCharacterListener)iterator.next();
                textAreaCharacterListener.charactersInserted(textArea, n, n2);
            }
        }

        @Override
        public void charactersRemoved(TextArea textArea, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaCharacterListener textAreaCharacterListener = (TextAreaCharacterListener)iterator.next();
                textAreaCharacterListener.charactersRemoved(textArea, n, n2);
            }
        }
    }

    private static class TextAreaListenerList
    extends ListenerList<TextAreaListener>
    implements TextAreaListener {
        private TextAreaListenerList() {
        }

        @Override
        public void documentChanged(TextArea textArea, Document document) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaListener textAreaListener = (TextAreaListener)iterator.next();
                textAreaListener.documentChanged(textArea, document);
            }
        }

        @Override
        public void editableChanged(TextArea textArea) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaListener textAreaListener = (TextAreaListener)iterator.next();
                textAreaListener.editableChanged(textArea);
            }
        }

        @Override
        public void textKeyChanged(TextArea textArea, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextAreaListener textAreaListener = (TextAreaListener)iterator.next();
                textAreaListener.textKeyChanged(textArea, string);
            }
        }
    }

    public static interface Skin {
        public int getInsertionPoint(int var1, int var2);

        public int getNextInsertionPoint(int var1, int var2, Direction var3);

        public int getRowIndex(int var1);

        public int getRowCount();

        public Bounds getCharacterBounds(int var1);
    }
}

