/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextInputCharacterListener;
import org.apache.pivot.wtk.TextInputListener;
import org.apache.pivot.wtk.TextInputSelectionListener;
import org.apache.pivot.wtk.TextInputTextListener;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;
import org.apache.pivot.wtk.text.TextNode;
import org.apache.pivot.wtk.text.validation.Validator;

public class TextInput
extends Component {
    private TextNode textNode;
    private int selectionStart = 0;
    private int selectionLength = 0;
    private int textSize = 16;
    private int maximumLength = Integer.MAX_VALUE;
    private boolean password = false;
    private String prompt = null;
    private String textKey = null;
    private Validator validator = null;
    private boolean textValid = true;
    private NodeListener textNodeListener = new NodeListener(){

        @Override
        public void parentChanged(Node node, Element element) {
        }

        @Override
        public void offsetChanged(Node node, int n) {
        }

        @Override
        public void rangeInserted(Node node, int n, int n2) {
            if (TextInput.this.selectionStart + TextInput.this.selectionLength > n) {
                if (TextInput.this.selectionStart > n) {
                    TextInput.this.selectionStart += n2;
                } else {
                    TextInput.this.selectionLength += n2;
                }
            }
            TextInput.this.textInputCharacterListeners.charactersInserted(TextInput.this, n, n2);
            TextInput.this.textInputTextListeners.textChanged(TextInput.this);
            TextInput.this.validateText();
        }

        @Override
        public void rangeRemoved(Node node, int n, int n2) {
            if (TextInput.this.selectionStart + TextInput.this.selectionLength > n) {
                if (TextInput.this.selectionStart > n) {
                    TextInput.this.selectionStart -= n2;
                } else {
                    TextInput.this.selectionLength -= n2;
                }
            }
            TextInput.this.textInputCharacterListeners.charactersRemoved(TextInput.this, n, n2);
            TextInput.this.textInputTextListeners.textChanged(TextInput.this);
            TextInput.this.validateText();
        }
    };
    private TextInputListenerList textInputListeners = new TextInputListenerList();
    private TextInputTextListenerList textInputTextListeners = new TextInputTextListenerList();
    private TextInputCharacterListenerList textInputCharacterListeners = new TextInputCharacterListenerList();
    private TextInputSelectionListenerList textInputSelectionListeners = new TextInputSelectionListenerList();
    public static final int DEFAULT_TEXT_SIZE = 16;

    public TextInput() {
        this.installThemeSkin(TextInput.class);
        this.setText("");
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public TextNode getTextNode() {
        return this.textNode;
    }

    public void setTextNode(TextNode textNode) {
        if (textNode != null && textNode.getCharacterCount() > this.maximumLength) {
            throw new IllegalArgumentException("Text length is greater than maximum length.");
        }
        TextNode textNode2 = this.textNode;
        if (textNode2 != textNode) {
            if (textNode2 != null) {
                textNode2.getNodeListeners().remove((Object)this.textNodeListener);
            }
            if (textNode != null) {
                textNode.getNodeListeners().add((Object)this.textNodeListener);
            }
            this.textNode = textNode;
            this.selectionStart = 0;
            this.selectionLength = 0;
            this.textInputListeners.textNodeChanged(this, textNode2);
            this.textInputTextListeners.textChanged(this);
            this.validateText();
        }
    }

    public String getText() {
        return this.textNode == null ? null : this.textNode.getText();
    }

    public void setText(String string) {
        this.setTextNode(string == null ? null : new TextNode(string));
    }

    public void insertText(char c, int n) {
        this.insertText(Character.toString(c), n);
    }

    public void insertText(String string, int n) {
        if (this.textNode == null) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new IllegalArgumentException("text is null.");
        }
        if (n < 0 || n > this.textNode.getCharacterCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.selectionLength > 0) {
            this.textNode.removeRange(this.selectionStart, this.selectionLength);
        }
        if (this.textNode.getCharacterCount() + string.length() > this.maximumLength) {
            throw new IllegalArgumentException("Insertion of text would exceed maximum length.");
        }
        int n2 = this.textNode.getCharacterCount();
        this.textNode.insertText(string, n);
        if (n2 + string.length() == this.textNode.getCharacterCount()) {
            this.setSelection(n + string.length(), 0);
        }
    }

    public int getTextLength() {
        return this.textNode == null ? -1 : this.textNode.getCharacterCount();
    }

    public void delete(Direction direction) {
        if (this.textNode == null) {
            throw new IllegalStateException();
        }
        if (direction == null) {
            throw new IllegalArgumentException("direction is null.");
        }
        if (this.selectionLength > 0) {
            this.textNode.removeRange(this.selectionStart, this.selectionLength);
        } else {
            int n = this.selectionStart;
            if (direction == Direction.BACKWARD) {
                --n;
            }
            if (n >= 0 && n < this.textNode.getCharacterCount()) {
                this.textNode.removeRange(n, 1);
            }
        }
    }

    public void cut() {
        if (this.textNode == null) {
            throw new IllegalStateException();
        }
        if (this.selectionLength > 0) {
            TextNode textNode = (TextNode)this.textNode.removeRange(this.selectionStart, this.selectionLength);
            LocalManifest localManifest = new LocalManifest();
            localManifest.putText(textNode.getText());
            Clipboard.setContent(localManifest);
        }
    }

    public void copy() {
        if (this.textNode == null) {
            throw new IllegalStateException();
        }
        String string = this.getSelectedText();
        if (string != null) {
            LocalManifest localManifest = new LocalManifest();
            localManifest.putText(string);
            Clipboard.setContent(localManifest);
        }
    }

    public void paste() {
        if (this.textNode == null) {
            throw new IllegalStateException();
        }
        Manifest manifest = Clipboard.getContent();
        if (manifest != null && manifest.containsText()) {
            String string = null;
            try {
                string = manifest.getText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string != null) {
                if (string.length() + this.textNode.getCharacterCount() > this.maximumLength) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    if (this.selectionLength > 0) {
                        this.textNode.removeRange(this.selectionStart, this.selectionLength);
                    }
                    this.insertText(string, this.selectionStart);
                }
            }
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public Span getSelection() {
        return this.selectionLength == 0 ? null : new Span(this.selectionStart, this.selectionStart + this.selectionLength - 1);
    }

    public void setSelection(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("selectionLength is negative.");
        }
        if (n < 0 || n + n2 > this.textNode.getCharacterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.selectionStart;
        int n4 = this.selectionLength;
        if (n3 != n || n4 != n2) {
            this.selectionStart = n;
            this.selectionLength = n2;
            this.textInputSelectionListeners.selectionChanged(this, n3, n4);
        }
    }

    public final void setSelection(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("selection is null.");
        }
        this.setSelection(Math.min(span.start, span.end), (int)span.getLength());
    }

    public void selectAll() {
        this.setSelection(0, this.textNode.getCharacterCount());
    }

    public void clearSelection() {
        this.setSelection(0, 0);
    }

    public String getSelectedText() {
        String string = null;
        if (this.selectionLength > 0) {
            TextNode textNode = (TextNode)this.textNode.getRange(this.selectionStart, this.selectionStart + this.selectionLength);
            string = textNode.getText();
        }
        return string;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("textSize is negative.");
        }
        int n2 = this.textSize;
        if (n2 != n) {
            this.textSize = n;
            this.textInputListeners.textSizeChanged(this, n2);
        }
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumLength is negative.");
        }
        int n2 = this.maximumLength;
        if (n2 != n) {
            int n3;
            if (this.textNode != null && (n3 = this.textNode.getCharacterCount()) > n) {
                this.textNode.removeText(n, n3 - n);
            }
            this.maximumLength = n;
            this.textInputListeners.maximumLengthChanged(this, n2);
        }
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean bl) {
        if (this.password != bl) {
            this.password = bl;
            this.textInputListeners.passwordChanged(this);
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String string) {
        String string2 = this.prompt;
        if (string2 != string) {
            this.prompt = string;
            this.textInputListeners.promptChanged(this, string2);
        }
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String string) {
        String string2 = this.textKey;
        if (string2 != string) {
            this.textKey = string;
            this.textInputListeners.textKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.textKey != null && JSONSerializer.containsKey(dictionary, (String)this.textKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.textKey);
            if (object != null) {
                object = object.toString();
            }
            this.setText((String)object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.textKey != null) {
            JSONSerializer.put(dictionary, (String)this.textKey, (Object)this.getText());
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText("");
        }
    }

    public int getInsertionPoint(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getInsertionPoint(n);
    }

    public Bounds getCharacterBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getCharacterBounds(n);
    }

    public boolean isTextValid() {
        return this.textValid;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        Validator validator2 = this.validator;
        if (validator != validator2) {
            this.validator = validator;
            this.textInputListeners.textValidatorChanged(this, validator2);
            this.validateText();
        }
    }

    private void validateText() {
        boolean bl;
        String string = this.getText();
        boolean bl2 = bl = this.validator == null || string == null ? true : this.validator.isValid(string);
        if (bl != this.textValid) {
            this.textValid = bl;
            this.textInputListeners.textValidChanged(this);
        }
    }

    public ListenerList<TextInputListener> getTextInputListeners() {
        return this.textInputListeners;
    }

    public ListenerList<TextInputTextListener> getTextInputTextListeners() {
        return this.textInputTextListeners;
    }

    public ListenerList<TextInputCharacterListener> getTextInputCharacterListeners() {
        return this.textInputCharacterListeners;
    }

    public ListenerList<TextInputSelectionListener> getTextInputSelectionListeners() {
        return this.textInputSelectionListeners;
    }

    private static class TextInputSelectionListenerList
    extends ListenerList<TextInputSelectionListener>
    implements TextInputSelectionListener {
        private TextInputSelectionListenerList() {
        }

        @Override
        public void selectionChanged(TextInput textInput, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputSelectionListener textInputSelectionListener = (TextInputSelectionListener)iterator.next();
                textInputSelectionListener.selectionChanged(textInput, n, n2);
            }
        }
    }

    private static class TextInputCharacterListenerList
    extends ListenerList<TextInputCharacterListener>
    implements TextInputCharacterListener {
        private TextInputCharacterListenerList() {
        }

        @Override
        public void charactersInserted(TextInput textInput, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputCharacterListener textInputCharacterListener = (TextInputCharacterListener)iterator.next();
                textInputCharacterListener.charactersInserted(textInput, n, n2);
            }
        }

        @Override
        public void charactersRemoved(TextInput textInput, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputCharacterListener textInputCharacterListener = (TextInputCharacterListener)iterator.next();
                textInputCharacterListener.charactersRemoved(textInput, n, n2);
            }
        }
    }

    private static class TextInputTextListenerList
    extends ListenerList<TextInputTextListener>
    implements TextInputTextListener {
        private TextInputTextListenerList() {
        }

        @Override
        public void textChanged(TextInput textInput) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputTextListener textInputTextListener = (TextInputTextListener)iterator.next();
                textInputTextListener.textChanged(textInput);
            }
        }
    }

    private static class TextInputListenerList
    extends ListenerList<TextInputListener>
    implements TextInputListener {
        private TextInputListenerList() {
        }

        @Override
        public void textNodeChanged(TextInput textInput, TextNode textNode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.textNodeChanged(textInput, textNode);
            }
        }

        @Override
        public void textSizeChanged(TextInput textInput, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.textSizeChanged(textInput, n);
            }
        }

        @Override
        public void maximumLengthChanged(TextInput textInput, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.maximumLengthChanged(textInput, n);
            }
        }

        @Override
        public void passwordChanged(TextInput textInput) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.passwordChanged(textInput);
            }
        }

        @Override
        public void promptChanged(TextInput textInput, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.promptChanged(textInput, string);
            }
        }

        @Override
        public void textKeyChanged(TextInput textInput, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.textKeyChanged(textInput, string);
            }
        }

        @Override
        public void textValidChanged(TextInput textInput) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.textValidChanged(textInput);
            }
        }

        @Override
        public void textValidatorChanged(TextInput textInput, Validator validator) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TextInputListener textInputListener = (TextInputListener)iterator.next();
                textInputListener.textValidatorChanged(textInput, validator);
            }
        }
    }

    public static interface Skin {
        public int getInsertionPoint(int var1);

        public Bounds getCharacterBounds(int var1);
    }
}

