/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Font;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.Service;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.FlowPane;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.MovieView;
import org.apache.pivot.wtk.Panel;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.StackPane;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.ThemeNotFoundException;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.BorderSkin;
import org.apache.pivot.wtk.skin.BoxPaneSkin;
import org.apache.pivot.wtk.skin.CardPaneSkin;
import org.apache.pivot.wtk.skin.ColorChooserButtonSkin;
import org.apache.pivot.wtk.skin.FlowPaneSkin;
import org.apache.pivot.wtk.skin.GridPaneFillerSkin;
import org.apache.pivot.wtk.skin.GridPaneSkin;
import org.apache.pivot.wtk.skin.ImageViewSkin;
import org.apache.pivot.wtk.skin.LabelSkin;
import org.apache.pivot.wtk.skin.MovieViewSkin;
import org.apache.pivot.wtk.skin.PanelSkin;
import org.apache.pivot.wtk.skin.ScrollPaneSkin;
import org.apache.pivot.wtk.skin.SeparatorSkin;
import org.apache.pivot.wtk.skin.StackPaneSkin;
import org.apache.pivot.wtk.skin.TablePaneFillerSkin;
import org.apache.pivot.wtk.skin.TablePaneSkin;
import org.apache.pivot.wtk.skin.TextAreaSkin;
import org.apache.pivot.wtk.skin.WindowSkin;

public abstract class Theme {
    protected HashMap<Class<? extends Component>, Class<? extends Skin>> componentSkinMap = new HashMap();
    private static Theme theme = null;
    public static final String NAME_KEY = "name";
    public static final String SIZE_KEY = "size";
    public static final String BOLD_KEY = "bold";
    public static final String ITALIC_KEY = "italic";
    public static final String PROVIDER_NAME = "org.apache.pivot.wtk.Theme";

    public Theme() {
        this.componentSkinMap.put(Border.class, BorderSkin.class);
        this.componentSkinMap.put(BoxPane.class, BoxPaneSkin.class);
        this.componentSkinMap.put(CardPane.class, CardPaneSkin.class);
        this.componentSkinMap.put(ColorChooserButtonSkin.ColorChooserPopup.class, ColorChooserButtonSkin.ColorChooserPopupSkin.class);
        this.componentSkinMap.put(FlowPane.class, FlowPaneSkin.class);
        this.componentSkinMap.put(GridPane.class, GridPaneSkin.class);
        this.componentSkinMap.put(GridPane.Filler.class, GridPaneFillerSkin.class);
        this.componentSkinMap.put(ImageView.class, ImageViewSkin.class);
        this.componentSkinMap.put(Label.class, LabelSkin.class);
        this.componentSkinMap.put(MovieView.class, MovieViewSkin.class);
        this.componentSkinMap.put(Panel.class, PanelSkin.class);
        this.componentSkinMap.put(ScrollPane.class, ScrollPaneSkin.class);
        this.componentSkinMap.put(Separator.class, SeparatorSkin.class);
        this.componentSkinMap.put(StackPane.class, StackPaneSkin.class);
        this.componentSkinMap.put(TablePane.class, TablePaneSkin.class);
        this.componentSkinMap.put(TablePane.Filler.class, TablePaneFillerSkin.class);
        this.componentSkinMap.put(TextArea.class, TextAreaSkin.class);
        this.componentSkinMap.put(Window.class, WindowSkin.class);
    }

    public final Class<? extends Skin> getSkinClass(Class<? extends Component> clazz) {
        return (Class)this.componentSkinMap.get(clazz);
    }

    public abstract Font getFont();

    public abstract void setFont(Font var1);

    public abstract Image getMessageIcon(MessageType var1);

    public abstract Image getSmallMessageIcon(MessageType var1);

    public Class<? extends Skin> get(Class<? extends Component> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Component class is null.");
        }
        return (Class)this.componentSkinMap.get(clazz);
    }

    public void set(Class<? extends Component> clazz, Class<? extends Skin> clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Component class is null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Skin class is null.");
        }
        this.componentSkinMap.put(clazz, clazz2);
    }

    public static Theme getTheme() {
        if (theme == null) {
            throw new IllegalStateException("No installed theme.");
        }
        return theme;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Font deriveFont(Dictionary<String, ?> dictionary) {
        int n;
        Font font = theme.getFont();
        if (dictionary.containsKey((Object)SIZE_KEY)) {
            Object object = dictionary.get((Object)SIZE_KEY);
            if (object instanceof String) {
                String string = (String)object;
                if (!string.endsWith("%")) throw new IllegalArgumentException(object + " is not a valid font size.");
                float f = Float.parseFloat(string.substring(0, string.length() - 1)) / 100.0f;
                n = Math.round((float)font.getSize() * f);
            } else {
                n = (Integer)object;
            }
        } else {
            n = font.getSize();
        }
        int n2 = font.getStyle();
        if (dictionary.containsKey((Object)BOLD_KEY)) {
            boolean bl = (Boolean)dictionary.get((Object)BOLD_KEY);
            n2 = bl ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
        }
        if (!dictionary.containsKey((Object)ITALIC_KEY)) return font.deriveFont(n2, n);
        boolean bl = (Boolean)dictionary.get((Object)ITALIC_KEY);
        n2 = bl ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
        return font.deriveFont(n2, n);
    }

    static {
        theme = (Theme)Service.getProvider((String)PROVIDER_NAME);
        if (theme == null) {
            throw new ThemeNotFoundException();
        }
    }
}

