/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Editor;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.TreeViewBranchListener;
import org.apache.pivot.wtk.TreeViewListener;
import org.apache.pivot.wtk.TreeViewNodeListener;
import org.apache.pivot.wtk.TreeViewNodeStateListener;
import org.apache.pivot.wtk.TreeViewSelectionListener;
import org.apache.pivot.wtk.content.TreeViewNodeRenderer;

public class TreeView
extends Component {
    private List<?> treeData = null;
    private ArrayList<Sequence.Tree.Path> expandedPaths = new ArrayList(PATH_COMPARATOR);
    private ArrayList<Sequence.Tree.Path> selectedPaths = new ArrayList(PATH_COMPARATOR);
    private ArrayList<Sequence.Tree.Path> checkedPaths = new ArrayList(PATH_COMPARATOR);
    private SelectMode selectMode = SelectMode.SINGLE;
    private boolean checkmarksEnabled = false;
    private boolean showMixedCheckmarkState = false;
    private Filter<?> disabledNodeFilter = null;
    private Filter<?> disabledCheckmarkFilter = null;
    private BranchHandler rootBranchHandler;
    private NodeRenderer nodeRenderer = DEFAULT_NODE_RENDERER;
    private NodeEditor nodeEditor = null;
    private TreeViewListenerList treeViewListeners = new TreeViewListenerList();
    private TreeViewBranchListenerList treeViewBranchListeners = new TreeViewBranchListenerList();
    private TreeViewNodeListenerList treeViewNodeListeners = new TreeViewNodeListenerList();
    private TreeViewNodeStateListenerList treeViewNodeStateListeners = new TreeViewNodeStateListenerList();
    private TreeViewSelectionListenerList treeViewSelectionListeners = new TreeViewSelectionListenerList();
    private static final NodeRenderer DEFAULT_NODE_RENDERER = new TreeViewNodeRenderer();
    private static final Comparator<Sequence.Tree.Path> PATH_COMPARATOR = new PathComparator();

    public TreeView() {
        this((List<?>)new ArrayList());
    }

    public TreeView(List<?> list) {
        this.setTreeData(list);
        this.installThemeSkin(TreeView.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public List<?> getTreeData() {
        return this.treeData;
    }

    public void setTreeData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("treeData is null.");
        }
        List<?> list2 = this.treeData;
        if (list2 != list) {
            if (list2 != null) {
                this.expandedPaths.clear();
                this.selectedPaths.clear();
                this.checkedPaths.clear();
                this.rootBranchHandler.release();
            }
            this.rootBranchHandler = new BranchHandler(null, list);
            this.treeData = list;
            this.treeViewListeners.treeDataChanged(this, list2);
        }
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        if (nodeRenderer == null) {
            throw new IllegalArgumentException("nodeRenderer is null.");
        }
        NodeRenderer nodeRenderer2 = this.nodeRenderer;
        if (nodeRenderer2 != nodeRenderer) {
            this.nodeRenderer = nodeRenderer;
            this.treeViewListeners.nodeRendererChanged(this, nodeRenderer2);
        }
    }

    public NodeEditor getNodeEditor() {
        return this.nodeEditor;
    }

    public void setNodeEditor(NodeEditor nodeEditor) {
        NodeEditor nodeEditor2 = this.nodeEditor;
        if (nodeEditor2 != nodeEditor) {
            this.nodeEditor = nodeEditor;
            this.treeViewListeners.nodeEditorChanged(this, nodeEditor2);
        }
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null");
        }
        SelectMode selectMode2 = this.selectMode;
        if (selectMode != selectMode2) {
            this.selectedPaths.clear();
            this.selectMode = selectMode;
            this.treeViewListeners.selectModeChanged(this, selectMode2);
        }
    }

    public final void setSelectMode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        this.setSelectMode(SelectMode.valueOf(string.toUpperCase()));
    }

    public Sequence<Sequence.Tree.Path> getSelectedPaths() {
        return new ImmutableList(this.selectedPaths);
    }

    public Sequence<Sequence.Tree.Path> setSelectedPaths(Sequence<Sequence.Tree.Path> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("selectedPaths is null.");
        }
        if (this.selectMode == SelectMode.NONE) {
            throw new IllegalStateException("Selection is not enabled.");
        }
        if (this.selectMode == SelectMode.SINGLE && sequence.getLength() > 1) {
            throw new IllegalArgumentException("Selection length is greater than 1.");
        }
        ArrayList<Sequence.Tree.Path> arrayList = this.selectedPaths;
        if (sequence != arrayList) {
            this.selectedPaths = new ArrayList(PATH_COMPARATOR);
            int n = sequence.getLength();
            for (int i = 0; i < n; ++i) {
                Sequence.Tree.Path path = (Sequence.Tree.Path)sequence.get(i);
                this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
                this.selectedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            }
            this.treeViewSelectionListeners.selectedPathsChanged(this, (Sequence<Sequence.Tree.Path>)arrayList);
        }
        return this.getSelectedPaths();
    }

    public Sequence.Tree.Path getFirstSelectedPath() {
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(0) : null;
    }

    public Sequence.Tree.Path getLastSelectedPath() {
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(this.selectedPaths.getLength() - 1) : null;
    }

    public Sequence.Tree.Path getSelectedPath() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("Tree view is not in single-select mode.");
        }
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(0) : null;
    }

    public void setSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        this.setSelectedPaths((Sequence<Sequence.Tree.Path>)new ArrayList((Object[])new Sequence.Tree.Path[]{path}));
    }

    public Object getSelectedNode() {
        Sequence.Tree.Path path = this.getSelectedPath();
        Object object = null;
        if (path != null) {
            object = Sequence.Tree.get(this.treeData, (Sequence.Tree.Path)path);
        }
        return object;
    }

    public boolean addSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Tree view is not in multi-select mode.");
        }
        int n = this.selectedPaths.indexOf((Object)path);
        if (n < 0) {
            this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
            this.selectedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            this.treeViewSelectionListeners.selectedPathAdded(this, path);
        }
        return n < 0;
    }

    public boolean removeSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Tree view is not in multi-select mode.");
        }
        int n = this.selectedPaths.indexOf((Object)path);
        if (n >= 0) {
            this.selectedPaths.remove(n, 1);
            this.treeViewSelectionListeners.selectedPathRemoved(this, path);
        }
        return n >= 0;
    }

    public void clearSelection() {
        if (this.selectedPaths.getLength() > 0) {
            ArrayList<Sequence.Tree.Path> arrayList = this.selectedPaths;
            this.selectedPaths = new ArrayList(PATH_COMPARATOR);
            this.treeViewSelectionListeners.selectedPathsChanged(this, (Sequence<Sequence.Tree.Path>)arrayList);
        }
    }

    public boolean isNodeSelected(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.selectedPaths.indexOf((Object)path) >= 0;
    }

    public boolean isNodeDisabled(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        boolean bl = false;
        if (this.disabledNodeFilter != null) {
            Object object = Sequence.Tree.get(this.treeData, (Sequence.Tree.Path)path);
            bl = this.disabledNodeFilter.include(object);
        }
        return bl;
    }

    public Filter<?> getDisabledNodeFilter() {
        return this.disabledNodeFilter;
    }

    public void setDisabledNodeFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledNodeFilter;
        if (filter2 != filter) {
            this.disabledNodeFilter = filter;
            this.treeViewListeners.disabledNodeFilterChanged(this, filter2);
        }
    }

    public boolean getCheckmarksEnabled() {
        return this.checkmarksEnabled;
    }

    public void setCheckmarksEnabled(boolean bl) {
        if (this.checkmarksEnabled != bl) {
            this.checkedPaths.clear();
            this.checkmarksEnabled = bl;
            this.treeViewListeners.checkmarksEnabledChanged(this);
        }
    }

    public boolean getShowMixedCheckmarkState() {
        return this.showMixedCheckmarkState;
    }

    public void setShowMixedCheckmarkState(boolean bl) {
        if (this.showMixedCheckmarkState != bl) {
            this.showMixedCheckmarkState = bl;
            this.treeViewListeners.showMixedCheckmarkStateChanged(this);
        }
    }

    public boolean isNodeChecked(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.checkedPaths.indexOf((Object)path) >= 0;
    }

    public NodeCheckState getNodeCheckState(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        NodeCheckState nodeCheckState = NodeCheckState.UNCHECKED;
        if (this.checkmarksEnabled) {
            Sequence.Tree.Path path2;
            int n = ArrayList.binarySearch(this.checkedPaths, (Object)path, PATH_COMPARATOR);
            if (n >= 0) {
                nodeCheckState = NodeCheckState.CHECKED;
            } else if (this.showMixedCheckmarkState && (n = -(n + 1)) < this.checkedPaths.getLength() && Sequence.Tree.isDescendant((Sequence.Tree.Path)path, (Sequence.Tree.Path)(path2 = (Sequence.Tree.Path)this.checkedPaths.get(n)))) {
                nodeCheckState = NodeCheckState.MIXED;
            }
        }
        return nodeCheckState;
    }

    public void setNodeChecked(Sequence.Tree.Path path, boolean bl) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (!this.checkmarksEnabled) {
            throw new IllegalStateException("Checkmarks are not enabled.");
        }
        int n = this.checkedPaths.indexOf((Object)path);
        if (n < 0 && bl || n >= 0 && !bl) {
            int n2;
            Sequence.Tree.Path path2;
            NodeCheckState nodeCheckState = this.getNodeCheckState(path);
            ArrayList arrayList = null;
            if (this.showMixedCheckmarkState) {
                arrayList = new ArrayList(path.getLength() - 1);
                path2 = new Sequence.Tree.Path(path, path.getLength() - 1);
                for (n2 = path2.getLength() - 1; n2 >= 0; --n2) {
                    arrayList.insert((Object)this.getNodeCheckState(path2), 0);
                    path2.remove(n2, 1);
                }
            }
            if (bl) {
                this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
                this.checkedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            } else {
                this.checkedPaths.remove(n, 1);
            }
            this.treeViewNodeStateListeners.nodeCheckStateChanged(this, path, nodeCheckState);
            if (this.showMixedCheckmarkState) {
                path2 = new Sequence.Tree.Path(path, path.getLength() - 1);
                for (n2 = path2.getLength() - 1; n2 >= 0; --n2) {
                    NodeCheckState nodeCheckState2 = (NodeCheckState)((Object)arrayList.get(n2));
                    NodeCheckState nodeCheckState3 = this.getNodeCheckState(path2);
                    if (nodeCheckState3 != nodeCheckState2) {
                        this.treeViewNodeStateListeners.nodeCheckStateChanged(this, path2, nodeCheckState2);
                    }
                    path2.remove(n2, 1);
                }
            }
        }
    }

    public Sequence<Sequence.Tree.Path> getCheckedPaths() {
        return new ImmutableList(this.checkedPaths);
    }

    public Filter<?> getDisabledCheckmarkFilter() {
        return this.disabledCheckmarkFilter;
    }

    public void setDisabledCheckmarkFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledCheckmarkFilter;
        if (filter2 != filter) {
            this.disabledCheckmarkFilter = filter;
            this.treeViewListeners.disabledCheckmarkFilterChanged(this, filter2);
        }
    }

    public void setBranchExpanded(Sequence.Tree.Path path, boolean bl) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        int n = this.expandedPaths.indexOf((Object)path);
        if (bl && n < 0) {
            this.monitorBranch(path);
            this.expandedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            this.treeViewBranchListeners.branchExpanded(this, path);
        } else if (!bl && n >= 0) {
            this.expandedPaths.remove(n, 1);
            this.treeViewBranchListeners.branchCollapsed(this, path);
        }
    }

    public boolean isBranchExpanded(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.expandedPaths.indexOf((Object)path) >= 0;
    }

    public final void expandBranch(Sequence.Tree.Path path) {
        this.setBranchExpanded(path, true);
    }

    public final void expandAll() {
        Sequence.Tree.ItemIterator itemIterator = Sequence.Tree.depthFirstIterator(this.treeData);
        while (itemIterator.hasNext()) {
            Sequence.Tree.Path path;
            Object object = itemIterator.next();
            if (!(object instanceof List) || (path = itemIterator.getPath()).getLength() <= 0) continue;
            this.expandBranch(path);
        }
    }

    public final void collapseBranch(Sequence.Tree.Path path) {
        this.setBranchExpanded(path, false);
    }

    public final void collapseAll() {
        Sequence.Tree.ItemIterator itemIterator = Sequence.Tree.depthFirstIterator(this.treeData);
        while (itemIterator.hasNext()) {
            Sequence.Tree.Path path;
            Object object = itemIterator.next();
            if (!(object instanceof List) || (path = itemIterator.getPath()).getLength() <= 0) continue;
            this.collapseBranch(path);
        }
    }

    private void monitorBranch(Sequence.Tree.Path path) {
        BranchHandler branchHandler = this.rootBranchHandler;
        int n = path.getLength();
        for (int i = 0; i < n; ++i) {
            int n2 = path.get(i);
            if (n2 < 0 || n2 >= branchHandler.getLength()) {
                throw new IndexOutOfBoundsException("Branch path out of bounds: " + path);
            }
            BranchHandler branchHandler2 = (BranchHandler)((Object)branchHandler.get(n2));
            if (branchHandler2 == null) {
                List<?> list = branchHandler.getBranchData();
                Object object = list.get(n2);
                if (!(object instanceof List)) {
                    throw new IllegalArgumentException("Unexpected leaf in branch path: " + path);
                }
                branchHandler2 = new BranchHandler(branchHandler, (List)object);
                branchHandler.update(n2, (Object)branchHandler2);
            }
            branchHandler = branchHandler2;
        }
    }

    public Sequence.Tree.Path getNodeAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getNodeAt(n);
    }

    public Bounds getNodeBounds(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getNodeBounds(path);
    }

    public int getNodeIndent(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getNodeIndent(n);
    }

    public int getRowIndex(Sequence.Tree.Path path) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowIndex(path);
    }

    public ListenerList<TreeViewListener> getTreeViewListeners() {
        return this.treeViewListeners;
    }

    public ListenerList<TreeViewBranchListener> getTreeViewBranchListeners() {
        return this.treeViewBranchListeners;
    }

    public ListenerList<TreeViewNodeListener> getTreeViewNodeListeners() {
        return this.treeViewNodeListeners;
    }

    public ListenerList<TreeViewNodeStateListener> getTreeViewNodeStateListeners() {
        return this.treeViewNodeStateListeners;
    }

    public ListenerList<TreeViewSelectionListener> getTreeViewSelectionListeners() {
        return this.treeViewSelectionListeners;
    }

    private class BranchHandler
    extends ArrayList<BranchHandler>
    implements ListListener<Object> {
        private static final long serialVersionUID = -6132480635507615071L;
        private BranchHandler parent;
        private List<?> branchData;

        public BranchHandler(BranchHandler branchHandler, List<?> list) {
            super(list.getLength());
            this.parent = branchHandler;
            this.branchData = list;
            list.getListListeners().add((Object)this);
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                this.add(null);
            }
        }

        public List<?> getBranchData() {
            return this.branchData;
        }

        public void release() {
            this.branchData.getListListeners().remove((Object)this);
            int n = this.getLength();
            for (int i = 0; i < n; ++i) {
                BranchHandler branchHandler = (BranchHandler)((Object)this.get(i));
                if (branchHandler == null) continue;
                branchHandler.release();
            }
        }

        private Sequence.Tree.Path getPath() {
            Sequence.Tree.Path path = new Sequence.Tree.Path();
            BranchHandler branchHandler = this;
            while (branchHandler.parent != null) {
                int n = branchHandler.parent.branchData.indexOf(branchHandler.branchData);
                path.insert(Integer.valueOf(n), 0);
                branchHandler = branchHandler.parent;
            }
            return path;
        }

        public void itemInserted(List<Object> list, int n) {
            Sequence.Tree.Path path = this.getPath();
            this.insert(null, n);
            this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, n);
            this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, n);
            this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, n);
            TreeView.this.treeViewNodeListeners.nodeInserted(TreeView.this, path, n);
        }

        public void itemsRemoved(List<Object> list, int n, Sequence<Object> sequence) {
            Sequence.Tree.Path path = this.getPath();
            int n2 = sequence.getLength();
            Sequence sequence2 = this.remove(n, n2);
            int n3 = sequence2.getLength();
            for (int i = 0; i < n3; ++i) {
                BranchHandler branchHandler = (BranchHandler)((Object)sequence2.get(i));
                if (branchHandler == null) continue;
                branchHandler.release();
            }
            this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, n, n2);
            this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, n, n2);
            this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, n, n2);
            TreeView.this.treeViewNodeListeners.nodesRemoved(TreeView.this, path, n, n2);
        }

        public void itemUpdated(List<Object> list, int n, Object object) {
            Sequence.Tree.Path path = this.getPath();
            if (list.get(n) != object) {
                BranchHandler branchHandler = (BranchHandler)((Object)this.update(n, null));
                if (branchHandler != null) {
                    branchHandler.release();
                }
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, n);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, n);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, n);
            }
            TreeView.this.treeViewNodeListeners.nodeUpdated(TreeView.this, path, n);
        }

        public void listCleared(List<Object> list) {
            Sequence.Tree.Path path = this.getPath();
            int n = this.getLength();
            for (int i = 0; i < n; ++i) {
                BranchHandler branchHandler = (BranchHandler)((Object)this.get(i));
                if (branchHandler == null) continue;
                branchHandler.release();
            }
            this.clear();
            this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path);
            this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path);
            this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path);
            TreeView.this.treeViewNodeListeners.nodesCleared(TreeView.this, path);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> comparator) {
            if (list.getComparator() != null) {
                Sequence.Tree.Path path = this.getPath();
                int n = this.getLength();
                for (int i = 0; i < n; ++i) {
                    BranchHandler branchHandler = (BranchHandler)((Object)this.update(i, null));
                    if (branchHandler == null) continue;
                    branchHandler.release();
                }
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path);
                TreeView.this.treeViewNodeListeners.nodesSorted(TreeView.this, path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incrementPaths(ArrayList<Sequence.Tree.Path> arrayList, Sequence.Tree.Path path, int n) {
            Sequence.Tree.Path path2 = new Sequence.Tree.Path(path);
            path2.add(Integer.valueOf(n));
            int n2 = ArrayList.binarySearch(arrayList, (Object)path2, (Comparator)PATH_COMPARATOR);
            if (n2 < 0) {
                n2 = -(n2 + 1);
            }
            arrayList.setComparator(null);
            try {
                int n3 = path.getLength();
                int n4 = arrayList.getLength();
                while (n2 < n4) {
                    Integer[] integerArray;
                    Sequence.Tree.Path path3 = (Sequence.Tree.Path)arrayList.get(n2);
                    if (!Sequence.Tree.isDescendant((Sequence.Tree.Path)path, (Sequence.Tree.Path)path3)) {
                        break;
                    }
                    Integer[] integerArray2 = integerArray = path3.toArray();
                    int n5 = n3;
                    Integer n6 = integerArray2[n5];
                    Integer n7 = integerArray2[n5] = Integer.valueOf(integerArray2[n5] + 1);
                    arrayList.update(n2, (Object)new Sequence.Tree.ImmutablePath(integerArray));
                    ++n2;
                }
            }
            finally {
                arrayList.setComparator(PATH_COMPARATOR);
            }
        }

        private void clearAndDecrementPaths(ArrayList<Sequence.Tree.Path> arrayList, Sequence.Tree.Path path, int n, int n2) {
            Sequence.Tree.Path path2;
            int n3 = path.getLength();
            Sequence.Tree.Path path3 = new Sequence.Tree.Path(path);
            path3.add(Integer.valueOf(n));
            int n4 = ArrayList.binarySearch(arrayList, (Object)path3, (Comparator)PATH_COMPARATOR);
            if (n4 < 0) {
                n4 = -(n4 + 1);
            }
            path3.update(n3, Integer.valueOf(n + n2));
            int n5 = ArrayList.binarySearch(arrayList, (Object)path3, (Comparator)PATH_COMPARATOR);
            if (n5 < 0) {
                n5 = -(n5 + 1);
            }
            if (n5 > n4) {
                arrayList.remove(n4, n5 - n4);
            }
            int n6 = arrayList.getLength();
            for (int i = n4; i < n6 && Sequence.Tree.isDescendant((Sequence.Tree.Path)path, (Sequence.Tree.Path)(path2 = (Sequence.Tree.Path)arrayList.get(i))); ++i) {
                Integer[] integerArray;
                Integer[] integerArray2 = integerArray = path2.toArray();
                int n7 = n3;
                Integer.valueOf(integerArray2[n7] - n2);
                arrayList.update(i, (Object)new Sequence.Tree.ImmutablePath(integerArray));
            }
        }

        private void clearPaths(ArrayList<Sequence.Tree.Path> arrayList, Sequence.Tree.Path path, int n) {
            Sequence.Tree.Path path2;
            Sequence.Tree.Path path3 = new Sequence.Tree.Path(path);
            path3.add(Integer.valueOf(n));
            int n2 = ArrayList.binarySearch(arrayList, (Object)path3, (Comparator)PATH_COMPARATOR);
            if (n2 < 0) {
                n2 = -(n2 + 1);
            }
            int n3 = arrayList.getLength();
            for (int i = n2; i < n3 && Sequence.Tree.isDescendant((Sequence.Tree.Path)path3, (Sequence.Tree.Path)(path2 = (Sequence.Tree.Path)arrayList.get(n2))); ++i) {
                arrayList.remove(n2, 1);
            }
        }

        private void clearPaths(ArrayList<Sequence.Tree.Path> arrayList, Sequence.Tree.Path path) {
            int n;
            Sequence.Tree.Path path2;
            int n2 = arrayList.getLength();
            for (int i = n = (n = ArrayList.binarySearch(arrayList, (Object)path, (Comparator)PATH_COMPARATOR)) < 0 ? -(n + 1) : n + 1; i < n2 && Sequence.Tree.isDescendant((Sequence.Tree.Path)path, (Sequence.Tree.Path)(path2 = (Sequence.Tree.Path)arrayList.get(n))); ++i) {
                arrayList.remove(n, 1);
            }
        }
    }

    public static final class PathComparator
    implements Comparator<Sequence.Tree.Path> {
        @Override
        public int compare(Sequence.Tree.Path path, Sequence.Tree.Path path2) {
            int n = path.getLength();
            int n2 = path2.getLength();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = path.get(i);
                if (n5 == (n4 = path2.get(i).intValue())) continue;
                return n5 - n4;
            }
            return n - n2;
        }
    }

    private static class TreeViewSelectionListenerList
    extends ListenerList<TreeViewSelectionListener>
    implements TreeViewSelectionListener {
        private TreeViewSelectionListenerList() {
        }

        @Override
        public void selectedPathAdded(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewSelectionListener treeViewSelectionListener = (TreeViewSelectionListener)iterator.next();
                treeViewSelectionListener.selectedPathAdded(treeView, path);
            }
        }

        @Override
        public void selectedPathRemoved(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewSelectionListener treeViewSelectionListener = (TreeViewSelectionListener)iterator.next();
                treeViewSelectionListener.selectedPathRemoved(treeView, path);
            }
        }

        @Override
        public void selectedPathsChanged(TreeView treeView, Sequence<Sequence.Tree.Path> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewSelectionListener treeViewSelectionListener = (TreeViewSelectionListener)iterator.next();
                treeViewSelectionListener.selectedPathsChanged(treeView, sequence);
            }
        }
    }

    private static class TreeViewNodeStateListenerList
    extends ListenerList<TreeViewNodeStateListener>
    implements TreeViewNodeStateListener {
        private TreeViewNodeStateListenerList() {
        }

        @Override
        public void nodeCheckStateChanged(TreeView treeView, Sequence.Tree.Path path, NodeCheckState nodeCheckState) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeStateListener treeViewNodeStateListener = (TreeViewNodeStateListener)iterator.next();
                treeViewNodeStateListener.nodeCheckStateChanged(treeView, path, nodeCheckState);
            }
        }
    }

    private static class TreeViewNodeListenerList
    extends ListenerList<TreeViewNodeListener>
    implements TreeViewNodeListener {
        private TreeViewNodeListenerList() {
        }

        @Override
        public void nodeInserted(TreeView treeView, Sequence.Tree.Path path, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeListener treeViewNodeListener = (TreeViewNodeListener)iterator.next();
                treeViewNodeListener.nodeInserted(treeView, path, n);
            }
        }

        @Override
        public void nodesRemoved(TreeView treeView, Sequence.Tree.Path path, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeListener treeViewNodeListener = (TreeViewNodeListener)iterator.next();
                treeViewNodeListener.nodesRemoved(treeView, path, n, n2);
            }
        }

        @Override
        public void nodeUpdated(TreeView treeView, Sequence.Tree.Path path, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeListener treeViewNodeListener = (TreeViewNodeListener)iterator.next();
                treeViewNodeListener.nodeUpdated(treeView, path, n);
            }
        }

        @Override
        public void nodesCleared(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeListener treeViewNodeListener = (TreeViewNodeListener)iterator.next();
                treeViewNodeListener.nodesCleared(treeView, path);
            }
        }

        @Override
        public void nodesSorted(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewNodeListener treeViewNodeListener = (TreeViewNodeListener)iterator.next();
                treeViewNodeListener.nodesSorted(treeView, path);
            }
        }
    }

    private static class TreeViewBranchListenerList
    extends ListenerList<TreeViewBranchListener>
    implements TreeViewBranchListener {
        private TreeViewBranchListenerList() {
        }

        @Override
        public void branchExpanded(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewBranchListener treeViewBranchListener = (TreeViewBranchListener)iterator.next();
                treeViewBranchListener.branchExpanded(treeView, path);
            }
        }

        @Override
        public void branchCollapsed(TreeView treeView, Sequence.Tree.Path path) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewBranchListener treeViewBranchListener = (TreeViewBranchListener)iterator.next();
                treeViewBranchListener.branchCollapsed(treeView, path);
            }
        }
    }

    private static class TreeViewListenerList
    extends ListenerList<TreeViewListener>
    implements TreeViewListener {
        private TreeViewListenerList() {
        }

        @Override
        public void treeDataChanged(TreeView treeView, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.treeDataChanged(treeView, list);
            }
        }

        @Override
        public void nodeRendererChanged(TreeView treeView, NodeRenderer nodeRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.nodeRendererChanged(treeView, nodeRenderer);
            }
        }

        @Override
        public void nodeEditorChanged(TreeView treeView, NodeEditor nodeEditor) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.nodeEditorChanged(treeView, nodeEditor);
            }
        }

        @Override
        public void selectModeChanged(TreeView treeView, SelectMode selectMode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.selectModeChanged(treeView, selectMode);
            }
        }

        @Override
        public void checkmarksEnabledChanged(TreeView treeView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.checkmarksEnabledChanged(treeView);
            }
        }

        @Override
        public void showMixedCheckmarkStateChanged(TreeView treeView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.showMixedCheckmarkStateChanged(treeView);
            }
        }

        @Override
        public void disabledNodeFilterChanged(TreeView treeView, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.disabledNodeFilterChanged(treeView, filter);
            }
        }

        @Override
        public void disabledCheckmarkFilterChanged(TreeView treeView, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                TreeViewListener treeViewListener = (TreeViewListener)iterator.next();
                treeViewListener.disabledCheckmarkFilterChanged(treeView, filter);
            }
        }
    }

    public static interface Skin {
        public Sequence.Tree.Path getNodeAt(int var1);

        public Bounds getNodeBounds(Sequence.Tree.Path var1);

        public int getNodeIndent(int var1);

        public int getRowIndex(Sequence.Tree.Path var1);
    }

    public static interface NodeEditorListener {
        public Vote previewEditNode(NodeEditor var1, TreeView var2, Sequence.Tree.Path var3);

        public void editNodeVetoed(NodeEditor var1, Vote var2);

        public void nodeEditing(NodeEditor var1, TreeView var2, Sequence.Tree.Path var3);

        public Vote previewSaveChanges(NodeEditor var1, TreeView var2, Sequence.Tree.Path var3, Object var4);

        public void saveChangesVetoed(NodeEditor var1, Vote var2);

        public void changesSaved(NodeEditor var1, TreeView var2, Sequence.Tree.Path var3);

        public void editCancelled(NodeEditor var1, TreeView var2, Sequence.Tree.Path var3);

        public static class Adapter
        implements NodeEditorListener {
            @Override
            public Vote previewEditNode(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
                return Vote.APPROVE;
            }

            @Override
            public void editNodeVetoed(NodeEditor nodeEditor, Vote vote) {
            }

            @Override
            public void nodeEditing(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
            }

            @Override
            public Vote previewSaveChanges(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path, Object object) {
                return Vote.APPROVE;
            }

            @Override
            public void saveChangesVetoed(NodeEditor nodeEditor, Vote vote) {
            }

            @Override
            public void changesSaved(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
            }

            @Override
            public void editCancelled(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
            }
        }
    }

    public static interface NodeEditor
    extends Editor {
        public void editNode(TreeView var1, Sequence.Tree.Path var2);

        public ListenerList<NodeEditorListener> getNodeEditorListeners();

        public static class NodeEditorListenerList
        extends ListenerList<NodeEditorListener>
        implements NodeEditorListener {
            @Override
            public Vote previewEditNode(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    vote = vote.tally(nodeEditorListener.previewEditNode(nodeEditor, treeView, path));
                }
                return vote;
            }

            @Override
            public void editNodeVetoed(NodeEditor nodeEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    nodeEditorListener.editNodeVetoed(nodeEditor, vote);
                }
            }

            @Override
            public void nodeEditing(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    nodeEditorListener.nodeEditing(nodeEditor, treeView, path);
                }
            }

            @Override
            public Vote previewSaveChanges(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path, Object object) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    vote = vote.tally(nodeEditorListener.previewSaveChanges(nodeEditor, treeView, path, object));
                }
                return vote;
            }

            @Override
            public void saveChangesVetoed(NodeEditor nodeEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    nodeEditorListener.saveChangesVetoed(nodeEditor, vote);
                }
            }

            @Override
            public void changesSaved(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    nodeEditorListener.changesSaved(nodeEditor, treeView, path);
                }
            }

            @Override
            public void editCancelled(NodeEditor nodeEditor, TreeView treeView, Sequence.Tree.Path path) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    NodeEditorListener nodeEditorListener = (NodeEditorListener)iterator.next();
                    nodeEditorListener.editCancelled(nodeEditor, treeView, path);
                }
            }
        }
    }

    public static interface NodeRenderer
    extends Renderer {
        public void render(Object var1, Sequence.Tree.Path var2, int var3, TreeView var4, boolean var5, boolean var6, NodeCheckState var7, boolean var8, boolean var9);
    }

    public static enum NodeCheckState {
        CHECKED,
        UNCHECKED,
        MIXED;

    }

    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }
}

