/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.WindowActionMappingListener;
import org.apache.pivot.wtk.WindowClassListener;
import org.apache.pivot.wtk.WindowListener;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.media.Image;

public class Window
extends Container {
    private Window owner = null;
    private ArrayList<Window> ownedWindows = new ArrayList();
    private ArrayList<ActionMapping> actionMappings = new ArrayList();
    private ActionMappingSequence actionMappingSequence = new ActionMappingSequence();
    private HashMap<Keyboard.KeyStroke, Action> actionMap = new HashMap();
    private String title = null;
    private Image icon = null;
    private Component content = null;
    private Component focusDescendant = null;
    private boolean opening = false;
    private boolean closing = false;
    private Point restoreLocation = null;
    private WindowListenerList windowListeners = new WindowListenerList();
    private WindowStateListenerList windowStateListeners = new WindowStateListenerList();
    private WindowActionMappingListenerList windowActionMappingListeners = new WindowActionMappingListenerList();
    private static WindowClassListenerList windowClassListeners = new WindowClassListenerList();
    private static Window activeWindow = null;

    public Window() {
        this(null);
    }

    public Window(Component component) {
        this.setContent(component);
        this.installThemeSkin(Window.class);
    }

    @Override
    protected void setParent(Container container) {
        if (container != null && !(container instanceof Display)) {
            throw new IllegalArgumentException("Window parent must be null or display.");
        }
        if (container == null && this.isActive()) {
            Window.clearActive();
        }
        super.setParent(container);
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && this.owner != null && !this.owner.isVisible()) {
            throw new IllegalStateException("Owner is not visible.");
        }
        super.setVisible(bl);
        if (bl && this.isActive()) {
            Window.clearActive();
        }
        for (Window window : this.ownedWindows) {
            window.setVisible(bl);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.isActive()) {
            Window.clearActive();
        }
    }

    public Window getOwner() {
        return this.owner;
    }

    public Window getRootOwner() {
        return this.owner == null ? this : this.owner.getRootOwner();
    }

    public Window getOwnedWindow(int n) {
        return (Window)this.ownedWindows.get(n);
    }

    public int getOwnedWindowCount() {
        return this.ownedWindows.getLength();
    }

    public boolean isOwner(Window window) {
        Window window2;
        if (window == null) {
            throw new IllegalArgumentException("window is null.");
        }
        for (window2 = window.getOwner(); window2 != null && window2 != this; window2 = window2.getOwner()) {
        }
        return window2 == this;
    }

    public boolean isOpen() {
        return this.getParent() != null;
    }

    public boolean isOpening() {
        return this.opening;
    }

    public final void open(Display display) {
        this.open(display, null);
    }

    public final void open(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.open(window.getDisplay(), window);
    }

    public void open(Display display, Window window) {
        if (display == null) {
            throw new IllegalArgumentException("display is null.");
        }
        if (window != null) {
            if (!window.isOpen()) {
                throw new IllegalArgumentException("owner is not open.");
            }
            if (this.isOwner(window)) {
                throw new IllegalArgumentException("owner is an owned descendant of this window.");
            }
        }
        if (this.isOpen()) {
            if (this.getDisplay() != display) {
                throw new IllegalStateException("Window is already open on a different display.");
            }
            if (this.owner != window) {
                throw new IllegalStateException("Window is already open with a different owner.");
            }
        }
        if (!this.isOpen()) {
            this.opening = true;
            Vote vote = this.windowStateListeners.previewWindowOpen(this, display);
            if (vote == Vote.APPROVE) {
                this.owner = window;
                if (window != null) {
                    window.ownedWindows.add((Object)this);
                }
                display.add(this);
                this.opening = false;
                this.windowStateListeners.windowOpened(this);
                this.moveToFront();
            } else {
                if (vote == Vote.DENY) {
                    this.opening = false;
                }
                this.windowStateListeners.windowOpenVetoed(this, vote);
            }
        }
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closing = true;
            boolean bl = false;
            for (Container container : new ArrayList(this.ownedWindows)) {
                ((Window)container).close();
                bl |= !((Window)container).isClosing() && !((Window)container).isClosed();
            }
            if (bl) {
                this.closing = false;
            } else {
                Iterator iterator = this.windowStateListeners.previewWindowClose(this);
                if (iterator == Vote.APPROVE) {
                    Container container;
                    container = this.getDisplay();
                    container.remove(this);
                    Window window = this.owner;
                    this.owner = null;
                    if (window != null) {
                        window.ownedWindows.remove((Object)this);
                    }
                    this.closing = false;
                    this.windowStateListeners.windowClosed(this, (Display)container, window);
                } else {
                    if (iterator == Vote.DENY) {
                        this.closing = false;
                    }
                    this.windowStateListeners.windowCloseVetoed(this, (Vote)iterator);
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        if (string2 != string) {
            this.title = string;
            this.windowListeners.titleChanged(this, string2);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image image) {
        Image image2 = this.icon;
        if (image2 != image) {
            this.icon = image;
            this.windowListeners.iconChanged(this, image2);
        }
    }

    public void setIcon(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        this.setIcon(image);
    }

    public void setIcon(String string) {
        if (string == null) {
            throw new IllegalArgumentException("icon is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        this.setIcon(classLoader.getResource(string));
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component component) {
        Component component2 = this.content;
        if (component != component2) {
            this.content = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.insert(component, 0);
            }
            this.content = component;
            this.windowListeners.contentChanged(this, component2);
        }
    }

    public Bounds getClientArea() {
        Skin skin = (Skin)this.getSkin();
        return skin.getClientArea();
    }

    public boolean isActive() {
        return activeWindow == this;
    }

    public boolean requestActive() {
        if (this.isOpen() && this.isVisible() && this.isEnabled()) {
            Window.setActiveWindow(this);
        }
        return this.isActive();
    }

    protected void setActive(boolean bl, Window window) {
        this.windowListeners.activeChanged(this, window);
    }

    public static Window getActiveWindow() {
        return activeWindow;
    }

    private static void setActiveWindow(Window window) {
        Window window2 = activeWindow;
        if (window2 != window) {
            activeWindow = window;
            if (window2 != null) {
                window2.setActive(false, window);
            }
            if (window != null) {
                window.setActive(true, window2);
            }
            windowClassListeners.activeWindowChanged(window2);
        }
    }

    public static void clearActive() {
        Window.setActiveWindow(null);
    }

    public Component getFocusDescendant() {
        return this.focusDescendant;
    }

    public void clearFocusDescendant() {
        this.focusDescendant = null;
    }

    @Override
    protected void descendantGainedFocus(Component component, Component component2) {
        this.focusDescendant = component;
        super.descendantGainedFocus(component, component2);
    }

    @Override
    protected void descendantRemoved(Component component) {
        super.descendantRemoved(component);
        if (component == this.focusDescendant) {
            this.focusDescendant = null;
        }
    }

    public ActionMappingSequence getActionMappings() {
        return this.actionMappingSequence;
    }

    public void moveToFront() {
        int n;
        if (!this.isOpen()) {
            throw new IllegalStateException("Window is not open.");
        }
        Display display = this.getDisplay();
        int n2 = display.getLength() - 1;
        int n3 = display.indexOf(this);
        if (n3 < n2) {
            display.move(n3, n2);
        }
        if ((n = this.ownedWindows.getLength()) == 0) {
            if (this.isShowing() && this.isEnabled() && this.focusDescendant != null) {
                this.focusDescendant.requestFocus();
            }
        } else {
            Object object2;
            ArrayList arrayList = new ArrayList(n);
            for (Object object2 : this.ownedWindows) {
                if (!((Window)object2).isOpen()) continue;
                arrayList.add((Object)display.indexOf((Component)object2));
            }
            ArrayList.sort((ArrayList)arrayList);
            Iterator iterator = new ArrayList(this.ownedWindows.getLength());
            for (Object object3 : arrayList) {
                iterator.add((Window)display.get((Integer)object3));
            }
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                Object object3;
                object3 = (Window)object2.next();
                ((Window)object3).moveToFront();
            }
        }
    }

    public void moveToBack() {
        Display display;
        int n;
        if (!this.isOpen()) {
            throw new IllegalStateException("Window is not open.");
        }
        if (this.isActive()) {
            Window.clearActive();
        }
        if (this.containsFocus()) {
            Window.clearFocus();
        }
        if ((n = (display = this.getDisplay()).indexOf(this)) > 0) {
            display.move(n, 0);
        }
        if (this.owner != null) {
            this.owner.moveToBack();
        }
    }

    public boolean isMaximized() {
        return this.restoreLocation != null;
    }

    public void setMaximized(boolean bl) {
        if (bl != this.isMaximized()) {
            if (bl) {
                this.restoreLocation = this.getLocation();
                this.setLocation(0, 0);
            } else {
                this.setLocation(this.restoreLocation.x, this.restoreLocation.y);
                this.restoreLocation = null;
            }
            this.invalidate();
            this.windowListeners.maximizedChanged(this);
        }
    }

    public void align(Bounds bounds, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.align(bounds, horizontalAlignment, 0, verticalAlignment, 0);
    }

    public void align(Bounds bounds, HorizontalAlignment horizontalAlignment, int n, VerticalAlignment verticalAlignment, int n2) {
        int n3 = 0;
        int n4 = 0;
        Dimensions dimensions = this.getSize();
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            n3 = bounds.x - dimensions.width;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            n3 = bounds.x + bounds.width - dimensions.width;
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            n3 = bounds.x + (int)Math.round((double)(bounds.width - dimensions.width) / 2.0);
        } else {
            throw new IllegalArgumentException("Unsupported horizontal alignment.");
        }
        n3 += n;
        if (verticalAlignment == VerticalAlignment.TOP) {
            n4 = bounds.y - dimensions.height;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            n4 = bounds.y + bounds.height;
        } else if (verticalAlignment == VerticalAlignment.CENTER) {
            n4 = bounds.y + (int)Math.round((double)(bounds.height - dimensions.height) / 2.0);
        } else {
            throw new IllegalArgumentException("Unsupported vertical alignment.");
        }
        this.setLocation(n3, n4 += n2);
    }

    @Override
    public boolean keyReleased(int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyReleased(n, keyLocation);
        Keyboard.KeyStroke keyStroke = new Keyboard.KeyStroke(n, Keyboard.getModifiers());
        Action action = (Action)this.actionMap.get((Object)keyStroke);
        if (action != null && action.isEnabled()) {
            action.perform();
        }
        return bl;
    }

    public ListenerList<WindowListener> getWindowListeners() {
        return this.windowListeners;
    }

    public ListenerList<WindowStateListener> getWindowStateListeners() {
        return this.windowStateListeners;
    }

    public ListenerList<WindowActionMappingListener> getWindowActionMappingListeners() {
        return this.windowActionMappingListeners;
    }

    public static ListenerList<WindowClassListener> getWindowClassListeners() {
        return windowClassListeners;
    }

    private static class WindowClassListenerList
    extends ListenerList<WindowClassListener>
    implements WindowClassListener {
        private WindowClassListenerList() {
        }

        @Override
        public void activeWindowChanged(Window window) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowClassListener windowClassListener = (WindowClassListener)iterator.next();
                windowClassListener.activeWindowChanged(window);
            }
        }
    }

    private static class WindowActionMappingListenerList
    extends ListenerList<WindowActionMappingListener>
    implements WindowActionMappingListener {
        private WindowActionMappingListenerList() {
        }

        @Override
        public void actionMappingAdded(Window window) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowActionMappingListener windowActionMappingListener = (WindowActionMappingListener)iterator.next();
                windowActionMappingListener.actionMappingAdded(window);
            }
        }

        @Override
        public void actionMappingsRemoved(Window window, int n, Sequence<ActionMapping> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowActionMappingListener windowActionMappingListener = (WindowActionMappingListener)iterator.next();
                windowActionMappingListener.actionMappingsRemoved(window, n, sequence);
            }
        }

        @Override
        public void keyStrokeChanged(ActionMapping actionMapping, Keyboard.KeyStroke keyStroke) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowActionMappingListener windowActionMappingListener = (WindowActionMappingListener)iterator.next();
                windowActionMappingListener.keyStrokeChanged(actionMapping, keyStroke);
            }
        }

        @Override
        public void actionChanged(ActionMapping actionMapping, Action action) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowActionMappingListener windowActionMappingListener = (WindowActionMappingListener)iterator.next();
                windowActionMappingListener.actionChanged(actionMapping, action);
            }
        }
    }

    private static class WindowStateListenerList
    extends ListenerList<WindowStateListener>
    implements WindowStateListener {
        private WindowStateListenerList() {
        }

        @Override
        public Vote previewWindowOpen(Window window, Display display) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                vote = vote.tally(windowStateListener.previewWindowOpen(window, display));
            }
            return vote;
        }

        @Override
        public void windowOpenVetoed(Window window, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                windowStateListener.windowOpenVetoed(window, vote);
            }
        }

        @Override
        public void windowOpened(Window window) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                windowStateListener.windowOpened(window);
            }
        }

        @Override
        public Vote previewWindowClose(Window window) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                vote = vote.tally(windowStateListener.previewWindowClose(window));
            }
            return vote;
        }

        @Override
        public void windowCloseVetoed(Window window, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                windowStateListener.windowCloseVetoed(window, vote);
            }
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowStateListener windowStateListener = (WindowStateListener)iterator.next();
                windowStateListener.windowClosed(window, display, window2);
            }
        }
    }

    private static class WindowListenerList
    extends ListenerList<WindowListener>
    implements WindowListener {
        private WindowListenerList() {
        }

        @Override
        public void titleChanged(Window window, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowListener windowListener = (WindowListener)iterator.next();
                windowListener.titleChanged(window, string);
            }
        }

        @Override
        public void iconChanged(Window window, Image image) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowListener windowListener = (WindowListener)iterator.next();
                windowListener.iconChanged(window, image);
            }
        }

        @Override
        public void contentChanged(Window window, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowListener windowListener = (WindowListener)iterator.next();
                windowListener.contentChanged(window, component);
            }
        }

        @Override
        public void activeChanged(Window window, Window window2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowListener windowListener = (WindowListener)iterator.next();
                windowListener.activeChanged(window, window2);
            }
        }

        @Override
        public void maximizedChanged(Window window) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                WindowListener windowListener = (WindowListener)iterator.next();
                windowListener.maximizedChanged(window);
            }
        }
    }

    public class ActionMappingSequence
    implements Sequence<ActionMapping> {
        public int add(ActionMapping actionMapping) {
            if (actionMapping.window != null) {
                throw new IllegalArgumentException("Action mapping already has a window.");
            }
            if (actionMapping.keyStroke == null) {
                throw new IllegalArgumentException("Keystroke is undefined.");
            }
            if (actionMapping.action == null) {
                throw new IllegalArgumentException("Action is undefined.");
            }
            if (Window.this.actionMap.containsKey((Object)actionMapping.keyStroke)) {
                throw new IllegalArgumentException("A mapping for " + actionMapping.keyStroke + " already exists.");
            }
            actionMapping.window = Window.this;
            int n = Window.this.actionMappings.add((Object)actionMapping);
            Window.this.actionMap.put((Object)actionMapping.keyStroke, (Object)actionMapping.action);
            Window.this.windowActionMappingListeners.actionMappingAdded(Window.this);
            return n;
        }

        public void insert(ActionMapping actionMapping, int n) {
            throw new UnsupportedOperationException();
        }

        public ActionMapping update(int n, ActionMapping actionMapping) {
            throw new UnsupportedOperationException();
        }

        public int remove(ActionMapping actionMapping) {
            int n = this.indexOf(actionMapping);
            if (n >= 0) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<ActionMapping> remove(int n, int n2) {
            Sequence sequence = Window.this.actionMappings.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                ActionMapping actionMapping = (ActionMapping)sequence.get(i);
                actionMapping.window = null;
                Window.this.actionMap.remove((Object)actionMapping.keyStroke);
            }
            Window.this.windowActionMappingListeners.actionMappingsRemoved(Window.this, n, (Sequence<ActionMapping>)sequence);
            return sequence;
        }

        public ActionMapping get(int n) {
            return (ActionMapping)Window.this.actionMappings.get(n);
        }

        public int indexOf(ActionMapping actionMapping) {
            return Window.this.actionMappings.indexOf((Object)actionMapping);
        }

        public int getLength() {
            return Window.this.actionMappings.getLength();
        }
    }

    public static class ActionMapping {
        private Window window = null;
        private Keyboard.KeyStroke keyStroke = null;
        private Action action = null;

        public ActionMapping() {
        }

        public ActionMapping(Keyboard.KeyStroke keyStroke, Action action) {
            this.setKeyStroke(keyStroke);
            this.setAction(action);
        }

        public ActionMapping(Keyboard.KeyStroke keyStroke, String string) {
            this.setKeyStroke(keyStroke);
            this.setAction(string);
        }

        public Window getWindow() {
            return this.window;
        }

        public Keyboard.KeyStroke getKeyStroke() {
            return this.keyStroke;
        }

        public void setKeyStroke(Keyboard.KeyStroke keyStroke) {
            Keyboard.KeyStroke keyStroke2 = this.keyStroke;
            if (keyStroke != keyStroke2) {
                if (this.window != null) {
                    if (keyStroke == null) {
                        throw new IllegalStateException();
                    }
                    if (this.window.actionMap.containsKey((Object)keyStroke)) {
                        throw new IllegalArgumentException("A mapping for " + keyStroke + " already exists.");
                    }
                    if (keyStroke2 != null) {
                        this.window.actionMap.remove((Object)keyStroke2);
                    }
                    this.window.actionMap.put((Object)keyStroke, (Object)this.action);
                    this.window.windowActionMappingListeners.keyStrokeChanged(this, keyStroke2);
                }
                this.keyStroke = keyStroke;
            }
        }

        public void setKeyStroke(String string) {
            if (string == null) {
                throw new IllegalArgumentException("keyStroke is null.");
            }
            this.setKeyStroke(Keyboard.KeyStroke.decode(string));
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            Action action2 = this.action;
            if (action != action2) {
                if (this.window != null) {
                    if (action == null) {
                        throw new IllegalStateException();
                    }
                    this.window.actionMap.put((Object)this.keyStroke, (Object)action);
                    this.window.windowActionMappingListeners.actionChanged(this, action2);
                }
                this.action = action;
            }
        }

        public void setAction(String string) {
            if (string == null) {
                throw new IllegalArgumentException("actionID is null");
            }
            Action action = Action.getNamedActions().get(string);
            if (action == null) {
                throw new IllegalArgumentException("An action with ID " + string + " does not exist.");
            }
            this.setAction(action);
        }
    }

    public static interface Skin
    extends org.apache.pivot.wtk.Skin {
        public Bounds getClientArea();
    }
}

