/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.content.ColorItem;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.content.ListViewItemRenderer;
import org.apache.pivot.wtk.media.Image;

public class ListViewColorItemRenderer
extends ListViewItemRenderer {
    private ColorBadge colorBadge = new ColorBadge();
    private ListItem listItem = new ListItem(this.colorBadge);

    public ListViewColorItemRenderer() {
        this.setShowIcon(true);
    }

    @Override
    public void render(Object object, int n, ListView listView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (object != null) {
            ColorItem colorItem;
            if (object instanceof ColorItem) {
                colorItem = (ColorItem)object;
            } else {
                Color color = object instanceof Color ? (Color)object : GraphicsUtilities.decodeColor(object.toString());
                colorItem = new ColorItem(color);
            }
            this.colorBadge.setColor(colorItem.getColor());
            this.listItem.setText(colorItem.getName());
        }
        super.render(this.listItem, n, listView, bl, bl2, bl3, bl4);
    }

    public static class ColorBadge
    extends Image {
        private Color color = Color.BLACK;
        public static final int SIZE = 14;

        @Override
        public int getWidth() {
            return 14;
        }

        @Override
        public int getHeight() {
            return 14;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, 14, 14);
            graphics2D.setColor(this.color);
            graphics2D.fillRect(2, 2, 10, 10);
            graphics2D.setColor(Color.GRAY);
            GraphicsUtilities.drawRect(graphics2D, 0, 0, 14, 14);
        }
    }
}

