/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;

public class TableViewCellEditor
implements TableView.RowEditor {
    private ComponentListener componentListener = new ComponentListener.Adapter(){

        @Override
        public void sizeChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    TableViewCellEditor.this.reposition();
                }
            });
        }

        @Override
        public void locationChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    TableViewCellEditor.this.reposition();
                }
            });
        }
    };
    private TableViewListener tableViewListener = new TableViewListener.Adapter(){

        @Override
        public void tableDataChanged(TableView tableView, List<?> list) {
            TableViewCellEditor.this.cancelEdit();
        }

        @Override
        public void rowEditorChanged(TableView tableView, TableView.RowEditor rowEditor) {
            TableViewCellEditor.this.cancelEdit();
        }
    };
    private TableViewRowListener tableViewRowListener = new TableViewRowListener.Adapter(){

        @Override
        public void rowInserted(TableView tableView, int n) {
            TableViewCellEditor.this.cancelEdit();
        }

        @Override
        public void rowsRemoved(TableView tableView, int n, int n2) {
            TableViewCellEditor.this.cancelEdit();
        }

        @Override
        public void rowUpdated(TableView tableView, int n) {
            TableViewCellEditor.this.cancelEdit();
        }

        @Override
        public void rowsSorted(TableView tableView) {
            TableViewCellEditor.this.cancelEdit();
        }
    };
    private ComponentKeyListener textInputKeyHandler = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            if (n == 10) {
                TableViewCellEditor.this.saveChanges();
            } else if (n == 27) {
                TableViewCellEditor.this.cancelEdit();
            }
            return false;
        }
    };
    private WindowStateListener popupWindowStateHandler = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)TableViewCellEditor.this.displayMouseHandler);
            TableViewCellEditor.this.tableView.getComponentListeners().add((Object)TableViewCellEditor.this.componentListener);
            TableViewCellEditor.this.tableView.getTableViewListeners().add((Object)TableViewCellEditor.this.tableViewListener);
            TableViewCellEditor.this.tableView.getTableViewRowListeners().add((Object)TableViewCellEditor.this.tableViewRowListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)TableViewCellEditor.this.displayMouseHandler);
            TableViewCellEditor.this.tableView.getComponentListeners().remove((Object)TableViewCellEditor.this.componentListener);
            TableViewCellEditor.this.tableView.getTableViewListeners().remove((Object)TableViewCellEditor.this.tableViewListener);
            TableViewCellEditor.this.tableView.getTableViewRowListeners().remove((Object)TableViewCellEditor.this.tableViewRowListener);
            window2.moveToFront();
            TableViewCellEditor.this.tableView = null;
            TableViewCellEditor.this.textInput = null;
            TableViewCellEditor.this.popup = null;
        }
    };
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n, n2);
            if (TableViewCellEditor.this.popup != window) {
                TableViewCellEditor.this.saveChanges();
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return true;
        }
    };
    private TableView tableView = null;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private TextInput textInput = null;
    private Window popup = null;
    private TableView.RowEditor.RowEditorListenerList rowEditorListeners = new TableView.RowEditor.RowEditorListenerList();

    @Override
    public void editRow(TableView tableView, int n, int n2) {
        BeanDictionary beanDictionary;
        Dictionary dictionary;
        if (this.isEditing()) {
            throw new IllegalStateException("Currently editing.");
        }
        boolean bl = false;
        String string = tableView.getColumns().get(n2).getName();
        Object object = tableView.getTableData().get(n);
        if (object instanceof Dictionary) {
            dictionary = (Dictionary)object;
        } else {
            beanDictionary = new BeanDictionary(object);
            bl = beanDictionary.isReadOnly(string);
            dictionary = beanDictionary;
        }
        if (!bl) {
            beanDictionary = this.rowEditorListeners.previewEditRow(this, tableView, n, n2);
            if (beanDictionary == Vote.APPROVE) {
                this.tableView = tableView;
                this.rowIndex = n;
                this.columnIndex = n2;
                Object object2 = dictionary.get((Object)string);
                this.textInput = new TextInput();
                this.textInput.setText(object2 == null ? "" : object2.toString());
                this.textInput.getComponentKeyListeners().add((Object)this.textInputKeyHandler);
                this.popup = new Window(this.textInput);
                this.popup.getWindowStateListeners().add((Object)this.popupWindowStateHandler);
                this.popup.open(tableView.getWindow());
                this.reposition();
                this.textInput.selectAll();
                this.textInput.requestFocus();
                this.rowEditorListeners.rowEditing(this, tableView, n, n2);
            } else if (beanDictionary == Vote.DENY) {
                this.rowEditorListeners.editRowVetoed(this, (Vote)beanDictionary);
            }
        }
    }

    private void reposition() {
        Bounds bounds = this.tableView.getCellBounds(this.rowIndex, this.columnIndex);
        this.tableView.scrollAreaToVisible(bounds);
        bounds = this.tableView.getVisibleArea(bounds);
        Point point = this.tableView.mapPointToAncestor(this.tableView.getDisplay(), bounds.x, bounds.y);
        this.textInput.setPreferredWidth(bounds.width);
        this.popup.setLocation(point.x, point.y + (bounds.height - this.textInput.getPreferredHeight(-1)) / 2);
    }

    @Override
    public boolean isEditing() {
        return this.tableView != null;
    }

    @Override
    public void saveChanges() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        TableView tableView = this.tableView;
        int n = this.rowIndex;
        int n2 = this.columnIndex;
        String string = this.textInput.getText();
        String string2 = tableView.getColumns().get(n2).getName();
        HashMap hashMap = new HashMap();
        hashMap.put((Object)string2, (Object)string);
        Vote vote = this.rowEditorListeners.previewSaveChanges(this, tableView, n, n2, (Dictionary<String, Object>)hashMap);
        if (vote == Vote.APPROVE) {
            List<?> list = tableView.getTableData();
            Object object = list.get(n);
            Object object2 = object instanceof Dictionary ? (Dictionary)object : new BeanDictionary(object);
            object2.put((Object)string2, (Object)string);
            if (list.getComparator() == null) {
                list.update(n, object);
            } else {
                list.remove(n, 1);
                list.add(object);
                n = list.indexOf(object);
                tableView.setSelectedIndex(n);
                tableView.scrollAreaToVisible(tableView.getRowBounds(n));
            }
            this.rowEditorListeners.changesSaved(this, tableView, n, n2);
        } else if (vote == Vote.DENY) {
            this.rowEditorListeners.saveChangesVetoed(this, vote);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        TableView tableView = this.tableView;
        int n = this.rowIndex;
        int n2 = this.columnIndex;
        this.popup.close();
        this.rowEditorListeners.editCancelled(this, tableView, n, n2);
    }

    @Override
    public ListenerList<TableView.RowEditorListener> getRowEditorListeners() {
        return this.rowEditorListeners;
    }
}

