/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.net.URL;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.media.Image;

public class TableViewHeaderData {
    private Image icon = null;
    private String text = null;

    public TableViewHeaderData() {
        this(null, null);
    }

    public TableViewHeaderData(Image image) {
        this(image, null);
    }

    public TableViewHeaderData(String string) {
        this(null, string);
    }

    public TableViewHeaderData(Image image, String string) {
        this.icon = image;
        this.text = string;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    public void setIcon(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        this.setIcon(image);
    }

    public void setIcon(String string) {
        if (string == null) {
            throw new IllegalArgumentException("iconName is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        this.setIcon(classLoader.getResource(string));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

