/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Graphics2D;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.content.TableViewCellRenderer;

public class TableViewMultiCellRenderer
implements TableView.CellRenderer {
    private int width;
    private int height;
    private HashMap<Class<?>, TableView.CellRenderer> cellRenderers = new HashMap();
    private TableView.CellRenderer defaultRenderer;
    private TableView.CellRenderer currentRenderer = this.defaultRenderer = new TableViewCellRenderer();
    private RendererMappingSequence rendererMappings = new RendererMappingSequence();
    private static final StyleDictionary STYLES = new StyleDictionary();

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBaseline() {
        return this.currentRenderer.getBaseline();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.currentRenderer.paint(graphics2D);
    }

    @Override
    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.currentRenderer.setSize(n, n2);
    }

    @Override
    public int getPreferredWidth(int n) {
        return this.currentRenderer.getPreferredWidth(n);
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2 = this.defaultRenderer.getPreferredHeight(n);
        for (Class clazz : this.cellRenderers) {
            TableView.CellRenderer cellRenderer = (TableView.CellRenderer)this.cellRenderers.get((Object)clazz);
            n2 = Math.max(n2, cellRenderer.getPreferredHeight(n));
        }
        return n2;
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public int getBaseline(int n, int n2) {
        return -1;
    }

    @Override
    public Dictionary<String, Object> getStyles() {
        return STYLES;
    }

    @Override
    public void render(Object object, int n, int n2, TableView tableView, String string, boolean bl, boolean bl2, boolean bl3) {
        if (object == null) {
            for (Class clazz : this.cellRenderers) {
                TableView.CellRenderer cellRenderer = (TableView.CellRenderer)this.cellRenderers.get((Object)clazz);
                cellRenderer.render(null, n, n2, tableView, string, bl, bl2, bl3);
            }
        } else {
            Class<?> clazz;
            Object object2;
            Object object3 = null;
            if (string != null) {
                object2 = object instanceof Dictionary ? (Dictionary)object : new BeanDictionary(object);
                object3 = object2.get((Object)string);
            }
            object2 = null;
            Class<?> clazz2 = clazz = object3 == null ? null : object3.getClass();
            while (object2 == null && clazz != Object.class) {
                object2 = (TableView.CellRenderer)this.cellRenderers.get(clazz);
                if (object2 != null) continue;
                clazz = clazz.getSuperclass();
            }
            if (object2 == null) {
                object2 = this.defaultRenderer;
            }
            if (object2 != this.currentRenderer) {
                this.currentRenderer = object2;
                object2.setSize(this.width, this.height);
            }
            object2.render(object, n, n2, tableView, string, bl, bl2, bl3);
        }
    }

    public TableView.CellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(TableView.CellRenderer cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException("defaultRenderer is null.");
        }
        this.defaultRenderer = cellRenderer;
    }

    public Sequence<RendererMapping> getRendererMappings() {
        return this.rendererMappings;
    }

    private class RendererMappingSequence
    implements Sequence<RendererMapping> {
        private ArrayList<RendererMapping> mappings = new ArrayList();

        private RendererMappingSequence() {
        }

        public int add(RendererMapping rendererMapping) {
            int n = this.mappings.getLength();
            this.insert(rendererMapping, n);
            return n;
        }

        public void insert(RendererMapping rendererMapping, int n) {
            if (rendererMapping == null) {
                throw new IllegalArgumentException("item is null.");
            }
            Class<?> clazz = rendererMapping.getValueClass();
            if (TableViewMultiCellRenderer.this.cellRenderers.containsKey(clazz)) {
                throw new IllegalArgumentException("Duplicate value class mapping: " + (clazz == null ? "null" : clazz.getName()));
            }
            this.mappings.insert((Object)rendererMapping, n);
            TableView.CellRenderer cellRenderer = rendererMapping.getCellRenderer();
            TableViewMultiCellRenderer.this.cellRenderers.put(clazz, (Object)cellRenderer);
            rendererMapping.setMultiCellRenderer(TableViewMultiCellRenderer.this);
        }

        public RendererMapping update(int n, RendererMapping rendererMapping) {
            if (rendererMapping == null) {
                throw new IllegalArgumentException("item is null.");
            }
            if (n >= this.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            RendererMapping rendererMapping2 = (RendererMapping)this.mappings.get(n);
            if (rendererMapping != rendererMapping2) {
                Class<?> clazz = rendererMapping.getValueClass();
                Class<?> clazz2 = rendererMapping2.getValueClass();
                if (TableViewMultiCellRenderer.this.cellRenderers.containsKey(clazz) && clazz != clazz2) {
                    throw new IllegalArgumentException("Duplicate value class mapping: " + clazz.getName());
                }
                this.mappings.update(n, (Object)rendererMapping);
                TableView.CellRenderer cellRenderer = rendererMapping.getCellRenderer();
                TableViewMultiCellRenderer.this.cellRenderers.remove(clazz2);
                TableViewMultiCellRenderer.this.cellRenderers.put(clazz, (Object)cellRenderer);
                rendererMapping2.setMultiCellRenderer(null);
                rendererMapping.setMultiCellRenderer(TableViewMultiCellRenderer.this);
            }
            return rendererMapping2;
        }

        public int remove(RendererMapping rendererMapping) {
            int n = this.mappings.indexOf((Object)rendererMapping);
            if (n >= 0) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<RendererMapping> remove(int n, int n2) {
            Sequence sequence = this.mappings.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                RendererMapping rendererMapping = (RendererMapping)sequence.get(i);
                Class<?> clazz = rendererMapping.getValueClass();
                TableViewMultiCellRenderer.this.cellRenderers.remove(clazz);
                rendererMapping.setMultiCellRenderer(null);
            }
            return sequence;
        }

        public RendererMapping get(int n) {
            return (RendererMapping)this.mappings.get(n);
        }

        public int indexOf(RendererMapping rendererMapping) {
            return this.mappings.indexOf((Object)rendererMapping);
        }

        public int getLength() {
            return this.mappings.getLength();
        }
    }

    public static final class RendererMapping {
        private Class<?> valueClass = null;
        private TableView.CellRenderer cellRenderer = null;
        private TableViewMultiCellRenderer multiCellRenderer = null;

        public Class<?> getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("valueClass is null.");
            }
            Class<?> clazz2 = this.valueClass;
            if (clazz != clazz2) {
                this.valueClass = clazz;
                if (this.multiCellRenderer != null) {
                    this.multiCellRenderer.cellRenderers.remove(clazz2);
                    this.multiCellRenderer.cellRenderers.put(clazz, (Object)this.cellRenderer);
                }
            }
        }

        public void setValueClass(String string) {
            if (string == null) {
                throw new IllegalArgumentException("valueClass is null.");
            }
            try {
                this.setValueClass(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        public TableView.CellRenderer getCellRenderer() {
            return this.cellRenderer;
        }

        public void setCellRenderer(TableView.CellRenderer cellRenderer) {
            if (cellRenderer == null) {
                throw new IllegalArgumentException("cellRenderer is null.");
            }
            TableView.CellRenderer cellRenderer2 = this.cellRenderer;
            if (cellRenderer != cellRenderer2) {
                this.cellRenderer = cellRenderer;
                if (this.multiCellRenderer != null) {
                    this.multiCellRenderer.cellRenderers.put(this.valueClass, (Object)cellRenderer);
                }
            }
        }

        private void setMultiCellRenderer(TableViewMultiCellRenderer tableViewMultiCellRenderer) {
            this.multiCellRenderer = tableViewMultiCellRenderer;
        }
    }

    private static class StyleDictionary
    implements Dictionary<String, Object> {
        private StyleDictionary() {
        }

        public Object get(String string) {
            return null;
        }

        public Object put(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(String string) {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(String string) {
            return false;
        }
    }
}

