/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.media.Image;

public class TreeBranch
extends TreeNode
implements List<TreeNode> {
    private Image expandedIcon = null;
    private ArrayList<TreeNode> treeNodes = new ArrayList();
    private List.ListListenerList<TreeNode> listListeners = new List.ListListenerList();

    public TreeBranch() {
        this(null, null, null);
    }

    public TreeBranch(Image image) {
        this(image, null, null);
    }

    public TreeBranch(String string) {
        this(null, null, string);
    }

    public TreeBranch(Image image, String string) {
        this(image, null, string);
    }

    public TreeBranch(Image image, Image image2, String string) {
        super(image, string);
        this.expandedIcon = image2;
    }

    public Image getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setExpandedIcon(Image image) {
        this.expandedIcon = image;
    }

    public int add(TreeNode treeNode) {
        int n = this.treeNodes.add((Object)treeNode);
        this.listListeners.itemInserted((List)this, n);
        return n;
    }

    public void insert(TreeNode treeNode, int n) {
        this.treeNodes.insert((Object)treeNode, n);
        this.listListeners.itemInserted((List)this, n);
    }

    public TreeNode update(int n, TreeNode treeNode) {
        TreeNode treeNode2 = (TreeNode)this.treeNodes.update(n, (Object)treeNode);
        this.listListeners.itemUpdated((List)this, n, (Object)treeNode2);
        return treeNode2;
    }

    public int remove(TreeNode treeNode) {
        int n = this.indexOf(treeNode);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    public Sequence<TreeNode> remove(int n, int n2) {
        Sequence sequence = this.treeNodes.remove(n, n2);
        if (n2 > 0) {
            this.listListeners.itemsRemoved((List)this, n, sequence);
        }
        return sequence;
    }

    public void clear() {
        if (this.getLength() > 0) {
            this.treeNodes.clear();
            this.listListeners.listCleared((List)this);
        }
    }

    public TreeNode get(int n) {
        return (TreeNode)this.treeNodes.get(n);
    }

    public int indexOf(TreeNode treeNode) {
        return this.treeNodes.indexOf((Object)treeNode);
    }

    public boolean isEmpty() {
        return this.treeNodes.isEmpty();
    }

    public int getLength() {
        return this.treeNodes.getLength();
    }

    public Comparator<TreeNode> getComparator() {
        return this.treeNodes.getComparator();
    }

    public void setComparator(Comparator<TreeNode> comparator) {
        Comparator comparator2 = this.treeNodes.getComparator();
        this.treeNodes.setComparator(comparator);
        int n = this.treeNodes.getLength();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = (TreeNode)this.treeNodes.get(i);
            if (!(treeNode instanceof TreeBranch)) continue;
            TreeBranch treeBranch = (TreeBranch)treeNode;
            treeBranch.setComparator(comparator);
        }
        this.listListeners.comparatorChanged((List)this, comparator2);
    }

    public Iterator<TreeNode> iterator() {
        return new ImmutableIterator((Iterator)this.treeNodes.iterator());
    }

    public ListenerList<ListListener<TreeNode>> getListListeners() {
        return this.listListeners;
    }
}

