/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.TreeViewListener;
import org.apache.pivot.wtk.TreeViewNodeListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.content.TreeViewNodeRenderer;

public class TreeViewNodeEditor
implements TreeView.NodeEditor {
    private ComponentListener componentListener = new ComponentListener.Adapter(){

        @Override
        public void sizeChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    TreeViewNodeEditor.this.reposition();
                }
            });
        }

        @Override
        public void locationChanged(Component component, int n, int n2) {
            ApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    TreeViewNodeEditor.this.reposition();
                }
            });
        }
    };
    private WindowStateListener popupStateHandler = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)TreeViewNodeEditor.this.displayMouseHandler);
            TreeViewNodeEditor.this.treeView.getComponentListeners().add((Object)TreeViewNodeEditor.this.componentListener);
            TreeViewNodeEditor.this.treeView.getTreeViewListeners().add((Object)TreeViewNodeEditor.this.treeViewHandler);
            TreeViewNodeEditor.this.treeView.getTreeViewNodeListeners().add((Object)TreeViewNodeEditor.this.treeViewNodeHandler);
        }

        @Override
        public void windowClosed(Window window, Display display, Window window2) {
            display.getContainerMouseListeners().remove((Object)TreeViewNodeEditor.this.displayMouseHandler);
            TreeViewNodeEditor.this.treeView.getComponentListeners().remove((Object)TreeViewNodeEditor.this.componentListener);
            TreeViewNodeEditor.this.treeView.getTreeViewListeners().remove((Object)TreeViewNodeEditor.this.treeViewHandler);
            TreeViewNodeEditor.this.treeView.getTreeViewNodeListeners().remove((Object)TreeViewNodeEditor.this.treeViewNodeHandler);
            window2.moveToFront();
            TreeViewNodeEditor.this.treeView = null;
            TreeViewNodeEditor.this.path = null;
            TreeViewNodeEditor.this.textInput = null;
            TreeViewNodeEditor.this.popup = null;
        }
    };
    private ComponentKeyListener textInputKeyHandler = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            if (n == 10) {
                TreeViewNodeEditor.this.saveChanges();
            } else if (n == 27) {
                TreeViewNodeEditor.this.cancelEdit();
            }
            return false;
        }
    };
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n, n2);
            if (TreeViewNodeEditor.this.popup != window) {
                TreeViewNodeEditor.this.saveChanges();
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return true;
        }
    };
    private TreeViewListener treeViewHandler = new TreeViewListener.Adapter(){

        @Override
        public void treeDataChanged(TreeView treeView, List<?> list) {
            TreeViewNodeEditor.this.cancelEdit();
        }

        @Override
        public void nodeEditorChanged(TreeView treeView, TreeView.NodeEditor nodeEditor) {
            TreeViewNodeEditor.this.cancelEdit();
        }
    };
    private TreeViewNodeListener treeViewNodeHandler = new TreeViewNodeListener.Adapter(){

        @Override
        public void nodeInserted(TreeView treeView, Sequence.Tree.Path path, int n) {
            TreeViewNodeEditor.this.cancelEdit();
        }

        @Override
        public void nodesRemoved(TreeView treeView, Sequence.Tree.Path path, int n, int n2) {
            TreeViewNodeEditor.this.cancelEdit();
        }

        @Override
        public void nodeUpdated(TreeView treeView, Sequence.Tree.Path path, int n) {
            TreeViewNodeEditor.this.cancelEdit();
        }

        @Override
        public void nodesSorted(TreeView treeView, Sequence.Tree.Path path) {
            TreeViewNodeEditor.this.cancelEdit();
        }
    };
    private TreeView treeView = null;
    private Sequence.Tree.Path path = null;
    private Window popup = null;
    private TextInput textInput = null;
    private TreeView.NodeEditor.NodeEditorListenerList nodeEditorListeners = new TreeView.NodeEditor.NodeEditorListenerList();

    @Override
    public void editNode(TreeView treeView, Sequence.Tree.Path path) {
        if (this.isEditing()) {
            throw new IllegalStateException();
        }
        Vote vote = this.nodeEditorListeners.previewEditNode(this, treeView, path);
        if (vote == Vote.APPROVE) {
            this.treeView = treeView;
            this.path = path;
            List<?> list = treeView.getTreeData();
            TreeNode treeNode = (TreeNode)Sequence.Tree.get(list, (Sequence.Tree.Path)path);
            this.textInput = new TextInput();
            this.textInput.setText(treeNode.getText());
            this.textInput.getComponentKeyListeners().add((Object)this.textInputKeyHandler);
            this.popup = new Window(this.textInput);
            this.popup.getWindowStateListeners().add((Object)this.popupStateHandler);
            this.popup.open(treeView.getWindow());
            this.reposition();
            this.textInput.selectAll();
            this.textInput.requestFocus();
            this.nodeEditorListeners.nodeEditing(this, treeView, path);
        } else if (vote == Vote.DENY) {
            this.nodeEditorListeners.editNodeVetoed(this, vote);
        }
    }

    private void reposition() {
        List<?> list = this.treeView.getTreeData();
        TreeNode treeNode = (TreeNode)Sequence.Tree.get(list, (Sequence.Tree.Path)this.path);
        Bounds bounds = this.treeView.getNodeBounds(this.path);
        int n = this.treeView.getNodeIndent(this.path.getLength());
        bounds = new Bounds(bounds.x + n, bounds.y, bounds.width - n, bounds.height);
        TreeViewNodeRenderer treeViewNodeRenderer = (TreeViewNodeRenderer)this.treeView.getNodeRenderer();
        treeViewNodeRenderer.render(treeNode, this.path, this.treeView.getRowIndex(this.path), this.treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
        treeViewNodeRenderer.setSize(bounds.width, bounds.height);
        Bounds bounds2 = treeViewNodeRenderer.getTextBounds();
        Insets insets = (Insets)this.textInput.getStyles().get("padding");
        Bounds bounds3 = new Bounds(bounds.x + bounds2.x - (insets.left + 1), bounds.y, bounds.width - bounds2.x + (insets.left + 1), bounds.height);
        this.treeView.scrollAreaToVisible(bounds3.x, bounds3.y, bounds2.width + insets.left + 1, bounds3.height);
        bounds3 = this.treeView.getVisibleArea(bounds3);
        Point point = this.treeView.mapPointToAncestor(this.treeView.getDisplay(), bounds3.x, bounds3.y);
        this.textInput.setPreferredWidth(bounds3.width);
        this.popup.setLocation(point.x, point.y + (bounds3.height - this.textInput.getPreferredHeight(-1)) / 2);
    }

    @Override
    public boolean isEditing() {
        return this.treeView != null;
    }

    @Override
    public void saveChanges() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        TreeView treeView = this.treeView;
        Sequence.Tree.Path path = this.path;
        String string = this.textInput.getText();
        Vote vote = this.nodeEditorListeners.previewSaveChanges(this, treeView, path, string);
        if (vote == Vote.APPROVE) {
            List list;
            List list2 = treeView.getTreeData();
            TreeNode treeNode = (TreeNode)Sequence.Tree.get(list2, (Sequence.Tree.Path)path);
            treeNode.setText(string);
            int n = path.getLength();
            if (n == 1) {
                list = list2;
            } else {
                Sequence.Tree.Path path2 = new Sequence.Tree.Path(path, n - 1);
                list = (List)Sequence.Tree.get(list2, (Sequence.Tree.Path)path2);
            }
            if (list.getComparator() == null) {
                list.update(path.get(n - 1).intValue(), (Object)treeNode);
            } else {
                list.remove(path.get(n - 1).intValue(), 1);
                list.add((Object)treeNode);
                path = new Sequence.Tree.Path(path, n - 1);
                path.add(Integer.valueOf(list.indexOf((Object)treeNode)));
                treeView.setSelectedPath(path);
                treeView.scrollAreaToVisible(treeView.getNodeBounds(path));
            }
            this.nodeEditorListeners.changesSaved(this, treeView, path);
        } else if (vote == Vote.DENY) {
            this.nodeEditorListeners.saveChangesVetoed(this, vote);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            throw new IllegalStateException();
        }
        TreeView treeView = this.treeView;
        Sequence.Tree.Path path = this.path;
        this.popup.close();
        this.nodeEditorListeners.editCancelled(this, treeView, path);
    }

    @Override
    public ListenerList<TreeView.NodeEditorListener> getNodeEditorListeners() {
        return this.nodeEditorListeners;
    }
}

