/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.TreeBranch;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.media.Image;

public class TreeViewNodeRenderer
extends BoxPane
implements TreeView.NodeRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static boolean DEFAULT_SHOW_ICON = true;

    public TreeViewNodeRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.setPreferredSize(16, 16);
        this.imageView.setVisible(DEFAULT_SHOW_ICON);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validate();
    }

    @Override
    public void render(Object object, Sequence.Tree.Path path, int n, TreeView treeView, boolean bl, boolean bl2, TreeView.NodeCheckState nodeCheckState, boolean bl3, boolean bl4) {
        if (object != null) {
            Object object2;
            Object object3;
            Image image = null;
            String string = null;
            if (object instanceof TreeNode) {
                object3 = (TreeNode)object;
                if (bl && object3 instanceof TreeBranch) {
                    object2 = (TreeBranch)object3;
                    image = ((TreeBranch)object2).getExpandedIcon();
                    if (image == null) {
                        image = ((TreeNode)object2).getIcon();
                    }
                } else {
                    image = ((TreeNode)object3).getIcon();
                }
                string = ((TreeNode)object3).getText();
            } else if (object instanceof Image) {
                image = (Image)object;
            } else {
                string = object.toString();
            }
            this.imageView.setImage(image);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(treeView.isEnabled() && !bl4 ? 1.0f : 0.5f));
            this.label.setText(string);
            if (string == null) {
                this.label.setVisible(false);
            } else {
                this.label.setVisible(true);
                object3 = (Font)treeView.getStyles().get("font");
                this.label.getStyles().put("font", object3);
                object2 = treeView.isEnabled() && !bl4 ? (bl2 ? (treeView.isFocused() ? (Color)treeView.getStyles().get("selectionColor") : (Color)treeView.getStyles().get("inactiveSelectionColor")) : (Color)treeView.getStyles().get("color")) : (Color)treeView.getStyles().get("disabledColor");
                this.label.getStyles().put("color", object2);
            }
        }
    }

    public int getIconWidth() {
        return this.imageView.getPreferredWidth(-1);
    }

    public void setIconWidth(int n) {
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.imageView.setPreferredWidth(n);
    }

    public int getIconHeight() {
        return this.imageView.getPreferredHeight(-1);
    }

    public void setIconHeight(int n) {
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.imageView.setPreferredHeight(n);
    }

    public boolean getShowIcon() {
        return this.imageView.isVisible();
    }

    public void setShowIcon(boolean bl) {
        this.imageView.setVisible(bl);
    }

    public Bounds getTextBounds() {
        return this.label.isVisible() ? this.label.getBounds() : null;
    }
}

