/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.effects.Decorator;

public class DropShadowDecorator
implements Decorator {
    private int blurRadius;
    private int xOffset;
    private int yOffset;
    private Color shadowColor = Color.BLACK;
    private float shadowOpacity = 0.25f;
    private BufferedImage shadowImage = null;
    public static final float DEFAULT_SHADOW_OPACITY = 0.25f;

    public DropShadowDecorator() {
        this(5, 5, 5);
    }

    public DropShadowDecorator(int n, int n2, int n3) {
        this.blurRadius = n;
        this.xOffset = n2;
        this.yOffset = n3;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    public final void setShadowColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("shadowColor is null.");
        }
        this.setShadowColor(GraphicsUtilities.decodeColor(string));
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float f) {
        this.shadowOpacity = f;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public void setBlurRadius(int n) {
        this.blurRadius = n;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int n) {
        this.yOffset = n;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (n > 0 && n2 > 0) {
            if (this.shadowImage == null || this.shadowImage.getWidth() != n + 2 * this.blurRadius || this.shadowImage.getHeight() != n2 + 2 * this.blurRadius) {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                graphics2D2.setColor(Color.BLACK);
                graphics2D2.fillRect(0, 0, n, n2);
                graphics2D2.dispose();
                this.shadowImage = this.createShadow(bufferedImage);
            }
            graphics2D.drawImage((Image)this.shadowImage, this.xOffset - this.blurRadius, this.yOffset - this.blurRadius, null);
        } else {
            this.shadowImage = null;
        }
        return graphics2D;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(this.xOffset - this.blurRadius, this.yOffset - this.blurRadius, component.getWidth() + this.blurRadius * 2, component.getHeight() + this.blurRadius * 2);
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }

    private BufferedImage createShadow(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.blurRadius * 2;
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        int n10 = n8 + n7;
        int n11 = n9 + n7;
        int n12 = this.blurRadius;
        int n13 = n7 - n12;
        int n14 = n11 - n13;
        int n15 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n7];
        BufferedImage bufferedImage2 = new BufferedImage(n10, n11, 2);
        int[] nArray2 = new int[n10 * n11];
        int[] nArray3 = new int[n8 * n9];
        WritableRaster writableRaster = bufferedImage.getRaster();
        writableRaster.getDataElements(0, 0, n8, n9, nArray3);
        int n16 = n13 * n10;
        float f = 1.0f / (float)n7;
        float f2 = this.shadowOpacity / (float)n7;
        int[] nArray4 = new int[256 * n7];
        for (int i = 0; i < nArray4.length; ++i) {
            nArray4[i] = (int)((float)i * f);
        }
        int[] nArray5 = new int[256 * n7];
        for (n6 = 0; n6 < nArray5.length; ++n6) {
            nArray5[n6] = (int)((float)n6 * f2);
        }
        int n17 = n12 * n10;
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = 0;
            while (n4 < n7) {
                nArray[n4++] = 0;
            }
            n3 = 0;
            n4 = 0;
            n6 = n5 * n8;
            for (n2 = 0; n2 < n8; ++n2) {
                n = nArray4[n3];
                nArray2[n17++] = n << 24;
                n3 -= nArray[n4];
                nArray[n4] = n = nArray3[n6 + n2] >>> 24;
                n3 += n;
                if (++n4 < n7) continue;
                n4 -= n7;
            }
            for (n2 = 0; n2 < n7; ++n2) {
                n = nArray4[n3];
                nArray2[n17++] = n << 24;
                n3 -= nArray[n4];
                if (++n4 < n7) continue;
                n4 -= n7;
            }
        }
        n5 = 0;
        n17 = 0;
        while (n5 < n10) {
            n3 = 0;
            n4 = 0;
            while (n4 < n12) {
                nArray[n4++] = 0;
            }
            n2 = 0;
            while (n2 < n13) {
                n = nArray2[n17] >>> 24;
                nArray[n4++] = n;
                n3 += n;
                ++n2;
                n17 += n10;
            }
            n17 = n5;
            n4 = 0;
            n2 = 0;
            while (n2 < n14) {
                n = nArray5[n3];
                nArray2[n17] = n << 24 | n15;
                n3 -= nArray[n4];
                nArray[n4] = n = nArray2[n17 + n16] >>> 24;
                n3 += n;
                if (++n4 >= n7) {
                    n4 -= n7;
                }
                ++n2;
                n17 += n10;
            }
            n2 = n14;
            while (n2 < n11) {
                n = nArray5[n3];
                nArray2[n17] = n << 24 | n15;
                n3 -= nArray[n4];
                if (++n4 >= n7) {
                    n4 -= n7;
                }
                ++n2;
                n17 += n10;
            }
            n17 = ++n5;
        }
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        writableRaster2.setDataElements(0, 0, n10, n11, nArray2);
        return bufferedImage2;
    }
}

