/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class FadeDecorator
implements Decorator {
    private float opacity;

    public FadeDecorator() {
        this(0.5f);
    }

    public FadeDecorator(float f) {
        this.opacity = f;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("opacity must be a value between 0 and 1, inclusive.");
        }
        this.opacity = f;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        return graphics2D;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

