/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class ReflectionDecorator
implements Decorator {
    private Component component = null;
    private Graphics2D graphics = null;
    private BufferedImage componentImage = null;
    private Graphics2D componentImageGraphics = null;

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        this.component = component;
        this.graphics = graphics2D;
        int n = component.getWidth();
        int n2 = component.getHeight();
        this.componentImage = new BufferedImage(n, n2, 2);
        this.componentImageGraphics = this.componentImage.createGraphics();
        this.componentImageGraphics.setComposite(AlphaComposite.Clear);
        this.componentImageGraphics.fillRect(0, 0, this.componentImage.getWidth(), this.componentImage.getHeight());
        this.componentImageGraphics.setComposite(AlphaComposite.SrcOver);
        return this.componentImageGraphics;
    }

    @Override
    public void update() {
        this.graphics.drawImage((Image)this.componentImage, 0, 0, null);
        int n = this.componentImage.getWidth();
        int n2 = this.componentImage.getHeight();
        GradientPaint gradientPaint = new GradientPaint(0.0f, (float)n2 / 4.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), 0.0f, n2, new Color(1.0f, 1.0f, 1.0f, 0.5f));
        this.componentImageGraphics.setPaint(gradientPaint);
        this.componentImageGraphics.setComposite(AlphaComposite.DstIn);
        this.componentImageGraphics.fillRect(0, 0, n, n2);
        this.componentImageGraphics.dispose();
        this.componentImageGraphics = null;
        this.componentImage.flush();
        this.graphics.transform(this.getTransform(this.component));
        this.graphics.drawImage((Image)this.componentImage, 0, 0, null);
        this.componentImage = null;
        this.component = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight() * 2);
    }

    @Override
    public AffineTransform getTransform(Component component) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -(component.getHeight() * 2));
        return affineTransform;
    }
}

