/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class RotationDecorator
implements Decorator {
    private double theta;

    public RotationDecorator() {
        this(0.0);
    }

    public RotationDecorator(double d) {
        this.setTheta(d);
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        this.theta = d;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        graphics2D.rotate(this.theta, (double)component.getWidth() * 0.5, (double)component.getHeight() * 0.5);
        return graphics2D;
    }

    @Override
    public void update() {
    }

    @Override
    public Bounds getBounds(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        double d = Math.abs(Math.sin(this.theta));
        double d2 = Math.abs(Math.cos(this.theta));
        int n3 = (int)Math.ceil((double)n2 * d + (double)n * d2);
        int n4 = (int)Math.ceil((double)n2 * d2 + (double)n * d);
        int n5 = (int)Math.floor((double)(n - n3) * 0.5);
        int n6 = (int)Math.floor((double)(n2 - n4) * 0.5);
        return new Bounds(n5, n6, n3, n4);
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return AffineTransform.getRotateInstance(this.theta, (double)component.getWidth() * 0.5, (double)component.getHeight() * 0.5);
    }
}

