/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class SaturationDecorator
implements Decorator {
    private float multiplier;
    private Graphics2D graphics = null;
    private BufferedImage componentImage = null;
    private Graphics2D componentGraphics = null;

    public SaturationDecorator() {
        this(1.0f);
    }

    public SaturationDecorator(float f) {
        this.multiplier = f;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float f) {
        this.multiplier = f;
    }

    public void setMultiplier(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Multiplier is null.");
        }
        this.setMultiplier(number.floatValue());
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        this.componentImage = new BufferedImage(n3, n4, 2);
        this.graphics = graphics2D;
        this.componentGraphics = this.componentImage.createGraphics();
        this.componentGraphics.translate(-n, -n2);
        this.componentGraphics.setClip(graphics2D.getClip());
        return this.componentGraphics;
    }

    @Override
    public void update() {
        int n;
        int n2;
        int n3 = this.componentImage.getWidth();
        int n4 = this.componentImage.getHeight();
        int[] nArray = new int[n3 * n4];
        WritableRaster writableRaster = this.componentImage.getRaster();
        writableRaster.getDataElements(0, 0, n3, n4, nArray);
        float[] fArray = new float[3];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n5 = nArray[n2 * n3 + n];
                Color.RGBtoHSB(n5 >> 16 & 0xFF, n5 >> 8 & 0xFF, n5 & 0xFF, fArray);
                int n6 = Color.HSBtoRGB(fArray[0], Math.min(Math.max(fArray[1] * this.multiplier, 0.0f), 1.0f), fArray[2]);
                nArray[n2 * n3 + n] = n6 = n5 & 0xFF000000 | n6 & 0xFFFFFF;
            }
        }
        writableRaster.setDataElements(0, 0, n3, n4, nArray);
        n2 = 0;
        n = 0;
        Rectangle rectangle = this.componentGraphics.getClipBounds();
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.y;
        }
        this.componentGraphics.dispose();
        this.componentGraphics = null;
        this.graphics.drawImage((Image)this.componentImage, n2, n, null);
        this.componentImage = null;
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

