/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.effects.Decorator;

public class TagDecorator
implements Decorator {
    private Visual tag;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private int xOffset;
    private int yOffset;
    private Graphics2D graphics = null;
    private Bounds bounds = null;

    public TagDecorator() {
        this(null);
    }

    public TagDecorator(Visual visual) {
        this(visual, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 0, 0);
    }

    public TagDecorator(Visual visual, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, int n, int n2) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.tag = visual;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.xOffset = n;
        this.yOffset = n2;
    }

    public Visual getTag() {
        return this.tag;
    }

    public void setTag(Visual visual) {
        this.tag = visual;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    public final void setHorizontalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.setHorizontalAlignment(HorizontalAlignment.valueOf(string.toUpperCase()));
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
    }

    public final void setVerticalAlignment(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.setVerticalAlignment(VerticalAlignment.valueOf(string.toUpperCase()));
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int n) {
        this.yOffset = n;
    }

    @Override
    public Graphics2D prepare(Component component, Graphics2D graphics2D) {
        if (this.tag != null) {
            this.bounds = this.getBounds(component);
            this.graphics = graphics2D;
        }
        return graphics2D;
    }

    @Override
    public void update() {
        if (this.tag != null) {
            this.graphics.translate(this.bounds.x, this.bounds.y);
            this.tag.paint(this.graphics);
        }
        this.graphics = null;
    }

    @Override
    public Bounds getBounds(Component component) {
        Bounds bounds;
        if (this.tag == null) {
            bounds = null;
        } else {
            int n;
            int n2;
            switch (this.horizontalAlignment) {
                case LEFT: {
                    n2 = this.xOffset;
                    break;
                }
                case RIGHT: {
                    n2 = component.getWidth() - this.tag.getWidth() + this.xOffset;
                    break;
                }
                case CENTER: {
                    n2 = (component.getWidth() - this.tag.getWidth()) / 2 + this.xOffset;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            switch (this.verticalAlignment) {
                case TOP: {
                    n = this.yOffset;
                    break;
                }
                case BOTTOM: {
                    n = component.getHeight() - this.tag.getHeight() + this.yOffset;
                    break;
                }
                case CENTER: {
                    n = (component.getHeight() - this.tag.getHeight()) / 2 + this.yOffset;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            bounds = new Bounds(n2, n, this.tag.getWidth(), this.tag.getHeight());
        }
        return bounds;
    }

    @Override
    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

