/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.io.IOTask;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.media.BufferedImageSerializer;
import org.apache.pivot.wtk.media.Drawing;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.media.Picture;
import org.apache.pivot.wtkx.WTKXSerializer;

public abstract class Image
implements Visual {
    protected ImageListenerList imageListeners = new ImageListenerList();

    @Override
    public int getBaseline() {
        return -1;
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public ListenerList<ImageListener> getImageListeners() {
        return this.imageListeners;
    }

    public static Image load(URL uRL) throws TaskExecutionException {
        LoadTask loadTask = new LoadTask(uRL);
        return loadTask.execute();
    }

    public static LoadTask load(URL uRL, TaskListener<Image> taskListener) {
        LoadTask loadTask = new LoadTask(uRL);
        loadTask.execute(taskListener);
        return loadTask;
    }

    public static class LoadTask
    extends IOTask<Image> {
        private URL url = null;
        private static Dispatcher DEFAULT_DISPATCHER = new Dispatcher();

        public LoadTask(URL uRL) {
            this(uRL, DEFAULT_DISPATCHER);
        }

        public LoadTask(URL uRL, Dispatcher dispatcher) {
            super(dispatcher);
            this.url = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image execute() throws TaskExecutionException {
            Image image = null;
            try {
                InputStream inputStream = null;
                try {
                    inputStream = new IOTask.MonitoredInputStream((IOTask)this, (InputStream)new BufferedInputStream(this.url.openStream()));
                    if (this.url.getFile().endsWith("wtkd")) {
                        WTKXSerializer wTKXSerializer = new WTKXSerializer();
                        image = (Drawing)wTKXSerializer.readObject(inputStream);
                    } else {
                        BufferedImageSerializer bufferedImageSerializer = new BufferedImageSerializer();
                        BufferedImage bufferedImage = bufferedImageSerializer.readObject(inputStream);
                        image = new Picture(bufferedImage);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                throw new TaskExecutionException((Throwable)iOException);
            }
            catch (SerializationException serializationException) {
                throw new TaskExecutionException((Throwable)serializationException);
            }
            return image;
        }
    }

    protected static class ImageListenerList
    extends ListenerList<ImageListener>
    implements ImageListener {
        protected ImageListenerList() {
        }

        @Override
        public void sizeChanged(Image image, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageListener imageListener = (ImageListener)iterator.next();
                imageListener.sizeChanged(image, n, n2);
            }
        }

        @Override
        public void baselineChanged(Image image, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageListener imageListener = (ImageListener)iterator.next();
                imageListener.baselineChanged(image, n);
            }
        }

        @Override
        public void regionUpdated(Image image, int n, int n2, int n3, int n4) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageListener imageListener = (ImageListener)iterator.next();
                imageListener.regionUpdated(image, n, n2, n3, n4);
            }
        }
    }
}

