/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.media.drawing.LineListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class Line
extends Shape2D {
    private Line2D.Float line2D = new Line2D.Float();
    private LineListenerList lineListeners = new LineListenerList();

    public int getX1() {
        return (int)this.line2D.x1;
    }

    public void setX1(int n) {
        this.setEndpoints(n, this.getY1(), this.getX2(), this.getY2());
    }

    public int getY1() {
        return (int)this.line2D.y1;
    }

    public void setY1(int n) {
        this.setEndpoints(this.getX1(), n, this.getX2(), this.getY2());
    }

    public int getX2() {
        return (int)this.line2D.x2;
    }

    public void setX2(int n) {
        this.setEndpoints(this.getX1(), this.getY1(), n, this.getY2());
    }

    public int getY2() {
        return (int)this.line2D.y2;
    }

    public void setY2(int n) {
        this.setEndpoints(this.getX1(), this.getY1(), this.getX2(), n);
    }

    public Point getEndpoint1() {
        return new Point(this.getX1(), this.getY1());
    }

    public Point getEndpoint2() {
        return new Point(this.getX2(), this.getY2());
    }

    public void setEndpoints(int n, int n2, int n3, int n4) {
        int n5 = (int)this.line2D.x1;
        int n6 = (int)this.line2D.y1;
        int n7 = (int)this.line2D.x2;
        int n8 = (int)this.line2D.y2;
        if (n5 != n || n6 != n2 || n7 != n3 || n8 != n4) {
            this.line2D.x1 = n;
            this.line2D.y1 = n2;
            this.line2D.x2 = n3;
            this.line2D.y2 = n4;
            this.invalidate();
            this.lineListeners.endpointsChanged(this, n5, n6, n7, n8);
        }
    }

    @Override
    public void setFill(Paint paint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStroke(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException();
        }
        super.setStroke(paint);
    }

    @Override
    protected Shape getShape2D() {
        return this.line2D;
    }

    public ListenerList<LineListener> getLineListeners() {
        return this.lineListeners;
    }

    private static class LineListenerList
    extends ListenerList<LineListener>
    implements LineListener {
        private LineListenerList() {
        }

        @Override
        public void endpointsChanged(Line line, int n, int n2, int n3, int n4) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                LineListener lineListener = (LineListener)iterator.next();
                lineListener.endpointsChanged(line, n, n2, n3, n4);
            }
        }
    }
}

