/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.media.drawing.PathListener;
import org.apache.pivot.wtk.media.drawing.Shape2D;

public class Path
extends Shape2D
implements Sequence<Operation> {
    private WindingRule windingRule = WindingRule.NON_ZERO;
    private ArrayList<Operation> operations = new ArrayList();
    private Path2D path2D = new Path2D.Double();
    private PathListenerList pathListeners = new PathListenerList();

    public WindingRule getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(WindingRule windingRule) {
        if (windingRule == null) {
            throw new IllegalArgumentException("windingRule is null");
        }
        WindingRule windingRule2 = this.windingRule;
        if (windingRule2 != windingRule) {
            this.windingRule = windingRule;
            this.path2D.setWindingRule(windingRule.getConstantValue());
            this.update();
            this.pathListeners.windingRuleChanged(this, windingRule2);
        }
    }

    public final void setWindingRule(String string) {
        this.setWindingRule(WindingRule.valueOf(string.toUpperCase()));
    }

    public final int add(Operation operation) {
        int n = this.getLength();
        this.insert(operation, n);
        return n;
    }

    public void insert(Operation operation, int n) {
        if (operation == null) {
            throw new IllegalArgumentException("operation is null.");
        }
        if (n < 0 || n > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (operation.getPath() != null) {
            throw new IllegalArgumentException("operation is already in use by another path.");
        }
        this.operations.insert((Object)operation, n);
        operation.setPath(this);
        this.invalidate();
        this.pathListeners.operationInserted(this, n);
    }

    public Operation update(int n, Operation operation) {
        throw new UnsupportedOperationException();
    }

    public final int remove(Operation operation) {
        int n = this.indexOf(operation);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    public Sequence<Operation> remove(int n, int n2) {
        Sequence sequence = this.operations.remove(n, n2);
        if (n2 > 0) {
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                ((Operation)sequence.get(i)).setPath(null);
            }
            this.invalidate();
            this.pathListeners.operationsRemoved(this, n, (Sequence<Operation>)sequence);
        }
        return sequence;
    }

    public Operation get(int n) {
        return (Operation)this.operations.get(n);
    }

    public int indexOf(Operation operation) {
        return this.operations.indexOf((Object)operation);
    }

    public int getLength() {
        return this.operations.getLength();
    }

    @Override
    protected Shape getShape2D() {
        return this.path2D;
    }

    @Override
    protected void validate() {
        if (!this.isValid()) {
            int n = this.operations.getLength();
            this.path2D = new Path2D.Double(this.windingRule.getConstantValue(), n);
            for (int i = 0; i < n; ++i) {
                Operation operation = (Operation)this.operations.get(i);
                operation.operate(this.path2D);
            }
            this.path2D.closePath();
            super.validate();
        }
    }

    public ListenerList<PathListener> getPathListeners() {
        return this.pathListeners;
    }

    private static class PathListenerList
    extends ListenerList<PathListener>
    implements PathListener {
        private PathListenerList() {
        }

        @Override
        public void windingRuleChanged(Path path, WindingRule windingRule) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PathListener pathListener = (PathListener)iterator.next();
                pathListener.windingRuleChanged(path, windingRule);
            }
        }

        @Override
        public void operationInserted(Path path, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PathListener pathListener = (PathListener)iterator.next();
                pathListener.operationInserted(path, n);
            }
        }

        @Override
        public void operationsRemoved(Path path, int n, Sequence<Operation> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PathListener pathListener = (PathListener)iterator.next();
                pathListener.operationsRemoved(path, n, sequence);
            }
        }

        @Override
        public void operationUpdated(Operation operation) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PathListener pathListener = (PathListener)iterator.next();
                pathListener.operationUpdated(operation);
            }
        }
    }

    public static enum WindingRule {
        NON_ZERO(1),
        EVEN_ODD(0);

        private int constantValue;

        private WindingRule(int n2) {
            this.constantValue = n2;
        }

        private int getConstantValue() {
            return this.constantValue;
        }
    }

    public static final class QuadTo
    extends Operation {
        private int x1;
        private int y1;
        private int x2;
        private int y2;

        public QuadTo() {
            this(0, 0, 0, 0);
        }

        public QuadTo(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
        }

        @Override
        void operate(Path2D path2D) {
            path2D.quadTo(this.x1, this.y1, this.x2, this.y2);
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int n) {
            this.setPoints(n, this.y1, this.x2, this.y2);
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int n) {
            this.setPoints(this.x1, n, this.x2, this.y2);
        }

        public int getX2() {
            return this.x2;
        }

        public void setX2(int n) {
            this.setPoints(this.x1, this.y1, n, this.y2);
        }

        public int getY2() {
            return this.y2;
        }

        public void setY2(int n) {
            this.setPoints(this.x1, this.y1, this.x2, n);
        }

        public void setPoints(int n, int n2, int n3, int n4) {
            if (n != this.x1 || n2 != this.y1 || n3 != this.x2 || n4 != this.y2) {
                this.x1 = n;
                this.y1 = n2;
                this.x2 = n3;
                this.y2 = n4;
                Path path = this.getPath();
                if (path != null) {
                    path.invalidate();
                    path.pathListeners.operationUpdated(this);
                }
            }
        }
    }

    public static final class CurveTo
    extends Operation {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int x3;
        private int y3;

        public CurveTo() {
            this(0, 0, 0, 0, 0, 0);
        }

        public CurveTo(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.x3 = n5;
            this.y3 = n6;
        }

        @Override
        void operate(Path2D path2D) {
            path2D.curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int n) {
            this.setPoints(n, this.y1, this.x2, this.y2, this.x3, this.y3);
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int n) {
            this.setPoints(this.x1, n, this.x2, this.y2, this.x3, this.y3);
        }

        public int getX2() {
            return this.x2;
        }

        public void setX2(int n) {
            this.setPoints(this.x1, this.y1, n, this.y2, this.x3, this.y3);
        }

        public int getY2() {
            return this.y2;
        }

        public void setY2(int n) {
            this.setPoints(this.x1, this.y1, this.x2, n, this.x3, this.y3);
        }

        public int getX3() {
            return this.x3;
        }

        public void setX3(int n) {
            this.setPoints(this.x1, this.y1, this.x2, this.y2, n, this.y3);
        }

        public int getY3() {
            return this.y3;
        }

        public void setY3(int n) {
            this.setPoints(this.x1, this.y1, this.x2, this.y2, this.x3, n);
        }

        public void setPoints(int n, int n2, int n3, int n4, int n5, int n6) {
            if (n != this.x1 || n2 != this.y1 || n3 != this.x2 || n4 != this.y2 || n5 != this.x3 || n6 != this.y3) {
                this.x1 = n;
                this.y1 = n2;
                this.x2 = n3;
                this.y2 = n4;
                this.x3 = n5;
                this.y3 = n6;
                Path path = this.getPath();
                if (path != null) {
                    path.invalidate();
                    path.pathListeners.operationUpdated(this);
                }
            }
        }
    }

    public static final class LineTo
    extends Operation {
        private int x;
        private int y;

        public LineTo() {
            this(0, 0);
        }

        public LineTo(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        @Override
        void operate(Path2D path2D) {
            path2D.lineTo(this.x, this.y);
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.setLocation(n, this.y);
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.setLocation(this.x, n);
        }

        public void setLocation(int n, int n2) {
            if (n != this.x || n2 != this.y) {
                this.x = n;
                this.y = n2;
                Path path = this.getPath();
                if (path != null) {
                    path.invalidate();
                    path.pathListeners.operationUpdated(this);
                }
            }
        }
    }

    public static final class MoveTo
    extends Operation {
        private int x;
        private int y;

        public MoveTo() {
            this(0, 0);
        }

        public MoveTo(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        @Override
        void operate(Path2D path2D) {
            path2D.moveTo(this.x, this.y);
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.setLocation(n, this.y);
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.setLocation(this.x, n);
        }

        public void setLocation(int n, int n2) {
            if (n != this.x || n2 != this.y) {
                this.x = n;
                this.y = n2;
                Path path = this.getPath();
                if (path != null) {
                    path.invalidate();
                    path.pathListeners.operationUpdated(this);
                }
            }
        }
    }

    public static abstract class Operation {
        private Path path = null;

        private Operation() {
        }

        public Path getPath() {
            return this.path;
        }

        private void setPath(Path path) {
            this.path = path;
        }

        abstract void operate(Path2D var1);
    }
}

