/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media.drawing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.media.drawing.Group;
import org.apache.pivot.wtk.media.drawing.ShapeListener;
import org.apache.pivot.wtk.media.drawing.ShapeTransformListener;

public abstract class Shape {
    private Group parent = null;
    private int x = 0;
    private int y = 0;
    private Bounds bounds = null;
    private Bounds transformedBounds = new Bounds(0, 0, 0, 0);
    private Paint fill = null;
    private Paint stroke = Color.BLACK;
    private int strokeThickness = 1;
    private boolean visible = true;
    private ArrayList<Transform> transforms = new ArrayList();
    private TransformSequence transformSequence = new TransformSequence();
    private ShapeListenerList shapeListeners = new ShapeListenerList();
    private ShapeTransformListenerList shapeTransformListeners = new ShapeTransformListenerList();

    public Group getParent() {
        return this.parent;
    }

    protected void setParent(Group group) {
        this.parent = group;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.setOrigin(n, this.y);
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.setOrigin(this.x, n);
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public void setOrigin(int n, int n2) {
        int n3 = this.x;
        int n4 = this.y;
        if (n3 != n || n4 != n2) {
            this.update();
            this.x = n;
            this.y = n2;
            this.update();
            this.shapeListeners.originChanged(this, n3, n4);
        }
    }

    public final void setOrigin(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("origin is null.");
        }
        this.setOrigin(point.x, point.y);
    }

    public Bounds getBounds() {
        this.validate();
        return this.bounds;
    }

    protected void setBounds(int n, int n2, int n3, int n4) {
        this.update();
        this.bounds = new Bounds(n, n2, n3, n4);
        this.transformedBounds = this.transform(n, n2, n3, n4);
        this.update();
    }

    public Bounds getTransformedBounds() {
        this.validate();
        return this.transformedBounds;
    }

    public abstract boolean contains(int var1, int var2);

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        Paint paint2 = this.fill;
        if (paint2 != paint) {
            this.fill = paint;
            this.update();
            this.shapeListeners.fillChanged(this, paint2);
        }
    }

    public final void setFill(String string) {
        if (string == null) {
            throw new IllegalArgumentException("fill is null.");
        }
        this.setFill(string.length() == 0 ? null : GraphicsUtilities.decodePaint(string));
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public void setStroke(Paint paint) {
        Paint paint2 = this.stroke;
        if (paint2 != paint) {
            this.stroke = paint;
            this.update();
            this.shapeListeners.strokeChanged(this, paint2);
        }
    }

    public final void setStroke(String string) {
        if (string == null) {
            throw new IllegalArgumentException("stroke is null.");
        }
        this.setStroke(string.length() == 0 ? null : GraphicsUtilities.decodePaint(string));
    }

    public int getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setStrokeThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.strokeThickness;
        if (n2 != n) {
            this.strokeThickness = n;
            this.invalidate();
            this.shapeListeners.strokeThicknessChanged(this, n2);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.invalidate();
            this.shapeListeners.visibleChanged(this);
        }
    }

    public abstract void draw(Graphics2D var1);

    public TransformSequence getTransforms() {
        return this.transformSequence;
    }

    protected void invalidate() {
        if (this.bounds != null) {
            this.bounds = null;
            if (this.parent != null) {
                this.parent.invalidate();
            }
        }
    }

    protected abstract void validate();

    protected boolean isValid() {
        return this.bounds != null;
    }

    protected final void update() {
        this.update(this.transformedBounds);
    }

    protected final void update(Bounds bounds) {
        this.update(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void update(int n, int n2, int n3, int n4) {
        Bounds bounds = this.transform(n, n2, n3, n4);
        if (this.parent != null) {
            this.parent.update(bounds.x + n, bounds.y + n2, bounds.width, bounds.height);
        }
    }

    private Bounds transform(int n, int n2, int n3, int n4) {
        AffineTransform affineTransform = this.transformSequence.getAffineTransform();
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, n3, n4);
        java.awt.Shape shape = affineTransform.createTransformedShape(double_);
        Rectangle2D rectangle2D = shape.getBounds2D();
        Bounds bounds = new Bounds((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return bounds;
    }

    public ListenerList<ShapeListener> getShapeListeners() {
        return this.shapeListeners;
    }

    public ListenerList<ShapeTransformListener> getShapeTransformListeners() {
        return this.shapeTransformListeners;
    }

    private static class ShapeTransformListenerList
    extends ListenerList<ShapeTransformListener>
    implements ShapeTransformListener {
        private ShapeTransformListenerList() {
        }

        @Override
        public void transformInserted(Shape shape, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeTransformListener shapeTransformListener = (ShapeTransformListener)iterator.next();
                shapeTransformListener.transformInserted(shape, n);
            }
        }

        @Override
        public void transformsRemoved(Shape shape, int n, Sequence<Transform> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeTransformListener shapeTransformListener = (ShapeTransformListener)iterator.next();
                shapeTransformListener.transformsRemoved(shape, n, sequence);
            }
        }

        @Override
        public void transformUpdated(Transform transform) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeTransformListener shapeTransformListener = (ShapeTransformListener)iterator.next();
                shapeTransformListener.transformUpdated(transform);
            }
        }
    }

    private static class ShapeListenerList
    extends ListenerList<ShapeListener>
    implements ShapeListener {
        private ShapeListenerList() {
        }

        @Override
        public void originChanged(Shape shape, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeListener shapeListener = (ShapeListener)iterator.next();
                shapeListener.originChanged(shape, n, n2);
            }
        }

        @Override
        public void strokeChanged(Shape shape, Paint paint) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeListener shapeListener = (ShapeListener)iterator.next();
                shapeListener.strokeChanged(shape, paint);
            }
        }

        @Override
        public void strokeThicknessChanged(Shape shape, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeListener shapeListener = (ShapeListener)iterator.next();
                shapeListener.strokeThicknessChanged(shape, n);
            }
        }

        @Override
        public void fillChanged(Shape shape, Paint paint) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeListener shapeListener = (ShapeListener)iterator.next();
                shapeListener.fillChanged(shape, paint);
            }
        }

        @Override
        public void visibleChanged(Shape shape) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ShapeListener shapeListener = (ShapeListener)iterator.next();
                shapeListener.visibleChanged(shape);
            }
        }
    }

    public class TransformSequence
    extends Transform
    implements Sequence<Transform>,
    Iterable<Transform> {
        private AffineTransform affineTransform;

        public TransformSequence() {
            this.affineTransform = null;
        }

        public int add(Transform transform) {
            int n = this.getLength();
            this.insert(transform, n);
            return n;
        }

        public Transform update(int n, Transform transform) {
            throw new UnsupportedOperationException();
        }

        public void insert(Transform transform, int n) {
            if (transform == null || transform.getShape() != null) {
                throw new IllegalArgumentException();
            }
            transform.setShape(Shape.this);
            Shape.this.transforms.insert((Object)transform, n);
            Shape.this.invalidate();
            this.affineTransform = null;
            Shape.this.shapeTransformListeners.transformInserted(Shape.this, n);
        }

        public int remove(Transform transform) {
            int n = this.indexOf(transform);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Transform> remove(int n, int n2) {
            Sequence sequence = Shape.this.transforms.remove(n, n2);
            if (sequence.getLength() > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Transform transform = (Transform)sequence.get(i);
                    transform.setShape(null);
                }
                Shape.this.invalidate();
                this.affineTransform = null;
                Shape.this.shapeTransformListeners.transformsRemoved(Shape.this, n, (Sequence<Transform>)sequence);
            }
            return sequence;
        }

        public Transform get(int n) {
            return (Transform)Shape.this.transforms.get(n);
        }

        public int indexOf(Transform transform) {
            return Shape.this.transforms.indexOf((Object)transform);
        }

        public int getLength() {
            return Shape.this.transforms.getLength();
        }

        @Override
        public AffineTransform getAffineTransform() {
            if (this.affineTransform == null) {
                this.affineTransform = new AffineTransform();
                for (Transform transform : this) {
                    this.affineTransform.concatenate(transform.getAffineTransform());
                }
            }
            return this.affineTransform;
        }

        @Override
        public Iterator<Transform> iterator() {
            return new ImmutableIterator((Iterator)Shape.this.transforms.iterator());
        }
    }

    public static final class Translate
    extends Transform {
        private double x = 0.0;
        private double y = 0.0;
        private AffineTransform affineTransform = null;

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.setTranslation(d, this.y);
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.setTranslation(this.x, d);
        }

        public void setTranslation(double d, double d2) {
            if (this.x != d || this.y != d2) {
                this.x = d;
                this.y = d2;
                this.affineTransform = null;
                Shape shape = this.getShape();
                if (shape != null) {
                    shape.invalidate();
                    shape.transformSequence.affineTransform = null;
                    shape.shapeTransformListeners.transformUpdated(this);
                }
            }
        }

        @Override
        public AffineTransform getAffineTransform() {
            if (this.affineTransform == null) {
                this.affineTransform = AffineTransform.getTranslateInstance(this.x, this.y);
            }
            return this.affineTransform;
        }
    }

    public static final class Scale
    extends Transform {
        private double x = 0.0;
        private double y = 0.0;
        private AffineTransform affineTransform = null;

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.setScale(d, this.y);
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.setScale(this.x, d);
        }

        public void setScale(double d, double d2) {
            if (this.x != d || this.y != d2) {
                this.x = d;
                this.y = d2;
                this.affineTransform = null;
                Shape shape = this.getShape();
                if (shape != null) {
                    shape.invalidate();
                    shape.transformSequence.affineTransform = null;
                    shape.shapeTransformListeners.transformUpdated(this);
                }
            }
        }

        @Override
        public AffineTransform getAffineTransform() {
            if (this.affineTransform == null) {
                this.affineTransform = AffineTransform.getScaleInstance(this.x, this.y);
            }
            return this.affineTransform;
        }
    }

    public static final class Rotate
    extends Transform {
        private double angle;
        private double anchorX;
        private double anchorY;
        private AffineTransform affineTransform = null;

        public Rotate() {
            this(0.0, 0.0, 0.0);
        }

        public Rotate(double d, double d2, double d3) {
            this.angle = d;
            this.anchorX = d2;
            this.anchorY = d3;
        }

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double d) {
            if (this.angle != d) {
                this.angle = d;
                this.affineTransform = null;
                Shape shape = this.getShape();
                if (shape != null) {
                    shape.invalidate();
                    shape.transformSequence.affineTransform = null;
                    shape.shapeTransformListeners.transformUpdated(this);
                }
            }
        }

        public double getAnchorX() {
            return this.anchorX;
        }

        public void setAnchorX(double d) {
            this.setAnchor(d, this.anchorY);
        }

        public double getAnchorY() {
            return this.anchorY;
        }

        public void setAnchorY(double d) {
            this.setAnchor(this.anchorX, d);
        }

        public void setAnchor(double d, double d2) {
            if (this.anchorX != d || this.anchorY != d2) {
                this.anchorX = d;
                this.anchorY = d2;
                this.affineTransform = null;
                Shape shape = this.getShape();
                if (shape != null) {
                    shape.invalidate();
                    shape.transformSequence.affineTransform = null;
                    shape.shapeTransformListeners.transformUpdated(this);
                }
            }
        }

        @Override
        public AffineTransform getAffineTransform() {
            if (this.affineTransform == null) {
                double d = Math.PI / 180 * this.angle;
                this.affineTransform = AffineTransform.getRotateInstance(d, this.anchorX, this.anchorY);
            }
            return this.affineTransform;
        }
    }

    public static abstract class Transform {
        private Shape shape = null;

        private Transform() {
        }

        public Shape getShape() {
            return this.shape;
        }

        private void setShape(Shape shape) {
            this.shape = shape;
        }

        public abstract AffineTransform getAffineTransform();
    }
}

